/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.MSGHead;

public class MSGPacketExt {
    public MSGHead mheader;
    public int dataLength;
    private byte[] data;

    public MSGPacketExt() {
        this.mheader = new MSGHead();
        this.dataLength = 0;
    }

    public MSGPacketExt(MSGHead head, byte[] data) {
        this(head, data, data != null ? data.length : 0);
    }

    public MSGPacketExt(MSGHead head, byte[] data, int len) {
        if (head == null) {
            throw new IllegalArgumentException("MSGHead is null.");
        }
        this.mheader = head;
        if (data != null && len > 0) {
            int validLen;
            this.mheader.contentLength = validLen = len > data.length ? data.length : len;
            this.data = new byte[validLen];
            this.dataLength = validLen;
            System.arraycopy(data, 0, this.data, 0, validLen);
        } else {
            this.mheader.contentLength = 0;
            this.data = null;
            this.dataLength = 0;
        }
    }

    public byte[] toByte() {
        byte[] packetBytes = new byte[this.mheader.contentLength + 43];
        System.arraycopy(this.mheader.toByte(), 0, packetBytes, 0, 43);
        if (this.data != null && this.data.length > 0) {
            System.arraycopy(this.data, 0, packetBytes, 43, this.data.length);
        }
        return packetBytes;
    }

    public byte[] getData() {
        return this.data;
    }

    public void clearData() {
        this.data = null;
        this.dataLength = 0;
    }

    public int length() {
        if (this.data != null) {
            return 43 + this.data.length;
        }
        return 43;
    }

    public int getCmdCode() {
        if (this.mheader == null) {
            return 0;
        }
        return this.mheader.cmdCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mheader.toString());
        buf.append("dataLength=");
        buf.append(this.dataLength);
        return buf.toString();
    }
}

