/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommUtil;

public class MSGHead
implements Cloneable {
    public static final char INIT_VALUE = '\u0000';
    public static final int HEAD_LEN = 43;
    public byte protocolVer = (byte)10;
    public int senderProcIP;
    public char senderDeskID;
    public char receiverDeskID;
    public char senderProcHandle;
    public char receiverProcHandle;
    public char senderProcID;
    public char receiverProcID;
    public int cmdCode;
    public byte msgType;
    public char errCode;
    public byte commFlag;
    public byte[] reserved = new byte[8];
    public char senderCmdHandle;
    public char cmdHandle;
    public int contentLength;
    public byte senderModule;
    public byte receiverModule;
    private boolean containExtendData = false;
    private int extendDataLength = -1;
    private boolean hasToken = false;
    private byte[] token;
    private boolean isTokenParsed = false;
    static final int PROTOCOL_COMMON = 10;
    static final int PROTOCOL_EXT = 11;
    static final int RESERVED_LEN = 8;
    static final int MODULE_LEN = 2;
    static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public byte[] toByte() {
        byte[] data = new byte[43];
        data[0] = this.protocolVer;
        byte[] bytes = CommUtil.intToBytes(this.senderProcIP);
        data[1] = bytes[0];
        data[2] = bytes[1];
        data[3] = bytes[2];
        data[4] = bytes[3];
        bytes = CommUtil.charToBytes(this.senderDeskID);
        data[5] = bytes[0];
        data[6] = bytes[1];
        bytes = CommUtil.charToBytes(this.receiverDeskID);
        data[7] = bytes[0];
        data[8] = bytes[1];
        bytes = CommUtil.charToBytes(this.senderProcHandle);
        data[9] = bytes[0];
        data[10] = bytes[1];
        bytes = CommUtil.charToBytes(this.receiverProcHandle);
        data[11] = bytes[0];
        data[12] = bytes[1];
        bytes = CommUtil.charToBytes(this.senderProcID);
        data[13] = bytes[0];
        data[14] = bytes[1];
        bytes = CommUtil.charToBytes(this.receiverProcID);
        data[15] = bytes[0];
        data[16] = bytes[1];
        bytes = CommUtil.intToBytes(this.cmdCode);
        data[17] = bytes[0];
        data[18] = bytes[1];
        data[19] = bytes[2];
        data[20] = bytes[3];
        data[21] = this.msgType;
        bytes = CommUtil.charToBytes(this.errCode);
        data[22] = bytes[0];
        data[23] = bytes[1];
        data[24] = this.commFlag;
        System.arraycopy(this.reserved, 0, data, 25, 8);
        bytes = CommUtil.charToBytes(this.senderCmdHandle);
        data[33] = bytes[0];
        data[34] = bytes[1];
        bytes = CommUtil.charToBytes(this.cmdHandle);
        data[35] = bytes[0];
        data[36] = bytes[1];
        bytes = CommUtil.intToBytes(this.contentLength + 2);
        data[37] = bytes[0];
        data[38] = bytes[1];
        data[39] = bytes[2];
        data[40] = bytes[3];
        data[41] = this.senderModule;
        data[42] = this.receiverModule;
        return data;
    }

    public void fromByte(byte[] data) throws IllegalArgumentException {
        if (data.length < 43) {
            throw new IllegalArgumentException("invalid length of MSG:" + new String(data));
        }
        this.protocolVer = data[0];
        byte[] bytes = new byte[4];
        System.arraycopy(data, 1, bytes, 0, 4);
        this.senderProcIP = CommUtil.bytesToInt(bytes);
        this.senderDeskID = CommUtil.bytesToChar(data[5], data[6]);
        this.receiverDeskID = CommUtil.bytesToChar(data[7], data[8]);
        this.senderProcHandle = CommUtil.bytesToChar(data[9], data[10]);
        this.receiverProcHandle = CommUtil.bytesToChar(data[11], data[12]);
        this.senderProcID = CommUtil.bytesToChar(data[13], data[14]);
        this.receiverProcID = CommUtil.bytesToChar(data[15], data[16]);
        System.arraycopy(data, 17, bytes, 0, 4);
        this.cmdCode = CommUtil.bytesToInt(bytes);
        this.msgType = data[21];
        this.errCode = CommUtil.bytesToChar(data[22], data[23]);
        this.commFlag = data[24];
        System.arraycopy(data, 25, this.reserved, 0, 8);
        this.senderCmdHandle = CommUtil.bytesToChar(data[33], data[34]);
        this.cmdHandle = CommUtil.bytesToChar(data[35], data[36]);
        System.arraycopy(data, 37, bytes, 0, 4);
        this.contentLength = CommUtil.bytesToInt(bytes) - 2;
        this.senderModule = data[41];
        this.receiverModule = data[42];
        this.containExtendData = (4 & this.commFlag) > 0;
        this.extendDataLength = CommUtil.bytesToChar(this.reserved[2], this.reserved[3]);
        this.isTokenParsed = false;
        this.token = null;
        this.hasToken = false;
    }

    public boolean hasExtendData() {
        return this.containExtendData;
    }

    public int getExtendDataLength() {
        return this.extendDataLength;
    }

    void parseToken(byte[] data, int contentLength) {
        if (contentLength < this.extendDataLength) {
            this.isTokenParsed = false;
            return;
        }
        this.isTokenParsed = true;
        int i = contentLength - 3;
        while (i >= contentLength - this.extendDataLength) {
            char type = CommUtil.unsignedByteToChar(data[i]);
            if (type == '\u0001') {
                this.token = new byte[data[i - 1]];
                System.arraycopy(data, i - 1 - this.token.length, this.token, 0, this.token.length);
                this.hasToken = true;
                break;
            }
            i = i - 1 - data[i - 1];
        }
    }

    public boolean hasToken() {
        return this.hasToken;
    }

    public byte[] getTokenByte() {
        return this.token;
    }

    public String getTokenString() {
        return this.token != null ? new String(this.token) : null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" CMD=");
        buf.append(this.cmdCode);
        buf.append("; VER=");
        buf.append(this.protocolVer);
        buf.append("; MSGType= ");
        buf.append(CommUtil.MessageType.getMsgTypeString(this.msgType));
        buf.append("; LEN=");
        buf.append(this.contentLength);
        buf.append("; ERR=");
        buf.append((int)this.errCode);
        buf.append("; FLG=");
        buf.append(this.commFlag);
        buf.append(" [SPID=");
        buf.append((int)this.senderProcID);
        buf.append("; SCH=");
        buf.append((int)this.senderCmdHandle);
        buf.append("; SPH=");
        buf.append((int)this.senderProcHandle);
        buf.append("; SM=");
        buf.append(this.senderModule);
        buf.append(']');
        buf.append(" [RPID=");
        buf.append((int)this.receiverProcID);
        buf.append("; RCH=");
        buf.append((int)this.cmdHandle);
        buf.append("; RPH=");
        buf.append((int)this.receiverProcHandle);
        buf.append("; RM=");
        buf.append(this.receiverModule);
        buf.append(']');
        if (this.hasExtendData()) {
            buf.append("; extend data len= ");
            buf.append(this.getExtendDataLength());
            if (this.hasToken && this.token != null) {
                buf.append("; token byte len= ");
                buf.append(this.token.length);
            }
        }
        return buf.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

