/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.ICompressStrategy;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompressStrategy
implements ICompressStrategy {
    private Logger logger = LoggerFactory.getLogger(DefaultCompressStrategy.class);

    public byte[] compress(byte[] message) {
        return message;
    }

    public boolean compressCondition(byte[] pe) {
        return false;
    }

    public byte[] decompress(byte[] message) {
        byte[] outData = new byte[]{};
        if (null != message) {
            int size = message.length * 20;
            Inflater decompresser = null;
            try {
                while (true) {
                    decompresser = new Inflater();
                    decompresser.setInput(message);
                    outData = new byte[size];
                    decompresser.inflate(outData);
                    boolean finish = decompresser.finished();
                    if (finish) {
                        decompresser.end();
                        return outData;
                    }
                    size <<= 1;
                }
            }
            catch (Exception e) {
                this.logger.error(e.toString(), (Throwable)e);
                outData = new byte[]{};
            }
        }
        return outData;
    }

    public boolean decompressCondition(byte[] pe) {
        if (pe.length < 24) {
            return false;
        }
        byte commFlag = pe[24];
        return (commFlag & 8) == 8;
    }
}

