/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommManager;
import com.huawei.communicate.core.CommService;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.info.ProcessInfo;
import java.util.HashMap;
import java.util.Map;

public final class ConnectManager {
    private static Map<ProcessInfo, CommService> connectMap = new HashMap<ProcessInfo, CommService>();

    private ConnectManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommService connect(ProcessInfo procInfo) {
        if (connectMap.containsKey(procInfo)) {
            return connectMap.get(procInfo);
        }
        CommService service = CommManager.getInstance(procInfo).getCommService();
        if (service == null) {
            return null;
        }
        Map<ProcessInfo, CommService> map = connectMap;
        synchronized (map) {
            connectMap.put(procInfo, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommService removeService(ProcessInfo procInfo) {
        Map<ProcessInfo, CommService> map = connectMap;
        synchronized (map) {
            return connectMap.remove(procInfo);
        }
    }

    public static ProcessInfo getDefaultProcessInfo() {
        return Configuration.getInstance().getDefaultProcessInfo();
    }

    public static CommService getCommService(ProcessInfo info) {
        return connectMap.get(info);
    }
}

