/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.info.MDPInfo;
import com.huawei.communicate.core.info.ProcessInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static final String MDP_IP = "MDPIP";
    public static final String MDP_PORT = "MDPPort";
    public static final String MDP_SSL_PORT = "MDPSSLPort";
    public static final String PROC_ID = "ProcID";
    public static final String PROC_HANDLE = "ProcHandle";
    public static final String PROC_NAME = "ProcName";
    public static final String SSL_MODE_FLAG = "SSLMode";
    public static final String SSL_CERT_FILE_PATH = "SSLCertFilePath";
    public static final String SSL_OPTION_FILE_NAME = "SSLOptionFileName";
    public static final int NORMAL_MODE = 0;
    public static final int SSL_MODE = 1;
    private static Map<ProcessInfo, MDPInfo> mdpInfoMap = new HashMap<ProcessInfo, MDPInfo>();
    private static ProcessInfo defaultInfo = null;
    private static Configuration instance = null;

    public static synchronized Configuration getInstance() {
        if (null == instance) {
            instance = new Configuration();
        }
        return instance;
    }

    public void configure(String configFilename, boolean ... isDefault) {
        this.configure(this.getURL(configFilename), isDefault);
    }

    public void configure(URL configURL, boolean ... isDefault) {
        Properties properties = this.load(configURL);
        this.configure(properties, isDefault);
    }

    private URL getURL(String configFilename) {
        File file = new File(configFilename);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            logger.error("config failed, configFilename = " + configFilename, (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private Properties load(URL configURL) {
        if (null == configURL) {
            throw new IllegalArgumentException();
        }
        InputStream in = null;
        Properties properties = new Properties();
        try {
            in = configURL.openStream();
            properties.load(in);
        }
        catch (IOException ex) {
            logger.error("config failed, configURL = " + configURL, (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.error("close stream failed", (Throwable)ex);
                }
            }
        }
        return properties;
    }

    public void configure(Properties properties, boolean ... isDefault) {
        logger.info("The properties is :" + properties);
        this.configureMDP(properties, isDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureMDP(Properties mdpProp, boolean ... isDefault) {
        MDPInfo mdpInfo = this.getMDPInfo(mdpProp);
        ProcessInfo info = this.getProcessInfo(mdpProp);
        Map<ProcessInfo, MDPInfo> map = mdpInfoMap;
        synchronized (map) {
            mdpInfoMap.put(info, mdpInfo);
        }
        if (isDefault.length > 0 && isDefault[0]) {
            defaultInfo = info;
        }
    }

    private MDPInfo getMDPInfo(Properties mdpProp) {
        String mdpIP = mdpProp.getProperty(MDP_IP);
        int mdpPort = Integer.parseInt(mdpProp.getProperty(MDP_PORT).trim());
        String mdpSSLPortStr = mdpProp.getProperty(MDP_SSL_PORT);
        int mdpSSLPort = 0;
        if (null != mdpSSLPortStr) {
            mdpSSLPort = Integer.parseInt(mdpSSLPortStr.trim());
        }
        MDPInfo mdpInfo = new MDPInfo(mdpIP, mdpPort, mdpSSLPort);
        return mdpInfo;
    }

    private ProcessInfo getProcessInfo(Properties mdpProp) {
        String procName = mdpProp.getProperty(PROC_NAME);
        Character procID = Character.valueOf((char)Integer.parseInt(mdpProp.getProperty(PROC_ID).trim()));
        Character procHandle = Character.valueOf('\u0000');
        if (null != mdpProp.getProperty(PROC_HANDLE)) {
            procHandle = Character.valueOf((char)Integer.parseInt(mdpProp.getProperty(PROC_HANDLE).trim()));
        }
        return new ProcessInfo(procID.charValue(), procHandle.charValue(), procName);
    }

    public Map<ProcessInfo, MDPInfo> getMdpInfoMap() {
        return mdpInfoMap;
    }

    public ProcessInfo getDefaultProcessInfo() {
        Set<ProcessInfo> infoSet;
        Iterator<ProcessInfo> i$;
        if (null == defaultInfo && (i$ = (infoSet = mdpInfoMap.keySet()).iterator()).hasNext()) {
            ProcessInfo info = i$.next();
            return info;
        }
        return defaultInfo;
    }
}

