/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.MSGPacketExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommUtil {
    private static Logger logger = LoggerFactory.getLogger(CommUtil.class);
    private static final int MAX_UNSIGNED_BYTE = 255;
    private static final int CHAR_BYTES_NUM = 2;
    private static final int INT_BYTES_NUM = 4;
    private static final int ONE_BYTE_BITS = 8;
    private static final int TWO_BYTES_BITS = 16;
    private static final int THREE_BYTES_BITS = 24;
    static final int VALID_PACKET = Integer.MIN_VALUE;

    private CommUtil() {
    }

    public static byte[] charToBytes(char value) {
        byte[] bytes = new byte[]{(byte)(value >> 8), (byte)value};
        return bytes;
    }

    public static char bytesToChar(byte lowByte, byte highByte) {
        return (char)(((lowByte & 0xFF) << 8) + (highByte & 0xFF));
    }

    public static byte charToUnsignedByte(char value) {
        if (value > '\u00ff') {
            logger.warn("Char:" + value + " > 255");
            return (byte)value;
        }
        return (byte)value;
    }

    public static char unsignedByteToChar(byte value) {
        return (char)(value & 0xFF);
    }

    public static byte[] intToBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return bytes;
    }

    public static int bytesToInt(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("bytesToInt(): bytes.length != 4");
        }
        int result = 0;
        result = ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
        return result;
    }

    static int checkValidPacket(MSGPacketExt msg) {
        if (msg.mheader.errCode == '\u0003') {
            CommHandle.logErrCode("Invalid msg with errCode, ", msg);
            return -4;
        }
        if (msg.mheader.errCode == '\u0004') {
            CommHandle.logErrCode("Invalid msg with errCode, ", msg);
            return -5;
        }
        return Integer.MIN_VALUE;
    }

    public static boolean isLastPacket(MSGPacketExt msg) {
        return (msg.mheader.commFlag & 0x80) == 0;
    }

    public static int handleErrorCode(int result) {
        switch (result) {
            case 3: {
                return -4;
            }
            case 4: {
                return -5;
            }
        }
        return result;
    }

    public static interface ErrorCode {
        public static final char IMAP_MDP_DISP_ERROR = '\u0003';
        public static final char IMAP_TMGR_DISP_ERROR = '\u0004';
    }

    public static class MessageType {
        public static final byte REQUESTBROADCAST = 1;
        public static final byte RESPONSEBROADCAST = 2;
        public static final byte REGISTER = 3;
        public static final byte RESTART = 4;
        public static final byte SENDANSWERFRAME = 5;
        public static final byte REQUESTNOTBROADCAST = 6;
        public static final byte RESPONSENOTBROADCAST = 7;
        public static final byte TIMER = 8;
        public static final byte EXIT = 9;
        public static final byte SHAKEHAND = 16;
        public static final byte RECONNECT = 17;
        public static final byte MSG_DISPFAIL_RSP = 27;
        public static final byte MSG_GETRESOURCE = 28;
        public static final byte MSG_SERVER_STATE = 21;

        static String getMsgTypeString(byte type) {
            switch (type) {
                case 1: {
                    return "REQ_BC";
                }
                case 2: {
                    return "RSP_BC";
                }
                case 3: {
                    return "REG";
                }
                case 4: {
                    return "RESTART";
                }
                case 5: {
                    return "HAND_RSP";
                }
                case 6: {
                    return "REQ_NBC";
                }
                case 7: {
                    return "RSP_NBC";
                }
                case 8: {
                    return "TIMER";
                }
                case 9: {
                    return "EXIT";
                }
                case 16: {
                    return "SHAKEHAND";
                }
                case 17: {
                    return "RECONNECT";
                }
                case 27: {
                    return "MSG_DISPFAIL_RSP";
                }
                case 28: {
                    return "MSG_GETRESOURCE";
                }
                case 21: {
                    return "MSG_SERVER_STATE";
                }
            }
            return "Not_Define";
        }
    }

    public static interface SendState {
        public static final int TMGR_DISPATCH_ERROR = -5;
        public static final int MDP_DISPATCH_ERROR = -4;
        public static final int SOCKET_ERROR = -3;
        public static final int DATA_ERROR = -2;
        public static final int TIMEOUT = -1;
        public static final int SUCCESS = 0;
        public static final int INITIAL = 1;
        public static final int WAITING = 2;
        public static final int CANCEL = 3;
    }

    public static class CommState {
        public static final byte SOCKET_FAIL = -1;
        public static final byte NOT_REGISTER = -2;
        public static final byte SOCKET_ERROR = -3;
        public static final byte NOT_CONNECT = -4;
        public static final byte NORMAL = 1;
        public static final byte CLOSED = 2;
    }

    public static interface ProcessID {
        public static final char MDP_PROCESSID = '\u0002';
    }

    public static interface CommNotify {
        public static final char UNCONNECTED = '\u0001';
    }
}

