/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.MsgDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommTimeoutChecker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(CommTimeoutChecker.class);
    private static final int REMOVE_ITEM_FAILED = -1;
    private static final int CHECK_INTERVAL = 1000;
    private static final int ONE_SECOND = 1000;
    private MsgDispatcher dispatcher = null;
    private volatile boolean running = true;
    private Map itemMap = new HashMap();
    private static final AtomicInteger threadNum = new AtomicInteger(0);

    CommTimeoutChecker(MsgDispatcher disp) {
        this.dispatcher = disp;
        this.setName(this.getClass().getName() + threadNum.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Character cmdHandle, int cmdCode, int timeout) {
        if (this.itemMap == null) {
            return;
        }
        CheckItem item = new CheckItem();
        item.cmdHandle = cmdHandle;
        item.cmdCode = cmdCode;
        item.timeout = timeout;
        Map map = this.itemMap;
        synchronized (map) {
            this.itemMap.put(cmdHandle, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeItem(Character cmdHandle) {
        if (this.itemMap == null) {
            return -1;
        }
        CheckItem item = null;
        Map map = this.itemMap;
        synchronized (map) {
            item = (CheckItem)this.itemMap.remove(cmdHandle);
        }
        if (item == null) {
            return -1;
        }
        return item.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshTimeoutValue(int newValue, Character cmdHandle) {
        if (this.itemMap == null) {
            return;
        }
        CheckItem item = null;
        Map map = this.itemMap;
        synchronized (map) {
            item = (CheckItem)this.itemMap.get(cmdHandle);
        }
        if (item != null && newValue > 0) {
            item.timeout = newValue * 1000;
            logger.info("Refresh timeout value, cmdHandle=" + cmdHandle.charValue() + ", newValue=" + newValue);
        } else {
            if (item == null) {
                logger.error("CommTimeoutChecker refreshTimeoutValue failed: CheckItem is null, cmdHandle=" + cmdHandle.charValue());
            }
            if (newValue <= 0) {
                logger.error("CommTimeoutChecker refreshTimeoutValue failed: newValue=" + newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.running) {
                Object object = this;
                synchronized (object) {
                    this.wait(1000L);
                }
                object = this.itemMap;
                synchronized (object) {
                    if (!this.itemMap.isEmpty()) {
                        Iterator list = this.itemMap.values().iterator();
                        CheckItem item = null;
                        boolean isTimeout = false;
                        while (list.hasNext()) {
                            item = (CheckItem)list.next();
                            ++item.count;
                            if (item.count * 1000 < item.timeout + 1000) continue;
                            isTimeout = this.dispatcher.checkTimeout(item.cmdHandle);
                            if (isTimeout) {
                                logger.info("Timeout! First check if MsgDispatcher thread is blocked.");
                                this.dispatcher.timeout(item.cmdCode, item.cmdHandle);
                                list.remove();
                                continue;
                            }
                            item.count = 0;
                        }
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            logger.error("error", (Throwable)ex);
        }
        this.dispatcher = null;
        this.itemMap.clear();
        logger.info("CommTimeoutChecker exited!");
    }

    public void close() {
        this.running = false;
        this.interrupt();
    }

    private static class CheckItem {
        Character cmdHandle;
        int cmdCode;
        int timeout;
        int count = 0;

        private CheckItem() {
        }
    }
}

