/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.commextend.frameutil.TokenUtil;
import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommManager;
import com.huawei.communicate.core.CompressStrategyFactory;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.DataAccepter;
import com.huawei.communicate.core.ICompressStrategy;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.MDPInfo;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.impl.CommServiceAdapterImpl;
import com.huawei.communicate.proxy.impl.NEProxyService;
import java.io.BufferedInputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommReader
extends Thread {
    private Logger logger = LoggerFactory.getLogger(CommReader.class);
    private static final int DEFAULT_BUF_LEN = 66560;
    private static final int UPPER_LIMIT_BUF_LEN = 0x400000;
    private CommHandle m_Handle = null;
    private BufferedInputStream in = null;
    private DataAccepter m_Accepter = null;
    private byte[] byteBuffer = new byte[66560];
    private volatile boolean normalClose = false;
    private static final AtomicInteger threadNum = new AtomicInteger(0);

    CommReader(CommHandle handle, BufferedInputStream input, DataAccepter accepter) {
        this.m_Handle = handle;
        this.in = input;
        this.m_Accepter = accepter;
        this.setName(this.getClass().getName() + threadNum.getAndIncrement());
    }

    void setAccepter(DataAccepter accepter) {
        this.m_Accepter = accepter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MSGHead head = null;
        boolean readHead = true;
        int readLength = 43;
        int contentLength = 0;
        int bufPos = 0;
        try {
            while (true) {
                int len;
                if ((len = this.in.read(this.byteBuffer, bufPos, readLength)) <= 0) {
                    this.logger.error(this.getName() + "|CommReader|run()|Read Error, len=" + len);
                    break;
                }
                if (len < readLength) {
                    readLength -= len;
                    bufPos += len;
                    continue;
                }
                bufPos = 0;
                if (readHead) {
                    head = new MSGHead();
                    head.fromByte(this.byteBuffer);
                    CommHandle.logTrace("From socket;", head);
                    contentLength = head.contentLength;
                    if (contentLength > 0) {
                        readHead = false;
                        readLength = contentLength;
                        if (this.byteBuffer == null || contentLength <= this.byteBuffer.length) continue;
                        this.byteBuffer = new byte[contentLength];
                        continue;
                    }
                }
                if (head.hasExtendData()) {
                    head.parseToken(this.byteBuffer, contentLength);
                }
                if (this.m_Accepter != null) {
                    if (head.hasExtendData()) {
                        this.deliverExtendDataMsg(head, contentLength);
                    } else {
                        MSGPacketExt msgpacketext = new MSGPacketExt(head, this.byteBuffer, contentLength);
                        msgpacketext = this.deCompressData(msgpacketext);
                        this.m_Accepter.sendToDispatch(msgpacketext);
                    }
                }
                if (this.byteBuffer.length > 0x400000) {
                    this.byteBuffer = new byte[66560];
                }
                readHead = true;
                readLength = 43;
                contentLength = 0;
            }
        }
        catch (Exception exp) {
            if (!this.normalClose) {
                this.logger.error("error", (Throwable)exp);
            }
        }
        finally {
            this.abort();
        }
        this.m_Accepter = null;
        this.in = null;
        this.byteBuffer = null;
        this.m_Handle = null;
        this.logger.error(this.getName() + "CommReader exited");
    }

    private void deliverExtendDataMsg(MSGHead head, int contentLength) {
        boolean isTokenValid;
        MSGPacketExt msgpacketext = new MSGPacketExt(head, this.byteBuffer, contentLength - head.getExtendDataLength());
        if (!head.hasToken()) {
            msgpacketext = this.deCompressData(msgpacketext);
            this.m_Accepter.sendToDispatch(msgpacketext);
            return;
        }
        if (!TokenUtil.isTokenInCache((String)head.getTokenString(), (String)CommReader.longToIP(head.senderProcIP))) {
            ProcessInfo localProcess = new ProcessInfo('\u0fa5', '\u0000', "token authenticate virtual process");
            ProcessInfo defaultProcess = Configuration.getInstance().getDefaultProcessInfo();
            MDPInfo mdpinfo = Configuration.getInstance().getMdpInfoMap().get(defaultProcess);
            CommManager cm = CommManager.getInstance(localProcess);
            CommHandle handle = (CommHandle)cm.newCommService(localProcess, mdpinfo);
            CommServiceAdapterImpl adapter = new CommServiceAdapterImpl(handle);
            NEProxyService tokenAuthenticateProxyService = new NEProxyService(adapter);
            isTokenValid = TokenUtil.isValid((String)head.getTokenString(), (IProxyService)tokenAuthenticateProxyService, (String)CommReader.longToIP(head.senderProcIP), (boolean[])new boolean[]{true});
            cm.clear();
        } else {
            isTokenValid = true;
        }
        if (isTokenValid) {
            msgpacketext = this.deCompressData(msgpacketext);
            this.m_Accepter.sendToDispatch(msgpacketext);
        } else {
            this.logger.error("message is refused to be dispatched because of invalid token: cmd = " + head.cmdCode);
        }
    }

    public static String longToIP(int longIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFF) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFF) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFF));
        return sb.toString();
    }

    private void abort() {
        this.logger.error(this.getName() + "come in abort normalClose = " + this.normalClose);
        if (!this.normalClose) {
            this.logger.error(this.getName() + "come in abort");
            this.normalClose = true;
            this.m_Handle.handleError();
        }
    }

    void close() {
        this.normalClose = true;
    }

    private MSGPacketExt deCompressData(MSGPacketExt msgExt) {
        if (null == msgExt) {
            return null;
        }
        ICompressStrategy strategy = CompressStrategyFactory.getCompressStrategy();
        MSGPacketExt unCompressedExt = msgExt;
        if (strategy.decompressCondition(msgExt.mheader.toByte())) {
            int newDataLength;
            this.logger.debug("Decompressing data started ", (Object)unCompressedExt.mheader);
            byte[] unCompressedData = strategy.decompress(msgExt.getData());
            msgExt.mheader.contentLength = newDataLength = unCompressedData.length;
            unCompressedExt = new MSGPacketExt(msgExt.mheader, unCompressedData);
            this.logger.debug("Decompressing data end ", (Object)unCompressedExt.mheader);
        }
        return unCompressedExt;
    }
}

