/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommManageService;
import com.huawei.communicate.core.CommService;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.SSLConnector;
import com.huawei.communicate.core.info.MDPInfo;
import com.huawei.communicate.core.info.ProcessInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommManager
implements CommManageService,
MSGListener {
    private static Logger logger = LoggerFactory.getLogger(CommManager.class);
    private List arrays = new ArrayList();
    private CommHandle comm = null;
    private String proxyServer = null;
    private int proxyPort = -1;
    private String mdpServer = null;
    private int mdpPort = -1;
    private char deskID = '\u0000';
    private static final String PARAM_IP_NAME = "proxyip";
    private static final String PARAM_PORT_NAME = "proxyport";
    static final String PARA_RECCONECT_PROPERTIES_INTERVAL = "interval";
    static final String PARA_RECCONECT_PROPERTIES_MAXTIMES = "maxtimes";
    private static final int ONE_SECOND = 1000;
    private static final int DEFAULT_TIMEOUT = 9;
    private int iTimeout = 9000;
    private SSLConnector sslConnector = null;
    private static Map<ProcessInfo, CommManager> instanceCache = new HashMap<ProcessInfo, CommManager>();
    private ProcessInfo info = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CommManager getInstance(ProcessInfo procInfo) {
        if (instanceCache.containsKey(procInfo)) {
            return instanceCache.get(procInfo);
        }
        CommManager instance = new CommManager(procInfo);
        Map<ProcessInfo, CommManager> map = instanceCache;
        synchronized (map) {
            instanceCache.put(procInfo, instance);
        }
        return instance;
    }

    private CommManager(ProcessInfo procInfo) {
        this.info = procInfo;
    }

    public CommService getCommService() {
        CommService service = this.newCommService(this.info);
        return service;
    }

    private CommService newCommService(ProcessInfo procInfo) {
        return this.newCommService(procInfo, Configuration.getInstance().getMdpInfoMap().get(procInfo));
    }

    CommService newCommService(ProcessInfo procInfo, MDPInfo mdpInfo) {
        try {
            String param1 = System.getProperty(PARAM_IP_NAME);
            String param2 = System.getProperty(PARAM_PORT_NAME);
            if (param1 != null && param2 != null) {
                if (this.comm != null) {
                    if (this.mdpServer.equals(mdpInfo.getIp()) && this.mdpPort == this.getCurPort(mdpInfo) && this.proxyServer.equals(param1) && this.proxyPort == Integer.parseInt(param2)) {
                        return this.comm;
                    }
                    this.comm.close();
                    this.comm = null;
                    this.deskID = '\u0000';
                }
                this.mdpServer = mdpInfo.getIp();
                this.mdpPort = this.getCurPort(mdpInfo);
                this.proxyServer = param1;
                this.proxyPort = Integer.parseInt(param2);
                this.comm = new CommHandle();
                this.comm.setTimeout(this.iTimeout);
                if (this.sslConnector != null) {
                    this.comm.setSSLConnector(this.sslConnector);
                }
                this.comm.connect(this.proxyServer, this.proxyPort, this.mdpServer, this.mdpPort, this.deskID, procInfo, this);
                this.deskID = this.comm.getDesktopID();
                logger.info(new StringBuffer().append("Proxy server proxyServer[").append(this.proxyServer).append("],proxyPort[").append(this.proxyPort).append("]").toString());
            } else {
                if (this.comm != null) {
                    if (this.mdpServer.equals(mdpInfo.getIp()) && this.mdpPort == this.getCurPort(mdpInfo)) {
                        return this.comm;
                    }
                    this.comm.close();
                    this.comm = null;
                    this.deskID = '\u0000';
                }
                this.mdpServer = mdpInfo.getIp();
                this.mdpPort = this.getCurPort(mdpInfo);
                this.comm = new CommHandle();
                this.comm.setTimeout(this.iTimeout);
                if (this.sslConnector != null) {
                    this.comm.setSSLConnector(this.sslConnector);
                }
                this.comm.connect(this.mdpServer, this.mdpPort, this.deskID, procInfo, this);
                this.deskID = this.comm.getDesktopID();
            }
        }
        catch (Exception e) {
            logger.error("getCommService()", (Throwable)e);
            this.comm = null;
        }
        return this.comm;
    }

    public void deleteCommService(CommService service) {
        if (service != this.comm) {
            ((CommHandle)service).close();
        }
    }

    public void addCommListener(MSGListener listener) {
        this.arrays.add(listener);
    }

    public void removeCommListener(MSGListener listener) {
        this.arrays.remove(listener);
    }

    public boolean receiveMessage(MSGPacketExt msg) {
        if (msg.mheader.cmdCode == 1) {
            int size = this.arrays.size();
            for (int i = 0; i < size; ++i) {
                ((MSGListener)this.arrays.get(i)).receiveMessage(msg);
            }
        }
        return true;
    }

    public void timeout(int msgCode, Character cmdHandle) {
    }

    public static void stopAll() {
        Object[] array;
        for (Object obj : array = instanceCache.values().toArray()) {
            if (!(obj instanceof CommManager)) continue;
            ((CommManager)obj).stop();
        }
        instanceCache.clear();
    }

    public void clear() {
        this.arrays.clear();
        if (this.comm != null) {
            this.comm.close();
            this.comm = null;
            this.deskID = '\u0000';
            this.sslConnector = null;
        }
    }

    public void stop() {
        this.clear();
    }

    public void setSSLConnector(SSLConnector sslConnector) {
        this.sslConnector = sslConnector;
    }

    SSLConnector getSSLCopnnector() {
        return this.sslConnector;
    }

    private int getCurPort(MDPInfo mdpInfo) {
        if (null == this.sslConnector) {
            return mdpInfo.getPort();
        }
        return mdpInfo.getSSLPort();
    }
}

