/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.AppAidedMsgListener;
import com.huawei.communicate.core.AppAidedMsgSyncReceiver;
import com.huawei.communicate.core.CmdHandleGenerator;
import com.huawei.communicate.core.CommReader;
import com.huawei.communicate.core.CommRegisterException;
import com.huawei.communicate.core.CommService;
import com.huawei.communicate.core.CommStateEvent;
import com.huawei.communicate.core.CommStateListener;
import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.DataAccepter;
import com.huawei.communicate.core.HandShakeTask;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.MSGSyncReceiver;
import com.huawei.communicate.core.MsgDispatcher;
import com.huawei.communicate.core.Reconnector;
import com.huawei.communicate.core.SSLConnector;
import com.huawei.communicate.core.Sock5MethodRequest;
import com.huawei.communicate.core.Sock5MethodResponse;
import com.huawei.communicate.core.Sock5Request;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.util.threadpool.ThreadPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruEncoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommHandle
implements CommService {
    private static Logger logger = LoggerFactory.getLogger(CommHandle.class);
    private static final int HAND_INTERVAL = 10000;
    private static final int MIN_HANDSHAKE_INTERVAL = 20000;
    private static final int REGISTER_DATA_LEN = 15;
    private static final int MDP_DATA_LEN = 4;
    private static final int MDP_MSGLEN_OFFSET = 5;
    private static final int REGISTER_TIMEOUT = 40000;
    static final int MIN_TIMEOUT = 1000;
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final int DEFAULT_HANDSHAKE_TIMEOUT = 60000;
    private static final int ONE_SECOND = 1000;
    private static final int MSG_SIZE_OVERFLOW = -1;
    private String hostName = null;
    private int hostPort = -1;
    private String remoteIP = null;
    private int remotePort = -1;
    private boolean isProxy = false;
    private volatile Socket socket = null;
    private volatile BufferedInputStream in = null;
    private volatile BufferedOutputStream out = null;
    private volatile DataAccepter dataAccepter = null;
    private volatile CommReader reader = null;
    private volatile MsgDispatcher dispatcher = null;
    int timeout = 30000;
    private volatile Timer shakeTimer = null;
    private volatile HandShakeTask shakeTask = null;
    private volatile char desktopID = '\u0000';
    private volatile char procID = '\u0000';
    private volatile char procHandle = '\u0000';
    private volatile byte state = (byte)-4;
    private volatile MSGListener commListener = null;
    private static volatile int shakeHandTimeOut = 60000;
    private volatile SSLConnector sslConnector = null;
    private volatile boolean isRegistered = false;
    private volatile MSGPacketExt handShakeMsg = null;
    private volatile long lastEchoTime = 0L;
    private volatile CommStateListener stateListener = null;
    private static volatile Reconnector reconnetor = new Reconnector(new Properties());
    private volatile int msgMaxLength = 0x400000;
    private static final int RETRY_COUNT = 3;
    private volatile boolean closed = false;
    private volatile int regCount = 0;
    private volatile boolean handleErrorStarted = false;
    private ReconnectCloseLock closeReconnectLock = new ReconnectCloseLock();

    public void connect(String proxyHost, int proxyPort, String MDPIP, int MDPPort, char desktopID, ProcessInfo procInfo, MSGListener listener) throws IOException, CommRegisterException {
        this.commListener = listener;
        this.isProxy = true;
        this.remoteIP = MDPIP;
        this.remotePort = MDPPort;
        this.connect(proxyHost, proxyPort, desktopID, procInfo);
    }

    public void connect(String host, int port, char desktopID, ProcessInfo procInfo, MSGListener listener) throws IOException, CommRegisterException {
        this.commListener = listener;
        this.isProxy = false;
        this.connect(host, port, desktopID, procInfo);
    }

    public void connect(String hostName, int hostPort, char desktopID, ProcessInfo procInfo) throws IOException, CommRegisterException {
        this.isRegistered = false;
        int retry = 0;
        while (!this.openSocket(hostName, hostPort) && 3 > retry++) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("openSocket()", (Throwable)e);
            }
            if (3 == retry) {
                throw new IOException("Can't open socket or I/O stream");
            }
            logger.error("Failed to connect to MDP, remaining retry count: " + (3 - retry));
        }
        this.desktopID = desktopID;
        this.procID = procInfo.getProcID().charValue();
        this.procHandle = procInfo.getProcHandle().charValue();
        this.dataAccepter = new DataAccepter();
        this.reader.setAccepter(this.dataAccepter);
        this.dispatcher = new MsgDispatcher(this, this.dataAccepter);
        this.dispatcher.start();
        this.state = 1;
        int ret = this.registProcess();
        if (ret != 0 && 3 > this.regCount++) {
            this.close();
            logger.error("Failed to register to MDP, remaining retry count: " + (3 - this.regCount));
            if (3 == this.regCount) {
                throw new CommRegisterException();
            }
            this.connect(hostName, hostPort, desktopID, procInfo);
            return;
        }
        this.regCount = 0;
        this.isRegistered = true;
        this.startHandShake();
        this.hostName = hostName;
        this.hostPort = hostPort;
    }

    private boolean openSocket(String hostName, int hostPort) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("Open socket with ");
            buf.append(hostName);
            buf.append(':');
            buf.append(hostPort);
            logger.info(buf.toString());
            this.socket = this.sslConnector != null ? this.sslConnector.createSSLSocket(hostName, hostPort) : new Socket(hostName, hostPort);
            if (this.socket == null) {
                logger.error("Open socket failed! ");
                return false;
            }
            this.socket.setTcpNoDelay(true);
        }
        catch (IOException ioe) {
            CommHandle.logException(ioe);
            return false;
        }
        catch (Exception e) {
            CommHandle.logException(e);
            return false;
        }
        try {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (Exception e) {
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (Exception e1) {
                CommHandle.logException(e1);
            }
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception e2) {
                CommHandle.logException(e2);
            }
            return false;
        }
        if (this.isProxy && !this.handShakeWithProxy()) {
            this.closeSocket();
            return false;
        }
        this.reader = new CommReader(this, this.in, this.dataAccepter);
        this.reader.start();
        return true;
    }

    private boolean handShakeWithProxy() {
        Sock5MethodRequest methodRequest = null;
        Sock5MethodResponse methodResponse = null;
        Sock5Request connectRequest = null;
        Sock5Request connectResponse = null;
        int maxLen = 10;
        byte[] bytes = new byte[maxLen];
        try {
            methodRequest = new Sock5MethodRequest();
            this.out.write(methodRequest.toByte());
            this.out.flush();
            int len = this.in.read(bytes, 0, 2);
            methodResponse = new Sock5MethodResponse();
            if (len < 2) {
                throw new Exception("request authentic method error!");
            }
            methodResponse.fromByte(bytes);
            if (methodResponse.method == '\u00ff') {
                throw new Exception("request authentic method error!");
            }
            connectRequest = new Sock5Request();
            connectRequest.remoteIp = this.remoteIP;
            connectRequest.port = (short)this.remotePort;
            this.out.write(connectRequest.toByte());
            this.out.flush();
            len = this.in.read(bytes, 0, 10);
            connectResponse = new Sock5Request();
            if (len < 10) {
                throw new Exception("request  connect from proxy error!");
            }
            connectResponse.fromByte(bytes);
            if (connectResponse.command != 0) {
                throw new Exception("request  connect from proxy error!");
            }
        }
        catch (Exception ex) {
            CommHandle.logException(ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registProcess() {
        MSGHead head = new MSGHead();
        head.senderDeskID = this.desktopID;
        head.receiverDeskID = '\u0000';
        head.senderProcHandle = this.procHandle;
        head.receiverProcHandle = '\u0000';
        head.senderProcID = this.procID;
        head.receiverProcID = (char)2;
        head.msgType = this.procHandle == '\u0000' ? (byte)3 : (byte)17;
        head.cmdCode = 0;
        head.contentLength = 15;
        byte[] data = new byte[15];
        MSGPacketExt msg = new MSGPacketExt(head, data);
        MSGSyncReceiver recv = new MSGSyncReceiver();
        this.sendRegisterMessage(msg, recv);
        MSGSyncReceiver mSGSyncReceiver = recv;
        synchronized (mSGSyncReceiver) {
            if (recv.getFlag() == 1) {
                recv.setFlag(2);
                try {
                    recv.wait();
                }
                catch (InterruptedException ex) {
                    CommHandle.logException(ex);
                    recv.setFlag(3);
                }
            }
        }
        int result = recv.getFlag();
        if (result == 0) {
            MSGPacketExt packet = recv.getResult();
            this.procHandle = packet.mheader.receiverProcHandle;
            this.desktopID = packet.mheader.receiverDeskID;
            byte[] lengthBytes = new byte[4];
            System.arraycopy(packet.getData(), 5, lengthBytes, 0, 4);
            this.msgMaxLength = CommUtil.bytesToInt(lengthBytes);
            logger.info("Max length of message:" + this.msgMaxLength);
            StringBuilder buf = new StringBuilder();
            buf.append("Register to MDP success: procID = " + this.procID);
            buf.append(", procHandle = " + this.procHandle);
            logger.info(buf.toString());
            return 0;
        }
        logger.error("Register to MDP failed:" + result);
        return result;
    }

    private void sendRegisterMessage(final MSGPacketExt msg, final MSGSyncReceiver recv) {
        Thread t = new Thread("RegisterMessage Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CommHandle.this.sendAsyncMessage(msg, recv, 40000);
                }
                catch (IOException e) {
                    CommHandle.logException(e);
                    MSGSyncReceiver mSGSyncReceiver = recv;
                    synchronized (mSGSyncReceiver) {
                        recv.setFlag(-3);
                        recv.notifyAll();
                    }
                }
                catch (Exception e) {
                    CommHandle.logException(e);
                    MSGSyncReceiver mSGSyncReceiver = recv;
                    synchronized (mSGSyncReceiver) {
                        recv.setFlag(-2);
                        recv.notifyAll();
                    }
                }
            }
        };
        t.start();
    }

    private void startHandShake() {
        this.shakeTimer = new Timer();
        this.shakeTask = new HandShakeTask(this);
        this.shakeTimer.schedule((TimerTask)this.shakeTask, 10000L, 10000L);
    }

    public int sendMessage(MSGPacketExt msg, MSGSyncReceiver recv) {
        return this.sendMessage(msg, recv, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGPacketExt msg, MSGSyncReceiver recv, int time) {
        if (recv == null) {
            throw new IllegalArgumentException("MSGSyncReceiver is null.");
        }
        MSGSyncReceiver mSGSyncReceiver = recv;
        synchronized (mSGSyncReceiver) {
            int cmd_handle = -1;
            try {
                cmd_handle = this.sendAsyncMessage(msg, recv, time);
                if (cmd_handle == -1) {
                    return -2;
                }
                recv.setFlag(2);
                recv.wait();
            }
            catch (IOException ioerr) {
                CommHandle.logException(ioerr);
                this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
                return -3;
            }
            catch (InterruptedException exp) {
                CommHandle.logException(exp);
            }
            this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
        }
        return recv.getFlag();
    }

    public int sendMessage(MSGPacketExt msg, AppAidedMsgSyncReceiver recv) {
        return this.sendMessage(msg, recv, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGPacketExt msg, AppAidedMsgSyncReceiver recv, int time) {
        if (recv == null) {
            throw new IllegalArgumentException("AppAidedMsgSyncReceiver is null.");
        }
        AppAidedMsgSyncReceiver appAidedMsgSyncReceiver = recv;
        synchronized (appAidedMsgSyncReceiver) {
            int cmd_handle = -1;
            try {
                cmd_handle = this.sendAsyncMessage(msg, (MSGListener)recv, time);
                if (cmd_handle == -1) {
                    return -2;
                }
                recv.setFlag(2);
                recv.wait();
            }
            catch (IOException ioerr) {
                CommHandle.logException(ioerr);
                this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
                return -3;
            }
            catch (InterruptedException exp) {
                CommHandle.logException(exp);
            }
            this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
        }
        return recv.getFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGPacketExt[] msgs, AppAidedMsgSyncReceiver recv, int time) {
        if (recv == null) {
            throw new IllegalArgumentException("AppAidedMsgSyncReceiver is null.");
        }
        AppAidedMsgSyncReceiver appAidedMsgSyncReceiver = recv;
        synchronized (appAidedMsgSyncReceiver) {
            int cmd_handle = -1;
            try {
                cmd_handle = this.sendAsyncMessage(msgs, recv, time);
                if (cmd_handle == -1) {
                    return -2;
                }
                recv.setFlag(2);
                recv.wait();
            }
            catch (IOException ioerr) {
                CommHandle.logException(ioerr);
                this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
                return -3;
            }
            catch (InterruptedException exp) {
                CommHandle.logException(exp);
            }
            this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
        }
        return recv.getFlag();
    }

    public int sendMessage(MSGHead head, FStruct data, MSGSyncReceiver recv) {
        return this.sendMessage(head, data, recv, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGHead head, FStruct data, MSGSyncReceiver recv, int time) {
        if (recv == null) {
            throw new IllegalArgumentException("MSGSyncReceiver is null.");
        }
        MSGSyncReceiver mSGSyncReceiver = recv;
        synchronized (mSGSyncReceiver) {
            int cmd_handle = -1;
            try {
                cmd_handle = this.sendAsyncMessage(head, data, recv, time);
                if (cmd_handle == -1) {
                    return -2;
                }
                recv.setFlag(2);
                recv.wait();
            }
            catch (FStruException asnErr) {
                CommHandle.logException((Exception)((Object)asnErr));
                this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
                return -2;
            }
            catch (IOException ioerr) {
                CommHandle.logException(ioerr);
                this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
                return -3;
            }
            catch (InterruptedException exp) {
                CommHandle.logException(exp);
            }
            this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
        }
        return recv.getFlag();
    }

    public int sendMessage(MSGHead head, FStruct data, AppAidedMsgSyncReceiver recv) {
        return this.sendMessage(head, data, recv, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGHead head, FStruct data, AppAidedMsgSyncReceiver recv, int time) {
        if (recv == null) {
            throw new IllegalArgumentException("AppAidedMsgSyncReceiver is null.");
        }
        AppAidedMsgSyncReceiver appAidedMsgSyncReceiver = recv;
        synchronized (appAidedMsgSyncReceiver) {
            int cmd_handle = -1;
            try {
                cmd_handle = this.sendAsyncMessage(head, data, recv, time);
                if (cmd_handle == -1) {
                    return -2;
                }
                recv.setFlag(2);
                recv.wait();
            }
            catch (FStruException asnErr) {
                CommHandle.logException((Exception)((Object)asnErr));
                return -2;
            }
            catch (IOException ioerr) {
                CommHandle.logException(ioerr);
                this.dispatcher.removeReceiver(Character.valueOf((char)cmd_handle));
                return -3;
            }
            catch (InterruptedException exp) {
                CommHandle.logException(exp);
            }
        }
        return recv.getFlag();
    }

    public short sendAsyncMessage(MSGPacketExt packetExt, MSGListener listener) throws IOException {
        return this.sendAsyncMessage(packetExt, listener, this.timeout);
    }

    public synchronized short sendAsyncMessage(MSGPacketExt packetExt, MSGListener listener, int times) throws IOException {
        if (this.state != 1) {
            logger.error("CommState is abnormal, state=" + this.state);
            throw new IOException();
        }
        if (packetExt == null) {
            throw new IllegalArgumentException("MSGPacketExt is null.");
        }
        if (packetExt.length() > this.getMsgMaxLength()) {
            logger.error("Send failed: message too big! len=" + packetExt.length());
            return -1;
        }
        CmdHandleGenerator.generateForMSGHead(packetExt.mheader);
        char cmdHandle = packetExt.mheader.senderCmdHandle;
        if (listener != null) {
            this.dispatcher.addMessageReceiver(Character.valueOf(cmdHandle), listener, packetExt.mheader.cmdCode, times);
            if (listener instanceof AppAidedMsgListener) {
                ((AppAidedMsgListener)listener).setCmdHandle(cmdHandle);
                ((AppAidedMsgListener)listener).setCommHandle(this);
            }
        }
        packetExt.mheader.senderDeskID = this.desktopID;
        packetExt.mheader.senderProcID = this.procID;
        packetExt.mheader.senderProcHandle = this.procHandle;
        CommHandle.logTrace("To socket;", packetExt.mheader);
        this.out.write(packetExt.toByte());
        this.out.flush();
        return (short)cmdHandle;
    }

    public synchronized short sendAsyncMessage(MSGPacketExt[] packetExts, AppAidedMsgListener listener, int times) throws IOException {
        if (this.state != 1) {
            logger.error("CommState is abnormal, state=" + this.state);
            throw new IOException();
        }
        if (packetExts == null) {
            throw new IllegalArgumentException("MSGPacketExt is null.");
        }
        for (int i = 0; i < packetExts.length; ++i) {
            if (packetExts[i].length() <= this.getMsgMaxLength()) continue;
            logger.error("Send failed: message too big! len=" + packetExts[i].length());
            return -1;
        }
        char cmdHandle = CmdHandleGenerator.generate();
        if (listener != null) {
            this.dispatcher.addMessageReceiver(Character.valueOf(cmdHandle), listener, 0, times);
            listener.setCmdHandle(cmdHandle);
            listener.setCommHandle(this);
        }
        for (int i = 0; i < packetExts.length; ++i) {
            packetExts[i].mheader.senderCmdHandle = cmdHandle;
            packetExts[i].mheader.senderDeskID = this.desktopID;
            packetExts[i].mheader.senderProcID = this.procID;
            packetExts[i].mheader.senderProcHandle = this.procHandle;
            StringBuilder logMsg = new StringBuilder("Write multi messages to socket; the number is: ");
            logMsg.append(i).append(" of ").append(packetExts.length);
            CommHandle.logTrace(logMsg.toString(), packetExts[i].mheader.cmdCode, (short)cmdHandle);
            this.out.write(packetExts[i].toByte());
            this.out.flush();
        }
        return (short)cmdHandle;
    }

    public short sendAsyncMessage(MSGHead head, FStruct data, MSGListener listener) throws FStruException, IOException {
        return this.sendAsyncMessage(head, data, listener, this.timeout);
    }

    public short sendAsyncMessage(MSGHead head, FStruct data, MSGListener listener, int times) throws FStruException, IOException {
        if (this.state != 1) {
            logger.error("CommState is abnormal, state=" + this.state);
            throw new IOException();
        }
        MSGPacketExt packet = null;
        try {
            if (data != null) {
                FStruEncoder enc = new FStruEncoder();
                data.serialize((Encoder)enc);
                enc.finish();
                byte[] dataBytes = enc.toByteArray();
                packet = new MSGPacketExt(head, dataBytes);
            } else {
                packet = new MSGPacketExt(head, null);
            }
        }
        catch (FStruException e) {
            CommHandle.logException((Exception)((Object)e));
            return -2;
        }
        return this.sendAsyncMessage(packet, listener, times);
    }

    final void handshake() {
        long lastTime;
        long curTime;
        long subTime;
        if (this.handShakeMsg == null) {
            this.handShakeMsg = new MSGPacketExt();
            this.handShakeMsg.mheader.senderDeskID = this.desktopID;
            this.handShakeMsg.mheader.receiverDeskID = '\u0000';
            this.handShakeMsg.mheader.senderProcHandle = this.procHandle;
            this.handShakeMsg.mheader.receiverProcHandle = '\u0000';
            this.handShakeMsg.mheader.senderProcID = this.procID;
            this.handShakeMsg.mheader.receiverProcID = (char)2;
            this.handShakeMsg.mheader.msgType = (byte)16;
            this.handShakeMsg.mheader.cmdCode = 0;
            this.handShakeMsg.mheader.senderModule = 0;
            this.handShakeMsg.mheader.receiverModule = 0;
            this.handShakeMsg.mheader.contentLength = 0;
        }
        if ((subTime = (curTime = System.currentTimeMillis()) - (lastTime = this.lastEchoTime)) > 20000L && subTime <= (long)shakeHandTimeOut) {
            try {
                this.sendAsyncMessage(this.handShakeMsg, null);
            }
            catch (IOException e) {
                CommHandle.logException(e);
                logger.error("Failed to send shakehand command to server!");
                ThreadPool.getInstance().execute(new Runnable(){

                    public void run() {
                        if (!CommHandle.this.handleErrorStarted) {
                            CommHandle.this.handleError();
                        }
                    }
                });
            }
        } else if (subTime > (long)shakeHandTimeOut) {
            logger.error("send shakehand command to server timeout! subTime =" + subTime);
            if (this.handleErrorStarted) {
                return;
            }
            ThreadPool.getInstance().execute(new Runnable(){

                public void run() {
                    CommHandle.this.handleError();
                }
            });
        }
    }

    final void refresh() {
        this.lastEchoTime = System.currentTimeMillis();
    }

    public void handleError() {
        if (this.handleErrorStarted) {
            logger.info("come in handleError, but another thread already start a handleError, here just return.");
            return;
        }
        this.handleErrorStarted = true;
        logger.info("come in handleError, procID = " + this.procID);
        this.state = (byte)-3;
        if (this.dispatcher != null) {
            try {
                this.dispatcher.cancelReceivers();
            }
            catch (Exception e) {
                logger.error("cancelReceivers handleError,.", (Throwable)e);
            }
            catch (Error e) {
                logger.error("cancelReceivers handleError,.", (Throwable)e);
            }
        }
        if (!this.isRegistered) {
            logger.info("The CommHandle isn't registered to mdp yet: " + this);
            this.handleErrorStarted = false;
            return;
        }
        if (!reconnetor.reconnect(this)) {
            logger.error("Recconnect failed in handleError.");
            this.close();
        } else {
            logger.info("Reconnect success!");
        }
        this.handleErrorStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconnect() {
        ReconnectCloseLock reconnectCloseLock = this.closeReconnectLock;
        synchronized (reconnectCloseLock) {
            if (this.closed) {
                return false;
            }
        }
        this.stopHandShake();
        this.closeSocket();
        this.isRegistered = false;
        ReconnectCloseLock reconnectCloseLock2 = this.closeReconnectLock;
        synchronized (reconnectCloseLock2) {
            if (this.isClosed()) {
                return false;
            }
            if (!this.openSocket(this.hostName, this.hostPort)) {
                return false;
            }
            this.state = 1;
            int ret = this.registProcess();
            if (ret != 0) {
                this.state = (byte)-3;
                this.closeSocket();
                return false;
            }
        }
        this.isRegistered = true;
        this.startHandShake();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReconnectCloseLock reconnectCloseLock = this.closeReconnectLock;
        synchronized (reconnectCloseLock) {
            this.closed = true;
            if (this.state == 2) {
                logger.info("CommHandle had been closed");
                return;
            }
            this.state = (byte)2;
            this.stopHandShake();
            this.closeSocket();
            if (this.dispatcher != null) {
                this.dispatcher.close();
            }
            if (this.dataAccepter != null) {
                this.dataAccepter.close();
            }
            if (this.commListener != null) {
                MSGPacketExt packet = new MSGPacketExt();
                packet.mheader.msgType = (byte)6;
                packet.mheader.cmdCode = 1;
                this.commListener.receiveMessage(packet);
                this.commListener = null;
            }
            CmdHandleGenerator.reset();
            if (this.regCount == 0) {
                this.sslConnector = null;
            }
        }
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    private void stopHandShake() {
        if (this.shakeTask != null && this.shakeTimer != null) {
            this.shakeTask.cancel();
            this.shakeTimer.cancel();
            this.shakeTask.comm = null;
            this.shakeTask = null;
            this.shakeTimer = null;
        }
    }

    private void closeSocket() {
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (this.sslConnector == null && this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException ex) {
                logger.error("shutdownInput error.", (Throwable)ex);
            }
            catch (UnsupportedOperationException e) {
                logger.error("shutdownInput error.", (Throwable)e);
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException ex) {
                logger.error("shutdownOutput error.", (Throwable)ex);
            }
            catch (UnsupportedOperationException e) {
                logger.error("shutdownOutput error.", (Throwable)e);
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
            this.socket = null;
        }
    }

    public void cancelMessage(MSGSyncReceiver recv) {
        if (recv == null) {
            throw new IllegalArgumentException("recv is null.");
        }
        recv.cancel();
    }

    public void cancelMessage(AppAidedMsgSyncReceiver recv) {
        if (recv == null) {
            throw new IllegalArgumentException("recv is null.");
        }
        recv.cancel();
    }

    public void cancelAsyncMessage(char cmdHandle) {
        this.dispatcher.removeReceiver(Character.valueOf(cmdHandle));
        this.dispatcher.removeTimeoutItem(Character.valueOf(cmdHandle));
    }

    public void cancelAsyncMessage(MSGListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        this.dispatcher.removeReceiver(listener);
        logger.info("CommHandle cancelAsyncMessage, listener:" + listener);
    }

    public void removeMessageListener(int cmdCode) {
        this.dispatcher.removeMessageListener(cmdCode);
    }

    public void removeMessageListener(int cmdCode, MSGListener listener) {
        this.dispatcher.removeMessageListener(cmdCode, listener);
    }

    public void addMessageListener(int cmdCode, MSGListener listener) {
        this.dispatcher.addMessageListener(cmdCode, listener);
    }

    public boolean setTimeout(int time) {
        if (time >= 1000) {
            this.timeout = time;
            return true;
        }
        logger.info("Set timeout failed(time<1000): time=" + time);
        return false;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static void setShakeHandTimeout(int timeout) {
        shakeHandTimeOut = timeout * 1000;
    }

    public void setSSLConnector(SSLConnector sslConnector) {
        if (sslConnector == null) {
            logger.info("SSLConnector is null.");
            return;
        }
        this.sslConnector = sslConnector;
        logger.info("SSLConnector is " + sslConnector.toString());
    }

    public void setStateListener(CommStateListener stateListener) {
        this.stateListener = stateListener;
    }

    public void stateChanged(CommStateEvent event) {
        if (this.stateListener != null) {
            this.stateListener.stateChanged(event);
        }
    }

    public void setReconnector(Reconnector reconnector) {
        reconnetor = reconnector;
    }

    public char getDesktopID() {
        return this.desktopID;
    }

    public char getProcID() {
        return this.procID;
    }

    public char getProcHandle() {
        return this.procHandle;
    }

    public int getLastCmdHandle() {
        return CmdHandleGenerator.getCurrent();
    }

    public char getNextCommandHandle() {
        return (char)(CmdHandleGenerator.getCurrent() + '\u0001');
    }

    public int getMsgMaxLength() {
        return this.msgMaxLength;
    }

    final MsgDispatcher getMsgDispatcher() {
        return this.dispatcher;
    }

    static final void logTrace(String msg, MSGHead mHead) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(mHead.toString());
        logger.info(buf.toString());
    }

    private static void logException(Exception ex) {
        logger.warn("exception", (Throwable)ex);
    }

    static final void logTrace(String msg, MSGPacketExt packetExt) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" cmdCode=");
        buf.append(packetExt.mheader.cmdCode);
        buf.append("; cmdHandle=");
        buf.append((int)packetExt.mheader.cmdHandle);
        buf.append("; msgType=");
        buf.append(packetExt.mheader.msgType);
        buf.append("; contentLength=");
        buf.append(packetExt.dataLength);
        logger.info(buf.toString());
    }

    static final void logTrace(String msg, int cmdCode, int cmdHandle) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" cmdCode=");
        buf.append(cmdCode);
        buf.append(", cmdHandle=");
        buf.append(cmdHandle);
        logger.info(buf.toString());
    }

    static final void logErrCode(String msg, MSGPacketExt packet) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" errCode=");
        buf.append((int)packet.mheader.errCode);
        buf.append(", cmdHandle=");
        buf.append((int)packet.mheader.cmdHandle);
        logger.info(buf.toString());
    }

    private class ReconnectCloseLock {
        private ReconnectCloseLock() {
        }
    }
}

