/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.AppAidedMsgListener;
import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.TimeoutPacket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppAidedMsgSyncReceiver
extends AppAidedMsgListener
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(AppAidedMsgSyncReceiver.class);
    private Thread thread = null;
    private List buf = new ArrayList();
    private volatile boolean running = true;
    private int flag = 1;
    private int msgProcessed = 0;

    public AppAidedMsgSyncReceiver() {
        this.thread = new Thread((Runnable)this, "AppAidedMsgSyncReceiver");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Object packet = null;
        try {
            while (this.running) {
                List list = this.buf;
                synchronized (list) {
                    if (this.buf.size() <= this.msgProcessed) {
                        this.buf.wait();
                        if (this.buf.size() <= this.msgProcessed) {
                            break;
                        }
                    }
                    packet = this.buf.get(this.msgProcessed);
                }
                if (!this.processPacket(packet)) continue;
                break;
            }
        }
        catch (InterruptedException exp) {
            logger.error(this.getClass().getName() + " is interrupted.", (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        this.running = false;
        if (this.buf != null) {
            List list = this.buf;
            synchronized (list) {
                this.buf.clear();
                this.buf.notifyAll();
            }
        }
        this.thread.interrupt();
        this.thread = null;
        logger.info("AppAidedMsgSyncReceiver thread closed: " + this);
    }

    public void reset() {
        this.notifyReceiver(1);
        this.buf.clear();
        this.msgProcessed = 0;
        logger.info("AppAidedMsgSyncReceiver is reset: " + this);
    }

    final void cancel() {
        if (this.flag != 2) {
            logger.error("AppAidedMsgSyncReceiver cancel failed! flag=" + this.flag);
            return;
        }
        this.notifyReceiver(3);
        this.buf.clear();
        this.msgProcessed = 0;
        logger.info("AppAidedMsgSyncReceiver is canceled: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean receiveMessage(MSGPacketExt msg) {
        if (msg != null && this.buf != null) {
            CommHandle.logTrace("AppAidedMsgSyncReceiver.receiveMessage", msg);
            if (this.isValidPacket(msg)) {
                List list = this.buf;
                synchronized (list) {
                    this.buf.add(msg);
                    this.buf.notifyAll();
                }
                return false;
            }
            return true;
        }
        logger.info("AppAidedMsgSyncReceiver.receiveMessage, msg or buf is null");
        return true;
    }

    private boolean isValidPacket(MSGPacketExt msg) {
        int result = CommUtil.checkValidPacket(msg);
        if (result == Integer.MIN_VALUE) {
            return true;
        }
        this.notifyReceiver(result);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPacket(Object packet) {
        if (packet instanceof MSGPacketExt) {
            MSGPacketExt msgPacket = (MSGPacketExt)packet;
            CommHandle.logTrace("AppAidedMsgSyncReceiver processMessage in: ", msgPacket);
            boolean isProcessFinish = this.processMessage(msgPacket);
            CommHandle.logTrace("AppAidedMsgSyncReceiver processMessage out: isProcessFinish = " + isProcessFinish, msgPacket);
            ++this.msgProcessed;
            if (isProcessFinish) {
                this.notifyFinish();
                this.clearTimeoutPacket();
                this.notifyReceiver(0);
                return true;
            }
        } else if (packet == TimeoutPacket.FLAG) {
            List msgPacket = this.buf;
            synchronized (msgPacket) {
                this.buf.remove(this.msgProcessed);
            }
            logger.info("AppAidedMsgSyncReceiver handleTimeout in");
            int result = this.handleTimeout();
            logger.info("AppAidedMsgSyncReceiver handleTimeout out: result = " + result);
            if (result < 0) {
                this.notifyFinish();
                this.notifyReceiver(-1);
                return true;
            }
            if (result > 0) {
                this.refreshTimeoutValue(result);
            }
        }
        return false;
    }

    private synchronized void notifyReceiver(int flag) {
        this.flag = flag;
        this.notifyAll();
    }

    protected boolean processMessage(MSGPacketExt msg) {
        return true;
    }

    protected int handleTimeout() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addTimeoutPacket() {
        if (this.buf != null) {
            List list = this.buf;
            synchronized (list) {
                this.buf.add(TimeoutPacket.FLAG);
                this.buf.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTimeoutPacket() {
        if (this.buf == null) {
            return;
        }
        int bufSize = this.buf.size();
        if (this.msgProcessed < bufSize) {
            List list = this.buf;
            synchronized (list) {
                for (int i = bufSize - 1; i >= this.msgProcessed; --i) {
                    this.buf.remove(i);
                }
            }
        }
    }

    public final MSGPacketExt[] getResults() {
        int size;
        if (this.buf != null && (size = this.buf.size()) > 0) {
            MSGPacketExt[] msgs = new MSGPacketExt[size];
            this.buf.toArray(msgs);
            return msgs;
        }
        return new MSGPacketExt[0];
    }

    public final MSGPacketExt getResult() {
        if (this.buf != null && !this.buf.isEmpty()) {
            return (MSGPacketExt)this.buf.get(0);
        }
        return null;
    }

    public void setFlag(int val) {
        this.flag = val;
    }

    public int getFlag() {
        return this.flag;
    }
}

