/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.AppAidedMsgListener;
import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.TimeoutPacket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppAidedMsgReceiver
extends AppAidedMsgListener
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(AppAidedMsgReceiver.class);
    private Thread thread = null;
    private List buf = new ArrayList();
    private volatile boolean running = true;

    public AppAidedMsgReceiver() {
        this.thread = new Thread((Runnable)this, "AppAidedMsgReceiver");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Object packet = null;
        try {
            while (this.running) {
                List list = this.buf;
                synchronized (list) {
                    if (this.buf.isEmpty()) {
                        this.buf.wait();
                        if (this.buf.isEmpty()) {
                            break;
                        }
                    }
                    packet = this.buf.remove(0);
                }
                if (!this.processPacket(packet)) continue;
                this.notifyFinish();
                this.close();
                break;
            }
        }
        catch (InterruptedException exp) {
            logger.error(this.getClass().getName() + " is interrupted.", (Throwable)exp);
        }
        if (this.buf != null) {
            this.buf.clear();
            this.buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        this.running = false;
        if (this.buf != null) {
            List list = this.buf;
            synchronized (list) {
                this.buf.clear();
                this.buf.notifyAll();
            }
        }
        this.thread.interrupt();
        this.thread = null;
        logger.info("AppAidedMsgReceiver thread closed: " + this + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean receiveMessage(MSGPacketExt msg) {
        if (msg != null && this.buf != null) {
            CommHandle.logTrace("AppAidedMsgReceiver.receiveMessage", msg);
            if (this.isValidPacket(msg) || this.isDispatchInvalidPacket()) {
                List list = this.buf;
                synchronized (list) {
                    this.buf.add(msg);
                    this.buf.notifyAll();
                }
            }
            return false;
        }
        logger.info("AppAidedMsgReceiver.receiveMessage, msg or buf is null");
        return true;
    }

    private boolean isValidPacket(MSGPacketExt msg) {
        int result = CommUtil.checkValidPacket(msg);
        return result == Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addTimeoutPacket() {
        if (this.buf != null) {
            List list = this.buf;
            synchronized (list) {
                this.buf.add(TimeoutPacket.FLAG);
                this.buf.notifyAll();
            }
        }
    }

    private boolean processPacket(Object packet) {
        if (packet instanceof MSGPacketExt) {
            MSGPacketExt msgPacket = (MSGPacketExt)packet;
            CommHandle.logTrace("AppAidedMsgReceiver processMessage in: ", msgPacket);
            boolean isProcessFinish = this.processMessage(msgPacket);
            CommHandle.logTrace("AppAidedMsgReceiver processMessage out: isProcessFinish = " + isProcessFinish, msgPacket);
            if (isProcessFinish) {
                return true;
            }
        } else if (packet == TimeoutPacket.FLAG) {
            logger.info("AppAidedMsgReceiver handleTimeout in");
            int result = this.handleTimeout();
            logger.info("AppAidedMsgReceiver.handleTimeout out: result = " + result);
            if (result < 0) {
                return true;
            }
            if (result > 0) {
                this.refreshTimeoutValue(result);
            }
        }
        return false;
    }

    protected boolean isDispatchInvalidPacket() {
        return false;
    }
}

