/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.core;

import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppAidedMsgListener
implements MSGListener {
    private static Logger logger = LoggerFactory.getLogger(AppAidedMsgListener.class);
    private static final int INVALID_CMD_HANDLE = 0;
    static final int WAIT_NO_TIME = -1;
    static final int WAIT_CURRENT_TIME = 0;
    private CommHandle comm = null;
    private char cmdHandle = '\u0000';

    final void setCommHandle(CommHandle comm) {
        if (comm == null) {
            throw new IllegalArgumentException("AppAidedMsgListener setCommHandle failed: comm is null");
        }
        this.comm = comm;
    }

    final void setCmdHandle(char cmdHandle) {
        if (cmdHandle == '\u0000') {
            throw new IllegalArgumentException("AppAidedMsgListener setCmdHandle failed: cmdHandle is 0");
        }
        this.cmdHandle = cmdHandle;
    }

    protected final void notifyFinish() {
        if (this.comm != null && this.cmdHandle != '\u0000') {
            this.comm.cancelAsyncMessage(this.cmdHandle);
            logger.info("The command is processed finish! cmdHandle=" + this.cmdHandle);
        } else {
            if (this.comm == null) {
                logger.warn("AppAidedMsgListener notifyFinish failed: comm is null.");
            }
            if (this.cmdHandle == '\u0000') {
                logger.warn("AppAidedMsgListener notifyFinish failed: cmdHandle is 0.");
            }
        }
        this.comm = null;
        this.cmdHandle = '\u0000';
    }

    protected final void refreshTimeoutValue(int newValue) {
        if (this.comm != null && this.cmdHandle != '\u0000') {
            this.comm.getMsgDispatcher().refreshTimeoutValue(newValue, Character.valueOf(this.cmdHandle));
        } else {
            if (this.comm == null) {
                logger.warn("AppAidedMsgListener refreshTimeoutValue failed: comm is null.");
            }
            if (this.cmdHandle == '\u0000') {
                logger.warn("AppAidedMsgListener refreshTimeoutValue failed: cmdHandle is 0.");
            }
        }
    }

    public final void timeout(int cmdCode, Character cmdHandle) {
    }

    protected abstract boolean processMessage(MSGPacketExt var1);

    protected abstract int handleTimeout();

    protected abstract void addTimeoutPacket();
}

