/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.asn1;

import com.huawei.communicate.asn1.AsnDevIDList;
import com.huawei.communicate.asn1.AsnFrameProcID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnGetDevOwnerReq
implements FStruct {
    public int userID;
    public AsnDevIDList devIDList = null;
    public AsnFrameProcID neMgrProcID = null;

    public AsnGetDevOwnerReq() {
    }

    public AsnGetDevOwnerReq(AsnGetDevOwnerReq arg) {
        this.userID = arg.userID;
        if (arg.devIDList != null) {
            this.devIDList = new AsnDevIDList(arg.devIDList);
        }
        if (arg.neMgrProcID != null) {
            this.neMgrProcID = new AsnFrameProcID(arg.neMgrProcID);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.userID);
        if (this.devIDList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.devIDList.serialize(enc);
        }
        if (this.neMgrProcID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.neMgrProcID.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.userID = dec.deserializeIntegerAsInt();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.devIDList = new AsnDevIDList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.devIDList.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.neMgrProcID = new AsnFrameProcID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.neMgrProcID.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userID = ");
        os.print(this.userID);
        os.println(',');
        if (this.devIDList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("devIDList = ");
            this.devIDList.print(os, indent + 2);
            os.println(',');
        }
        if (this.neMgrProcID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("neMgrProcID = ");
            this.neMgrProcID.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

