/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.communicate.asn1;

import com.huawei.communicate.asn1.AsnDevIDList;
import com.huawei.communicate.asn1.AsnFrameProcID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDevIDListOfNEMgr
implements FStruct {
    private static final int INVALID = -1;
    public AsnFrameProcID srcProcID = new AsnFrameProcID();
    public AsnDevIDList devIDList = new AsnDevIDList();
    public int ownerType;
    public int procState = -1;
    public AsnFrameProcID snkProcID = null;
    public byte[] server = null;

    public AsnDevIDListOfNEMgr() {
    }

    public AsnDevIDListOfNEMgr(AsnDevIDListOfNEMgr arg) {
        this.srcProcID = new AsnFrameProcID(arg.srcProcID);
        this.devIDList = new AsnDevIDList(arg.devIDList);
        this.ownerType = arg.ownerType;
        if (arg.procState != -1) {
            this.procState = arg.procState;
        }
        if (arg.snkProcID != null) {
            this.snkProcID = new AsnFrameProcID(arg.snkProcID);
        }
        if (arg.server != null) {
            this.server = new byte[arg.server.length];
            System.arraycopy(arg.server, 0, this.server, 0, arg.server.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.srcProcID.serialize(enc);
        this.devIDList.serialize(enc);
        enc.serializeInteger(this.ownerType);
        if (this.procState != -1) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.procState);
        }
        if (this.snkProcID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.snkProcID.serialize(enc);
        }
        if (this.server != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.server);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.srcProcID.deserialize(dec);
        this.devIDList.deserialize(dec);
        this.ownerType = dec.deserializeIntegerAsInt();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.procState = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.snkProcID = new AsnFrameProcID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.snkProcID.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.server = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcProcID = ");
        this.srcProcID.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("devIDList = ");
        this.devIDList.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ownerType = ");
        os.print(this.ownerType);
        os.println(',');
        if (this.procState != -1) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("procState = ");
            os.print(this.procState);
            os.println(',');
        }
        if (this.snkProcID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("snkProcID = ");
            this.snkProcID.print(os, indent + 2);
            os.println(',');
        }
        if (this.server != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("server = ");
            os.print(FStruFormat.convertToString((byte[])this.server));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

