/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.taskmgr;

import com.huawei.commextend.taskmgr.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ThreadPool {
    private boolean isRunning = true;
    private BlockingQueue<Task> requestQueue = new LinkedBlockingQueue<Task>();
    private List<ThreadPoolThread> poolThreads;
    private static Logger log = LoggerFactory.getLogger(ThreadPool.class);

    private ThreadPool(String name, int initPoolSize) {
        this.poolThreads = new ArrayList<ThreadPoolThread>(initPoolSize);
        for (int i = 0; i < initPoolSize; ++i) {
            this.poolThreads.add(new ThreadPoolThread(name, i));
            this.poolThreads.get(i).start();
        }
    }

    void submitRequest(Task target) {
        try {
            this.requestQueue.add(target);
            log.info("put task to queue, the task:" + target);
        }
        catch (Exception e) {
            log.error("Add Task Error!", (Throwable)e);
        }
    }

    void shutdown() {
        log.warn("The Thread is shutdown...");
        this.isRunning = false;
        this.requestQueue.clear();
        this.poolThreads.clear();
    }

    static ThreadPool getNewThreadPool(String name, int initPoolSize) {
        ThreadPool pool = new ThreadPool(name, initPoolSize);
        return pool;
    }

    public BlockingQueue<Task> getRequestQueue() {
        return this.requestQueue;
    }

    private class ThreadPoolThread
    extends Thread {
        private int id = -1;

        public ThreadPoolThread(String name, int id) {
            this.setName(name + "_" + id);
            this.id = id;
        }

        public int getID() {
            return this.id;
        }

        public void run() {
            while (ThreadPool.this.isRunning && !Thread.currentThread().isInterrupted()) {
                try {
                    Task request = (Task)ThreadPool.this.requestQueue.take();
                    if (!ThreadPool.this.isRunning) continue;
                    log.info("start excute task:" + request);
                    request.work();
                    log.info("stop excute task:" + request);
                }
                catch (Exception ex) {
                    log.error("Run task fail!", (Throwable)ex);
                }
            }
            log.warn("the thread is close, isRunning=" + ThreadPool.this.isRunning + ",Thread.currentThread().isInterrupted()=" + Thread.currentThread().isInterrupted());
        }
    }
}

