/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.taskmgr;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.commextend.taskmgr.TaskDescription;
import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.commextend.taskmgr.ThreadPool;
import com.huawei.communicate.core.CmdHandleGenerator;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskMgr {
    private static final int TASKID_NULL = 0;
    private static Logger log = LoggerFactory.getLogger(TaskMgr.class);
    private String name;
    private int taskMgrID;
    private int threadNum;
    private ThreadPool threadPool;
    private Map<Integer, Task> taskMap = new HashMap<Integer, Task>();
    private ProcessInfo prodInfo = null;

    public TaskMgr(int taskMgrID, String name, int threadNum, ProcessInfo procInfo) {
        this.taskMgrID = taskMgrID;
        this.name = name;
        this.threadNum = threadNum;
        this.threadPool = ThreadPool.getNewThreadPool(name, threadNum);
        this.prodInfo = procInfo;
    }

    public void diapatchTask(TaskDescription taskDescription, MSGPacketExt msg) {
        char taskId = msg.mheader.cmdHandle;
        Task task = null;
        task = '\u0000' != taskId ? this.taskMap.get(taskId) : this.createTask(taskDescription);
        if (null == task) {
            log.info("diapatch task fail, the msg is: " + msg.toString());
            return;
        }
        task.setTaskParam(msg, taskDescription);
        this.threadPool.submitRequest(task);
    }

    public Task createTask(TaskDescription taskDescription) {
        if (!TaskDispatcherMgr.isStaticTask(taskDescription.getTaskID())) {
            taskDescription.setTaskID(CmdHandleGenerator.generate());
        }
        return new Task(this, taskDescription.getTaskID(), taskDescription.getTaskClass());
    }

    public void putStaticTask(Task task) {
        if (null == task) {
            log.debug("Task is null!");
            return;
        }
        int taskID = task.getTaskID();
        if (this.taskMap.containsKey(taskID) && log.isDebugEnabled()) {
            log.debug("The static task(taskID = " + taskID + ") has bean register!");
        }
        this.taskMap.put(taskID, task);
    }

    public void putSessionTask(Task task) {
        if (null == task) {
            log.debug("Task is null!");
            return;
        }
        this.taskMap.put(task.getTaskID(), task);
    }

    public void removeTask(int taskID) {
        this.taskMap.remove(taskID);
    }

    public String getName() {
        return this.name;
    }

    public int getTaskMgrID() {
        return this.taskMgrID;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskMgrID = ").append(this.taskMgrID);
        builder.append(",TaskName = ").append(this.name);
        builder.append(",TheadNum = ").append(this.threadNum);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        result = prime * result + this.taskMgrID;
        result = prime * result + this.threadNum;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskMgr other = (TaskMgr)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.taskMgrID == other.taskMgrID && this.threadNum == other.threadNum;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public Map<Integer, Task> getTaskMap() {
        return this.taskMap;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public ProcessInfo getProdInfo() {
        return this.prodInfo;
    }
}

