/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.taskmgr;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.commextend.taskmgr.TaskDes;
import com.huawei.commextend.taskmgr.TaskDescription;
import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.util.receive.ILiteReceiver;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskDispatcherMgr
implements ILiteReceiver {
    private static final int MIN_STATICTASKID = 1;
    private static final int MAX_STATICTASKID = 20;
    private static final int TASKMGRID_NULL = 0;
    private static final int PARAM_NUM2 = 2;
    private static final int PARAM_NUM3 = 3;
    private static final int SUCCESS = 0;
    public static final int REGIST_FAIL = 1107296273;
    private static Logger log = LoggerFactory.getLogger(TaskDispatcherMgr.class);
    private Map<Integer, TaskDescription> cmdTaskDesMap = new Hashtable<Integer, TaskDescription>();
    private Map<Integer, TaskMgr> taskMgrMap = new Hashtable<Integer, TaskMgr>();
    private boolean bInit = false;
    private ProcessInfo procInfo = null;
    private static Map<ProcessInfo, TaskDispatcherMgr> cache = new HashMap<ProcessInfo, TaskDispatcherMgr>();

    private TaskDispatcherMgr(ProcessInfo procInfo) {
        this.procInfo = procInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized TaskDispatcherMgr getInstance(ProcessInfo info) {
        if (cache.keySet().contains(info)) {
            return cache.get(info);
        }
        TaskDispatcherMgr mgr = new TaskDispatcherMgr(info);
        Map<ProcessInfo, TaskDispatcherMgr> map = cache;
        synchronized (map) {
            cache.put(info, mgr);
            return mgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTaskMgr(ProcessInfo info) {
        TaskDispatcherMgr mgr;
        log.info("removeTaskDispatcher, the ProcessInfo=" + info);
        Map<ProcessInfo, TaskDispatcherMgr> map = cache;
        synchronized (map) {
            mgr = cache.remove(info);
        }
        if (null != mgr) {
            mgr.close();
            mgr = null;
        }
    }

    public void init(String configFilename) {
        if (this.bInit) {
            log.info("TaskMgr(procInfo=" + this.procInfo + ") has bean Init.");
            return;
        }
        log.info("Init TaskMgr(ProcInfo=" + this.procInfo + ") Start.....");
        File file = new File(configFilename);
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(file);
            NodeList taskMgrNodeList = doc.getElementsByTagName("TaskMgr");
            this.createTaskMgr(taskMgrNodeList);
            log.info("TaskMgr size = " + this.taskMgrMap.size());
            this.bInit = true;
            log.info("Init TaskMgr End.....");
        }
        catch (Exception e) {
            log.error("Init TaskDispatcherMgr fail!" + e);
        }
    }

    private void createTaskMgr(NodeList taskMgrNodeList) {
        int size = taskMgrNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element taskMgrEle = (Element)taskMgrNodeList.item(i);
            int taskMgrID = Integer.parseInt(taskMgrEle.getAttribute("id"));
            String taskMgrName = taskMgrEle.getAttribute("name");
            int threadnum = Integer.parseInt(taskMgrEle.getAttribute("threadnum"));
            TaskMgr taskMgr = new TaskMgr(taskMgrID, taskMgrName, threadnum, this.procInfo);
            this.taskMgrMap.put(taskMgrID, taskMgr);
            log.info("Add TaskMgr:" + taskMgr.toString());
        }
    }

    public int registerTask(Class taskClass) {
        if (!this.bInit) {
            log.info("TaskMgr(ProcInfo=" + this.procInfo + ") not init.");
            return 1107296273;
        }
        boolean isDoTaskMethod = false;
        Method[] method = taskClass.getMethods();
        Class<?> reqClass = null;
        Class<?> rspClass = null;
        log.info("Start registerTask, ProcInfo = " + this.procInfo + ",Class = " + taskClass.getName());
        for (int i = 0; i < method.length; ++i) {
            isDoTaskMethod = method[i].isAnnotationPresent(TaskDes.class);
            if (!isDoTaskMethod) continue;
            TaskDes taskDes = method[i].getAnnotation(TaskDes.class);
            int taskMgrID = taskDes.taskmgrID();
            int taskID = taskDes.taskID();
            int cmdCode = taskDes.cmdCode();
            try {
                IProxyService proxySer;
                if (!this.isValidateMethod(method[i])) continue;
                Class<?>[] paramTypes = method[i].getParameterTypes();
                reqClass = paramTypes[0];
                rspClass = null;
                if (paramTypes.length == 3) {
                    rspClass = paramTypes[1];
                }
                if (this.cmdTaskDesMap.containsKey(cmdCode)) {
                    log.error("The cmdcode had bean register,the cmdcode=" + cmdCode + "the register class is :" + this.cmdTaskDesMap.get(cmdCode).getClass().getName());
                    continue;
                }
                TaskDescription taskDesObj = new TaskDescription(taskClass, taskMgrID, taskID, cmdCode, reqClass, rspClass, method[i]);
                this.cmdTaskDesMap.put(cmdCode, taskDesObj);
                if (TaskDispatcherMgr.isStaticTask(taskID)) {
                    TaskMgr taskMgr = this.taskMgrMap.get(taskMgrID);
                    if (null == taskMgr) {
                        log.info("Static task register fail,The task descriptin is:" + taskDes.toString());
                    } else {
                        taskMgr.putStaticTask(taskMgr.createTask(taskDesObj));
                    }
                }
                if ((proxySer = MsgProxy.getProxyService((ProcessInfo)this.procInfo)) == null) {
                    log.error("getProxyService is null!");
                    return 1107296273;
                }
                proxySer.addMessageListener(cmdCode, (ILiteReceiver)this);
                log.info("Register cmdCode success, cmdCode = " + cmdCode + ",taskMgrID=" + taskMgrID + ",taskID=" + taskID + "reqClass=" + reqClass.getName() + ",rspClass=" + rspClass + ",method=" + method[i]);
                continue;
            }
            catch (Exception e) {
                log.error("Register task (" + taskDes.toString() + ") fail!", (Throwable)e);
            }
        }
        log.info("End registerTask, ProcInfo = " + this.procInfo + ",Class = " + taskClass.getName());
        return 0;
    }

    public int unRegisterTask(Class<?> taskClass) {
        if (!this.bInit) {
            log.info("TaskMgr(ProcInfo=" + this.procInfo + ") not init.");
            return 1107296273;
        }
        boolean isDoTaskMethod = false;
        Method[] method = taskClass.getMethods();
        for (int i = 0; i < method.length; ++i) {
            TaskMgr taskMgr;
            isDoTaskMethod = method[i].isAnnotationPresent(TaskDes.class);
            if (!isDoTaskMethod) continue;
            TaskDes taskDes = method[i].getAnnotation(TaskDes.class);
            int taskMgrID = taskDes.taskmgrID();
            int taskID = taskDes.taskID();
            int cmdCode = taskDes.cmdCode();
            if (!this.isValidateMethod(method[i])) continue;
            this.cmdTaskDesMap.remove(cmdCode);
            if (TaskDispatcherMgr.isStaticTask(taskID) && null != (taskMgr = this.taskMgrMap.get(taskMgrID))) {
                taskMgr.removeTask(taskMgrID);
            }
            log.info("UnRegister cmdCode success, cmdCode = " + cmdCode);
        }
        return 0;
    }

    private boolean isValidateMethod(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        switch (paramTypes.length) {
            case 2: {
                if (!FStruct.class.isAssignableFrom(paramTypes[0]) || !Task.class.isAssignableFrom(paramTypes[1])) {
                    log.error("Task Method Paramter Types Error, method:" + method.toString());
                    return false;
                }
                return true;
            }
            case 3: {
                if (!(FStruct.class.isAssignableFrom(paramTypes[0]) && FStruct.class.isAssignableFrom(paramTypes[1]) && Task.class.isAssignableFrom(paramTypes[2]))) {
                    log.error("Task Method Paramter Types Error, method:" + method.toString());
                    return false;
                }
                return true;
            }
        }
        log.error("Task Method Paramter Types Error, method:" + method.toString());
        return false;
    }

    public boolean receiveMessage(MSGPacketExt msg) {
        log.debug("The Taskmgr(procInfo=" + this.procInfo + ") receive a Message, msg=" + msg);
        TaskMgr taskMgr = null;
        int cmdCode = msg.getCmdCode();
        int taskMgrId = msg.mheader.receiverModule;
        if (0 == taskMgrId) {
            taskMgrId = this.getModeIDFromCmd(cmdCode);
        }
        if (null == (taskMgr = this.taskMgrMap.get(taskMgrId))) {
            log.debug("Module(" + taskMgrId + ") not register!");
            this.sendErrRsp(msg);
            return true;
        }
        TaskDescription taskDesc = this.cmdTaskDesMap.get(cmdCode);
        if (null == taskDesc) {
            log.debug("CmdCode(" + cmdCode + ") not register!");
            this.sendErrRsp(msg);
            return true;
        }
        taskMgr.diapatchTask(taskDesc, msg);
        return true;
    }

    private void sendErrRsp(MSGPacketExt msg) {
        MSGHead msgHead = MSGHeadBuilder.convertToResoponseMSGHead((MSGHead)msg.mheader);
        msgHead.errCode = (char)4;
        MsgProxy.getProxyService((ProcessInfo)this.procInfo).sendResponseMessage(msgHead, null);
    }

    private int getModeIDFromCmd(int cmdCode) {
        int taskMgrId = 0;
        TaskDescription taskDes = this.cmdTaskDesMap.get(cmdCode);
        if (null != taskDes) {
            taskMgrId = taskDes.getTaskmgrID();
        } else {
            log.info("Cmdcode not register, cmdcode=" + cmdCode);
        }
        return taskMgrId;
    }

    public static boolean isStaticTask(int taskID) {
        return taskID >= 1 && taskID <= 20;
    }

    public void timeout(int cmdCode, Character cmdHandle) {
        log.info("The command timeout,cmdCod:" + cmdCode);
    }

    public void close() {
        log.info("close TaskDispatcherMgr, the ProcessInfo=" + this.procInfo);
        this.cmdTaskDesMap.clear();
        Collection<TaskMgr> taskMgrs = this.taskMgrMap.values();
        for (TaskMgr taskMgr : taskMgrs) {
            taskMgr.getThreadPool().shutdown();
        }
        this.taskMgrMap.clear();
        this.bInit = false;
        cache.clear();
    }

    public void removeDispatchMgr(ProcessInfo info) {
        TaskDispatcherMgr.removeTaskMgr(info);
    }

    public Map<Integer, TaskDescription> getCmdTaskDesMap() {
        return this.cmdTaskDesMap;
    }

    public Map<Integer, TaskMgr> getTaskMgrMap() {
        return this.taskMgrMap;
    }
}

