/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.taskmgr;

import com.huawei.commextend.taskmgr.TaskDescription;
import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.util.asn.AsnCoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    public static final short TASK_STATE_WANTEXIT = 1;
    public static final short TASK_STATE_TIMEEXIT = 2;
    public static final short TASK_STATE_WAITNEXT = 3;
    private static final int SEND_TIME_OUT = 9;
    private static Logger log = LoggerFactory.getLogger(Task.class);
    private int taskStatus = 1;
    private int taskID;
    private TaskMgr taskMgr;
    private MSGPacketExt msg;
    private Method taskMethod;
    private Object taskObject;
    private Class reqClass;
    private Class rspClass;

    public Task(TaskMgr taskMgr, int taskID, Class taskClass) {
        try {
            this.taskMgr = taskMgr;
            this.taskID = taskID;
            this.taskObject = taskClass.newInstance();
        }
        catch (Exception e) {
            log.error("Create task Fail!", (Throwable)e);
        }
    }

    public void setTaskParam(MSGPacketExt msgPacket, TaskDescription taskDescription) {
        this.msg = msgPacket;
        this.taskMethod = taskDescription.getTaskMethod();
        this.reqClass = taskDescription.getReq();
        this.rspClass = taskDescription.getRsp();
    }

    public void work() {
        try {
            FStruct rsp;
            FStruct req = (FStruct)this.reqClass.newInstance();
            AsnCoder.deserialize((MSGPacketExt)this.msg, (FStruct)req);
            if (log.isDebugEnabled()) {
                log.debug("Task.work():" + this.toString());
                log.debug("req class is" + req.getClass().toString());
            }
            if (null == this.rspClass) {
                rsp = null;
                this.taskMethod.invoke(this.taskObject, req, this);
            } else {
                rsp = (FStruct)this.rspClass.newInstance();
                this.taskMethod.invoke(this.taskObject, req, rsp, this);
            }
            if (log.isDebugEnabled()) {
                log.debug("Invoke method succeed!");
            }
            if (null != rsp) {
                if (log.isDebugEnabled()) {
                    log.debug("req class is" + rsp.getClass().toString());
                }
                MSGHead msgHead = MSGHeadBuilder.convertToResoponseMSGHead((MSGHead)this.msg.mheader);
                msgHead.senderModule = (byte)this.taskMgr.getTaskMgrID();
                msgHead.senderCmdHandle = (char)this.taskID;
                int result = MsgProxy.getProxyService((ProcessInfo)this.taskMgr.getProdInfo()).sendResponseMessage(msgHead, rsp, 9);
                if (0 != result) {
                    log.error("Send Response Fail, errorCode:" + result + ",msgHead:" + msgHead);
                }
            }
            if (TaskDispatcherMgr.isStaticTask(this.taskID)) {
                return;
            }
            if (this.taskStatus == 3) {
                this.taskMgr.putSessionTask(this);
            } else {
                this.taskMgr.removeTask(this.taskID);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Do task(" + this.toString() + ") fail!", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error("Do task(" + this.toString() + ") fail!", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("Do task(" + this.toString() + ") fail!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("Do task(" + this.toString() + ") fail!");
            log.error("InvocationTargetException is ", e.getTargetException());
        }
    }

    public int getTaskID() {
        return this.taskID;
    }

    public void setTaskStatus(int status) {
        this.taskStatus = status;
    }

    public int getTaskStatus() {
        return this.taskStatus;
    }

    public TaskMgr getTaskMgr() {
        return this.taskMgr;
    }

    public MSGPacketExt getMsg() {
        return this.msg;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.taskMgr.toString()).append(",TaskID = ").append(this.taskID);
        if (null != this.msg) {
            builder.append(",cmdCode = ").append(this.msg.getCmdCode());
        }
        if (null != this.taskObject) {
            builder.append(",TaskClass = ").append(this.taskObject.toString());
        }
        if (null != this.taskMethod) {
            builder.append(",TaskMethod = ").append(this.taskMethod.getName());
        }
        return builder.toString();
    }
}

