/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.security;

import com.swimap.external.cbb.baseutil.AESCipher;
import com.swimap.external.dsf.cbb.serverutil.ExternalUtil;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Properties;

public class RSAKeyGenerator {
    public static void main(String[] args) {
        System.out.println("Generator RSA KeyPair start...");
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            RSAPublicKey pbkey = (RSAPublicKey)kp.getPublic();
            RSAPrivateCrtKey prkey = (RSAPrivateCrtKey)kp.getPrivate();
            String filePath = "";
            if (args.length > 0) {
                filePath = args[0];
            }
            System.out.println("key path is " + filePath);
            RSAKeyGenerator.saveToFile(filePath + "rsapublic.key", pbkey.getModulus().toString(16), pbkey.getPublicExponent().toString(16));
            RSAKeyGenerator.saveToPriviteFile(filePath + "rsaprivate.key", prkey);
        }
        catch (Exception e) {
            System.out.println("Generator RSA KeyPair fail...");
            e.printStackTrace(System.out);
            return;
        }
        System.out.println("Generator RSA KeyPair success...");
    }

    private static void saveToFile(String fileName, String modStr, String expStr) throws Exception {
        Properties res = new Properties();
        res.setProperty("modulus", modStr);
        res.setProperty("exponent", expStr);
        res.store(new FileOutputStream(fileName), null);
    }

    private static void saveToPriviteFile(String fileName, RSAPrivateCrtKey prkey) throws Exception {
        Properties res = new Properties();
        res.setProperty("modulus", RSAKeyGenerator.encrypt(prkey.getModulus().toString(16)));
        res.setProperty("exponent", RSAKeyGenerator.encrypt(prkey.getPrivateExponent().toString(16)));
        res.setProperty("publicExponent", RSAKeyGenerator.encrypt(prkey.getPublicExponent().toString(16)));
        res.setProperty("primeP", RSAKeyGenerator.encrypt(prkey.getPrimeP().toString(16)));
        res.setProperty("primeQ", RSAKeyGenerator.encrypt(prkey.getPrimeQ().toString(16)));
        res.setProperty("primeExponentP", RSAKeyGenerator.encrypt(prkey.getPrimeExponentP().toString(16)));
        res.setProperty("primeExponentQ", RSAKeyGenerator.encrypt(prkey.getPrimeExponentQ().toString(16)));
        res.setProperty("crtCoefficient", RSAKeyGenerator.encrypt(prkey.getCrtCoefficient().toString(16)));
        res.store(new FileOutputStream(fileName), null);
    }

    private static String encrypt(String plantStr) throws Exception {
        String encryptStr = new String(AESCipher.encrypt((char[])plantStr.toCharArray(), (Key)ExternalUtil.getFixedKey()));
        return encryptStr;
    }
}

