/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.security;

import com.huawei.commextend.frameutil.StrUtil;
import com.huawei.commextend.security.IRSACipherOper;
import com.huawei.commextend.security.RSACipherMgr;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACipherOper
implements IRSACipherOper {
    private static String RSA_Cipher_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static Logger logger = LoggerFactory.getLogger((String)RSACipherOper.class.getName());
    private static final int SLICE_ENCRYPT_LENGTH = 240;
    private static final int MAX_DECRY_LEN = 512;

    public String encrypt(byte[] plainBytes) {
        if (plainBytes == null) {
            logger.info("plainBytes is null");
            return null;
        }
        StringBuilder encryptStr = new StringBuilder();
        int encryCounts = plainBytes.length / 240;
        for (int i = 0; i < encryCounts; ++i) {
            byte[] subBytes = Arrays.copyOfRange(plainBytes, i * 240, i * 240 + 240);
            encryptStr.append(this.encryptOne(subBytes));
        }
        if (plainBytes.length > encryCounts * 240) {
            byte[] subBytes = Arrays.copyOfRange(plainBytes, encryCounts * 240, plainBytes.length);
            encryptStr.append(this.encryptOne(subBytes));
        }
        return encryptStr.toString();
    }

    private String encryptOne(byte[] plainBytes) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_Cipher_ALGORITHM);
            cipher.init(1, RSACipherMgr.getInstance().getPubKey());
            byte[] pwd = cipher.doFinal(plainBytes);
            if (null == pwd) {
                return null;
            }
            return StrUtil.byteArrayToHexString(pwd);
        }
        catch (Exception e) {
            logger.info("encrypt message fail", (Throwable)e);
            return null;
        }
    }

    public byte[] decrypt(String decryHexBytes) {
        if (decryHexBytes.length() > 512) {
            int decryptCounts = decryHexBytes.length() / 512;
            if (decryHexBytes.length() > decryptCounts * 512) {
                ++decryptCounts;
            }
            byte[][] subPlainBytess = new byte[decryptCounts][];
            int plainByteLen = 0;
            for (int i = 0; i < decryptCounts; ++i) {
                String subDecryHex = decryHexBytes.substring(i * 512, i * 512 + 512);
                subPlainBytess[i] = this.decryptOne(subDecryHex);
                plainByteLen += subPlainBytess[i].length;
            }
            byte[] plainByte = new byte[plainByteLen];
            int copPos = 0;
            for (int i = 0; i < decryptCounts; ++i) {
                System.arraycopy(subPlainBytess[i], 0, plainByte, copPos, subPlainBytess[i].length);
                copPos += subPlainBytess[i].length;
            }
            return plainByte;
        }
        return this.decryptOne(decryHexBytes);
    }

    byte[] decryptOne(String decryHexBytes) {
        try {
            Cipher dcipher = Cipher.getInstance(RSA_Cipher_ALGORITHM);
            dcipher.init(2, RSACipherMgr.getInstance().getPrivateKey());
            byte[] decryBytes = StrUtil.hexStringToByteArray(decryHexBytes);
            return dcipher.doFinal(decryBytes);
        }
        catch (Exception e) {
            logger.info("decrypt fail", (Throwable)e);
            return null;
        }
    }
}

