/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.security;

import com.huawei.commextend.frameutil.DBInfoQuery;
import com.huawei.commextend.security.AsnGetRsaKeyReq;
import com.huawei.commextend.security.AsnGetRsaKeyRsp;
import com.huawei.commextend.security.IRSACipherOper;
import com.huawei.commextend.security.RSACipherOper;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACipherMgr {
    private static RSACipherMgr instance = new RSACipherMgr();
    private static char DAM_PROCID = (char)3000;
    private static final int FRAMECMDCODE_GET_NMS_DBINFO = 4193199;
    private static final Logger log = LoggerFactory.getLogger(DBInfoQuery.class);
    private PublicKey pubkey = null;
    private RSAPublicKeySpec pubKeySpec = null;
    private PrivateKey privateKey = null;

    public static RSACipherMgr getInstance() {
        return instance;
    }

    public void initKey() {
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)4193199);
        msgHead.receiverProcID = DAM_PROCID;
        msgHead.receiverProcHandle = '\u0000';
        msgHead.receiverModule = 0;
        AsnGetRsaKeyReq req = new AsnGetRsaKeyReq();
        req.userID = BigInteger.valueOf(10L);
        AsnGetRsaKeyRsp rsp = new AsnGetRsaKeyRsp();
        IProxyService proxyService = MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
        int retcode = proxyService.sendMessage(msgHead, (FStruct)req, (FStruct)rsp);
        if (retcode != 0) {
            log.error("init RSA Key send message fail, msg code is " + retcode);
            return;
        }
        if (rsp.result.intValue() != 0) {
            log.error("init RSA Key dam query fail, resultCode is =" + rsp.result.intValue());
            return;
        }
        String moduleStr = new String(rsp.publicKey.modulus);
        String exponentStr = new String(rsp.publicKey.exponent);
        BigInteger module = new BigInteger(moduleStr, 16);
        BigInteger exponent = new BigInteger(exponentStr, 16);
        this.pubKeySpec = new RSAPublicKeySpec(module, exponent);
        this.setPubKey(this.pubKeySpec);
        String primoduleStr = new String(rsp.privateKey.modulus);
        String priexponentStr = new String(rsp.privateKey.exponent);
        BigInteger primodule = new BigInteger(primoduleStr, 16);
        BigInteger priexponent = new BigInteger(priexponentStr, 16);
        RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(primodule, priexponent);
        this.setPrivateKey(priKeySpec);
    }

    public void setPubKey(RSAPublicKeySpec pubKeySpec) {
        try {
            this.pubKeySpec = pubKeySpec;
            KeyFactory fact = KeyFactory.getInstance("RSA");
            this.pubkey = fact.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            log.error("init PubKey Key fail", (Throwable)e);
        }
    }

    public void setPrivateKey(RSAPrivateKeySpec privateKeySpec) {
        try {
            KeyFactory fact = KeyFactory.getInstance("RSA");
            this.privateKey = fact.generatePrivate(privateKeySpec);
        }
        catch (Exception e) {
            log.error("init PubKey Key fail", (Throwable)e);
        }
    }

    public synchronized RSAPublicKeySpec getPubKeySpec() {
        if (this.pubkey == null) {
            this.initKey();
        }
        return this.pubKeySpec;
    }

    synchronized PublicKey getPubKey() {
        if (this.pubkey == null) {
            this.initKey();
        }
        return this.pubkey;
    }

    synchronized PrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            this.initKey();
        }
        return this.privateKey;
    }

    public IRSACipherOper getCipherOper() {
        return new RSACipherOper();
    }
}

