/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.reliableevent.asn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FormatedOutputStream;

public class AsnGeneralEvent
implements FStruct {
    public BigInteger eventID;
    public BigInteger tunnelID;
    public BigInteger eventState;
    public byte[] eventContent = null;

    public AsnGeneralEvent() {
    }

    public AsnGeneralEvent(AsnGeneralEvent arg) {
        this.eventID = arg.eventID;
        this.tunnelID = arg.tunnelID;
        this.eventState = arg.eventState;
        this.eventContent = new byte[arg.eventContent.length];
        System.arraycopy(arg.eventContent, 0, this.eventContent, 0, arg.eventContent.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.eventID);
        enc.serializeInteger(this.tunnelID);
        enc.serializeInteger(this.eventState);
        if (this.eventContent != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.eventContent);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.eventID = dec.deserializeInteger();
        this.tunnelID = dec.deserializeInteger();
        this.eventState = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.eventContent = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("eventID = ");
        os.print(this.eventID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("tunnelID = ");
        os.print(this.tunnelID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("eventState = ");
        os.print(this.eventState.toString());
        os.println(',');
        if (this.eventContent != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("eventContent = ");
            try {
                new FormatedOutputStream((OutputStream)os).write(this.eventContent);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println();
        for (int ii2 = 0; ii2 < indent; ++ii2) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

