/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.reliableevent;

import com.huawei.commextend.deployment.notifymgr.NotifyHandler;
import com.huawei.commextend.deployment.notifymgr.NotifyMgr;
import com.huawei.commextend.deployment.notifymgr.asn.QAsnDeploymentNotify;
import com.huawei.commextend.reliableevent.DBEventRecord;
import com.huawei.commextend.reliableevent.EventManager;
import com.huawei.commextend.reliableevent.EventStateReg;
import com.huawei.commextend.reliableevent.EventTarget;
import com.huawei.commextend.reliableevent.ReliableDBRWProxy;
import com.huawei.commextend.reliableevent.ReliableEvent;
import com.huawei.commextend.reliableevent.ReliableEventHandler;
import com.huawei.commextend.reliableevent.ReliableEventParam;
import com.huawei.commextend.reliableevent.ReliableEventTask;
import com.huawei.commextend.reliableevent.asn.AsnGeneralEvent;
import com.huawei.commextend.reliableevent.asn.AsnRelaiableEvent;
import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.util.asn.AsnCoder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReliableEventProxy
implements NotifyHandler {
    private static final int SYN_TIME = 120000;
    private static Logger log = LoggerFactory.getLogger(ReliableEventProxy.class);
    private Map<Integer, List<EventTarget>> subscibeReliableEventMap = new Hashtable<Integer, List<EventTarget>>();
    private Map<Integer, List<EventTarget>> subscibeEventMap = new Hashtable<Integer, List<EventTarget>>();
    private Map<Integer, List<Integer>> filterEvents = new Hashtable<Integer, List<Integer>>();
    private Map<Integer, Integer> taskMgrState = new Hashtable<Integer, Integer>();
    private Set<Integer> setBlockTunnelID = new HashSet<Integer>();
    private Set<Integer> blockEventIDSet = new HashSet<Integer>();
    private Set<EventStateReg> stateRegSet = new HashSet<EventStateReg>();
    private boolean bInterrupt = false;
    private int iItrCount = 0;
    private ProcessInfo procInfo = null;
    private ReliableDBRWProxy dbrwProxy = null;
    private static Map<ProcessInfo, ReliableEventProxy> cache = new HashMap<ProcessInfo, ReliableEventProxy>();

    private ReliableEventProxy(ProcessInfo info) {
        this.procInfo = info;
        this.bInterrupt = false;
        this.iItrCount = 0;
        this.dbrwProxy = ReliableDBRWProxy.getInstance(info);
        this.init();
    }

    public static synchronized ReliableEventProxy getInstance(ProcessInfo info) {
        if (cache.keySet().contains(info)) {
            return cache.get(info);
        }
        ReliableEventProxy proxy = new ReliableEventProxy(info);
        cache.put(info, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEventProxy(ProcessInfo info) {
        ReliableEventProxy proxy;
        Map<ProcessInfo, ReliableEventProxy> map = cache;
        synchronized (map) {
            proxy = cache.remove(info);
        }
        if (null != proxy) {
            NotifyMgr.unRegisterNotifyListener(proxy);
            proxy.subscibeEventMap.clear();
            proxy.subscibeReliableEventMap.clear();
            proxy.setBlockTunnelID.clear();
            proxy.blockEventIDSet.clear();
            proxy.stateRegSet.clear();
            proxy.filterEvents.clear();
            proxy.taskMgrState.clear();
        }
    }

    private void init() {
        this.dbrwProxy.restoreSubscribeEvent();
        if (!this.initSubscribEvents()) {
            log.info("RELIEVENT_TRACE--> Iinit SubscribEvents fail!!\n");
            return;
        }
        NotifyMgr.registerNotifyListener(this);
        this.register();
        this.setTimerTask();
    }

    public void reload() {
        this.initSubscribEvents();
    }

    private boolean initSubscribEvents() {
        this.subscibeReliableEventMap.clear();
        this.subscibeEventMap.clear();
        this.filterEvents.clear();
        this.dbrwProxy.getAllSubscribEventInfos(this.subscibeReliableEventMap, this.subscibeEventMap);
        Set<Map.Entry<Integer, List<EventTarget>>> eventsSet = this.subscibeReliableEventMap.entrySet();
        for (Map.Entry<Integer, List<EventTarget>> event : eventsSet) {
            for (EventTarget itTarget : event.getValue()) {
                if (itTarget.recvProcID != this.procInfo.getProcID().charValue() || itTarget.recvProcHandle != this.procInfo.getProcHandle().charValue() && '\u0000' != itTarget.recvProcHandle) continue;
                if (!this.filterEvents.containsKey(itTarget.recvTaskMgrID)) {
                    this.filterEvents.put(itTarget.recvTaskMgrID, new ArrayList());
                }
                this.filterEvents.get(itTarget.recvTaskMgrID).add(event.getKey());
            }
        }
        return true;
    }

    private void register() {
        Set<Map.Entry<Integer, List<Integer>>> filterEventsSet = this.filterEvents.entrySet();
        TaskDispatcherMgr.getInstance(this.procInfo).registerTask(ReliableEventTask.class);
        for (Map.Entry<Integer, List<Integer>> event : filterEventsSet) {
            this.taskMgrState.put(event.getKey(), 0);
        }
    }

    public int send(ReliableEvent event) {
        if (null == event || null == event.eventContext) {
            log.info("Send Event is Null!");
            return 1107296272;
        }
        int evtState = 0;
        evtState = this.getEventState(event);
        return this.sendImpl(event, evtState);
    }

    public int subscribeEvent(ReliableEventHandler eventhandler, int eventId, int taskmgrid) {
        return EventManager.getInstance().subscibeEvent(eventId, eventhandler);
    }

    public int unsubscibeEvent(ReliableEventHandler eventhandler, int eventId) {
        return EventManager.getInstance().unsubscibeEvent(eventId, eventhandler);
    }

    public void registerEventState(EventStateReg pState) {
        this.stateRegSet.add(pState);
    }

    public void unRegisterEventState(EventStateReg pState) {
        this.stateRegSet.remove(pState);
    }

    private int getEventState(ReliableEvent event) {
        int evtState = 0;
        int tmpState = 0;
        for (EventStateReg itrStateReg : this.stateRegSet) {
            tmpState = itrStateReg.getEventState(event.eventID, event.eventContext);
            evtState |= tmpState;
        }
        return evtState;
    }

    private int sendImpl(ReliableEvent event, int evtState) {
        List<EventTarget> reliableSubList = this.subscibeReliableEventMap.get(event.eventID);
        List<EventTarget> unReliableSubList = this.subscibeEventMap.get(event.eventID);
        this.sendGeneralEvent(event, evtState, unReliableSubList);
        return this.sendReliableEvent(event, evtState, reliableSubList);
    }

    private void sendGeneralEvent(ReliableEvent event, int evtState, List<EventTarget> unReliableSubList) {
        if (null == unReliableSubList || unReliableSubList.isEmpty()) {
            log.info("No Process subscribt unreliable event, eventID=" + event.eventID);
            return;
        }
        AsnGeneralEvent generalEvent = new AsnGeneralEvent();
        try {
            generalEvent.eventContent = AsnCoder.serialize((FStruct)event.eventContext);
        }
        catch (FStruException e) {
            log.error("Encode eventContext fail,EventID=" + event.eventID, (Throwable)e);
            return;
        }
        generalEvent.eventID = BigInteger.valueOf(event.eventID);
        generalEvent.eventState = BigInteger.valueOf(evtState);
        generalEvent.tunnelID = BigInteger.valueOf(event.tunnelID);
        int size = unReliableSubList.size();
        for (int i = 0; i < size; ++i) {
            EventTarget eventTarget = unReliableSubList.get(i);
            if (!this.checkEventNeedSend(event.eventID, evtState, eventTarget)) continue;
            ProcessInfo procInfo = new ProcessInfo(Character.valueOf(eventTarget.recvProcID), Character.valueOf(eventTarget.recvProcHandle));
            MSGHead msgHead = MSGHeadBuilder.buildMSGHead((int)4193198, (ProcessInfo)procInfo, (byte)((byte)eventTarget.recvTaskMgrID), (char)'\u0000');
            int result = MsgProxy.getProxyService((ProcessInfo)this.procInfo).sendBroadcastMessage(msgHead, (FStruct)generalEvent);
            log.info("Send general event, eventid=" + event.eventID + ",procInfo=" + procInfo + ",result=" + result);
        }
    }

    private int sendReliableEvent(ReliableEvent event, int evtState, List<EventTarget> reliableSubList) {
        if (null == reliableSubList || reliableSubList.isEmpty()) {
            log.info("No Process subscribt reliable event, eventID=" + event.eventID);
            return 0;
        }
        if (!this.checkEventNeedSend(event.eventID, evtState, reliableSubList)) {
            log.info("RELIEVENT_TRACE-->not need send, because event is not registried or state is not matchable. eventid=" + event.eventID + ", evtState=" + evtState);
            return 0;
        }
        DBEventRecord sendRecord = new DBEventRecord();
        sendRecord.eventID = event.eventID;
        sendRecord.procID = this.procInfo.getProcID().charValue();
        sendRecord.procHandle = this.procInfo.getProcHandle().charValue();
        try {
            sendRecord.eventContext = AsnCoder.serialize((FStruct)event.eventContext);
        }
        catch (Exception e) {
            log.error("New Blob Fail,EventID:" + event.eventID, (Throwable)e);
            return 1107296272;
        }
        sendRecord.tunnelID = event.tunnelID;
        sendRecord.eventState = evtState;
        BigDecimal serial = this.dbrwProxy.sendEvent(sendRecord);
        if (null == serial) {
            log.info("DBOperater Failed in ReliableEventProxy::Send.EventID = " + event.eventID);
            return 1107296272;
        }
        log.info("RELIEVENT_TRACE-->Send Event: " + event.eventID + ", eventState:" + evtState + ", contexLength = " + sendRecord.eventContext.length + ", serial = " + serial);
        int size = reliableSubList.size();
        for (int i = 0; i < size; ++i) {
            EventTarget reliableEvent = reliableSubList.get(i);
            AsnRelaiableEvent asnevent = new AsnRelaiableEvent();
            asnevent.eventID = event.eventID;
            asnevent.serial = String.valueOf(serial).getBytes();
            ProcessInfo procInfo = new ProcessInfo(Character.valueOf(reliableEvent.recvProcID), Character.valueOf(reliableEvent.recvProcHandle));
            MSGHead msgHead = MSGHeadBuilder.buildMSGHead((int)0xB0000A, (ProcessInfo)procInfo, (byte)((byte)reliableEvent.recvTaskMgrID), (char)'\u0000');
            MsgProxy.getProxyService((ProcessInfo)this.procInfo).sendBroadcastMessage(msgHead, (FStruct)asnevent);
        }
        return 0;
    }

    private boolean checkEventNeedSend(int eventID, int evtState, List<EventTarget> reliableSubList) {
        for (EventTarget target : reliableSubList) {
            if (!this.checkEventNeedSend(eventID, evtState, target)) continue;
            return true;
        }
        return false;
    }

    private boolean checkEventNeedSend(int eventID, int evtState, EventTarget eventTarget) {
        if (69662 == eventID || 69663 == eventID) {
            log.info("RELIEVENT_TRACE-->[CheckEventNeedSend] eventid=" + eventID + ", evtstate=" + evtState);
            return true;
        }
        int tmpEventState = eventTarget.eventState;
        if ((tmpEventState & 0x10) == 0 && (0 == evtState || (evtState & (tmpEventState | 8)) != 0)) {
            return true;
        }
        log.info("CheckEventNeedSend is false:eventid=" + eventID + ", evtstate=" + evtState + ",recvProcID=" + eventTarget.recvProcID + ",recvProcHandle=" + eventTarget.recvProcHandle + ",recvTaskMgrID=" + eventTarget.recvTaskMgrID);
        return false;
    }

    void onReceiveGeneralEvent(AsnGeneralEvent pReq, int taskMgrID) {
        int eventID = pReq.eventID.intValue();
        int tunnelID = pReq.tunnelID.intValue();
        int eventState = pReq.eventState.intValue();
        byte[] context = pReq.eventContent;
        log.info("ReceiveEvent,eventID=" + eventID + ",taskMgrID=" + taskMgrID + ",tunnelID=" + tunnelID + ",eventState=" + eventState + ",context.len=" + context.length);
        ReliableEventParam eventParam = new ReliableEventParam(context, context.length, tunnelID, eventState);
        EventManager.getInstance().directEvent(eventID, eventParam);
    }

    void onReceiveReliableEvent(AsnRelaiableEvent pReq, int taskMgrID) {
        log.info("ReceiveReliableEvent,taskMgrID is " + taskMgrID);
        if (this.bInterrupt) {
            log.info("RELIEVENT_TRACE-->ReliEvent Receive has been Interruptted! No Events Handle...");
            return;
        }
        if (null == this.taskMgrState.get(taskMgrID)) {
            log.info("The TaskMgr Not register ReliableEvent, taskMgrID = " + taskMgrID);
            return;
        }
        if (this.taskMgrState.get(taskMgrID) != 0) {
            this.taskMgrState.put(taskMgrID, 2);
            return;
        }
        this.taskMgrState.put(taskMgrID, 1);
        boolean bRecvAgain = false;
        do {
            this.handleReliableReceive(taskMgrID);
            if (this.taskMgrState.get(taskMgrID) == 2) {
                this.taskMgrState.put(taskMgrID, 1);
                bRecvAgain = true;
                continue;
            }
            this.taskMgrState.put(taskMgrID, 0);
            bRecvAgain = false;
        } while (bRecvAgain);
    }

    private void handleReliableReceive(int taskMgrID) {
        List<DBEventRecord> records = this.dbrwProxy.getEvents(taskMgrID, this.setBlockTunnelID, this.blockEventIDSet);
        if (null == records || records.isEmpty()) {
            log.info("Get events is null, taskMgrID=" + taskMgrID);
            return;
        }
        ReliableEventParam eventParam = null;
        DBEventRecord rcvRecord = null;
        int ret = 0;
        block0: for (DBEventRecord itRecord : records) {
            byte[] context = itRecord.eventContext;
            int bufsize = context.length;
            if (log.isDebugEnabled()) {
                log.debug("\nRELIEVENT_TRACE-->Processing Reliable Event... EventID:" + itRecord.eventID);
            }
            if (69662 == itRecord.eventID) {
                this.dbrwProxy.restoreSubscribeEvent();
            }
            while (true) {
                ++itRecord.tryCount;
                eventParam = new ReliableEventParam(context, bufsize, itRecord.tunnelID, itRecord.eventState);
                ret = EventManager.getInstance().directEvent(itRecord.eventID, eventParam);
                rcvRecord = new DBEventRecord();
                rcvRecord.eventID = itRecord.eventID;
                rcvRecord.procID = this.procInfo.getProcID().charValue();
                rcvRecord.procHandle = this.procInfo.getProcHandle().charValue();
                rcvRecord.serial = itRecord.serial;
                if (0 == ret) {
                    if (log.isDebugEnabled()) {
                        log.info("\nRELIEVENT_TRACE-->Processing Reliable Event...database recode delete" + itRecord.eventID);
                    }
                    this.dbrwProxy.receiveEvent(rcvRecord, taskMgrID, 0);
                    continue block0;
                }
                if (itRecord.tryCount >= 10) {
                    log.info("RELIEVENT_TRACE-->Reliable event discard!, EventID=" + itRecord.eventID);
                    this.dbrwProxy.receiveEvent(rcvRecord, taskMgrID, 2);
                    continue block0;
                }
                log.info("RELIEVENT_TRACE-->Reliable event deal failed for " + itRecord.tryCount + " times!, EventID=" + itRecord.eventID);
                this.dbrwProxy.receiveEvent(rcvRecord, taskMgrID, 1);
            }
        }
    }

    public void interruptEventRcv() {
        ++this.iItrCount;
        log.error("RELIEVENT_TRACE-->Event receive interrupt,current ref:", (Object)this.iItrCount);
        this.bInterrupt = true;
    }

    public void interruptEventRcv(List<Integer> tunnelIDList) {
        if (null != tunnelIDList && !tunnelIDList.isEmpty()) {
            this.setBlockTunnelID.addAll(tunnelIDList);
        }
    }

    public void resumeEventRcv() {
        --this.iItrCount;
        log.error("RELIEVENT_TRACE-->Event receive resume,current ref:" + this.iItrCount);
        if (this.iItrCount <= 0) {
            this.iItrCount = 0;
            this.bInterrupt = false;
            this.syncEvents();
        }
    }

    public void resumeEventRcv(List<Integer> tunnelIDList) {
        for (int tunnelID : tunnelIDList) {
            this.setBlockTunnelID.remove(tunnelID);
        }
        this.syncEvents();
    }

    public void interruptEventRcvByEvtID(Set<Integer> eventIDList) {
        if (null != eventIDList && !eventIDList.isEmpty()) {
            this.blockEventIDSet.addAll(eventIDList);
        }
    }

    public void resumeEventRcvByEvtID(Set<Integer> eventIDList) {
        for (int eventID : eventIDList) {
            this.blockEventIDSet.remove(eventID);
        }
        this.syncEvents();
    }

    private void syncEvents() {
        AsnRelaiableEvent asnReq = new AsnRelaiableEvent();
        asnReq.serial = new byte[0];
        Set<Map.Entry<Integer, List<Integer>>> filterEventsSet = this.filterEvents.entrySet();
        for (Map.Entry<Integer, List<Integer>> event : filterEventsSet) {
            this.onReceiveReliableEvent(asnReq, event.getKey());
        }
    }

    private void setTimerTask() {
        Timer synTimer = new Timer();
        synTimer.schedule((TimerTask)new SynTimerTask(), 120000L, 120000L);
    }

    @Override
    public void handleNotify(QAsnDeploymentNotify notify) {
        String actionStr = new String(notify.action);
        if (actionStr.equalsIgnoreCase("FINISH_ADD_INSTANCE") || actionStr.equalsIgnoreCase("FINISH_DEL_INSTANCE")) {
            log.info("Receiver deploment action:" + actionStr);
            this.reload();
        }
    }

    class SynTimerTask
    extends TimerTask {
        SynTimerTask() {
        }

        public void run() {
            try {
                ReliableEventProxy.this.syncEvents();
            }
            catch (Exception e) {
                log.info("Sync Event Fail.", (Throwable)e);
            }
        }
    }
}

