/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.reliableevent;

import com.huawei.communicate.util.asn.AsnCoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import org.slf4j.LoggerFactory;

public class ReliableEventParam {
    private byte[] pContext;
    private int length;
    private int tunnelID;
    private int evtState;

    public ReliableEventParam() {
        this.pContext = null;
        this.length = 0;
        this.tunnelID = 0;
        this.evtState = 0;
    }

    public ReliableEventParam(byte[] pBuf, int len, int tunnelID, int evtState) {
        if (null != pBuf && len != 0) {
            this.length = len;
            this.pContext = new byte[len];
            System.arraycopy(pBuf, 0, this.pContext, 0, len);
        }
        this.tunnelID = tunnelID;
        this.evtState = evtState;
    }

    public ReliableEventParam(FStruct event) {
        this.setAsnEvent(event);
    }

    public int setAsnEvent(FStruct event) {
        byte[] pBuffer;
        if (null != this.pContext && this.pContext.length > 0) {
            this.pContext = null;
            this.length = 0;
        }
        try {
            pBuffer = AsnCoder.serialize((FStruct)event);
        }
        catch (FStruException e) {
            LoggerFactory.getLogger(ReliableEventParam.class).error("Encode ASN1MSG Fail.", (Throwable)e);
            return 1090646025;
        }
        if (null != pBuffer && pBuffer.length > 0) {
            int lBufLength = pBuffer.length;
            this.pContext = new byte[lBufLength];
            System.arraycopy(pBuffer, 0, this.pContext, 0, lBufLength);
            this.length = lBufLength;
            return 0;
        }
        return 1090646025;
    }

    public int getAsnEvent(FStruct event) {
        if (AsnCoder.deserialize((byte[])this.pContext, (FStruct)event)) {
            return 0;
        }
        return 1090646026;
    }

    public byte[] getPContext() {
        if (null == this.pContext) {
            return null;
        }
        byte[] result = new byte[this.pContext.length];
        System.arraycopy(this.pContext, 0, result, 0, this.pContext.length);
        return result;
    }

    public int getTunnelID() {
        return this.tunnelID;
    }

    public int getEvtState() {
        return this.evtState;
    }

    public int getLength() {
        return this.length;
    }
}

