/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.reliableevent;

import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.dbpool.DBPool;
import com.huawei.commextend.reliableevent.DBEventRecord;
import com.huawei.commextend.reliableevent.EventTarget;
import com.huawei.communicate.core.info.ProcessInfo;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReliableDBRWProxy {
    private static final int MAX_BLOB_SIZE = 1899;
    private static final int MAX_RETRY_TIMES = 50;
    private static final int SLEEP_TIME = 2000;
    private static Logger log = LoggerFactory.getLogger(ReliableDBRWProxy.class);
    private ProcessInfo procInfo = null;
    private static Map<ProcessInfo, ReliableDBRWProxy> cache = new HashMap<ProcessInfo, ReliableDBRWProxy>();

    private ReliableDBRWProxy(ProcessInfo info) {
        this.procInfo = info;
    }

    public static synchronized ReliableDBRWProxy getInstance(ProcessInfo info) {
        if (cache.keySet().contains(info)) {
            return cache.get(info);
        }
        ReliableDBRWProxy proxy = new ReliableDBRWProxy(info);
        cache.put(info, proxy);
        return proxy;
    }

    public void removeReliableDBRWProxy(ProcessInfo info) {
        cache.remove(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getAllSubscribEventInfos(Map<Integer, List<EventTarget>> subscibeReliableEventMap, Map<Integer, List<EventTarget>> subscibeEventMap) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = DBPool.getInstance().getConnection();
            if (null == conn) {
                log.info("Get DB Connection Fail.");
                return;
            }
            String querySql = 2 == DBConfiguration.getInstance().getDbType() ? "SELECT * FROM MCDB.tbl_SubscribEvent" : "SELECT * FROM tbl_SubscribEvent";
            pstmt = conn.prepareStatement(querySql);
            rs = pstmt.executeQuery();
            int index = 1;
            while (rs.next()) {
                int eventType;
                index = 1;
                int eventID = rs.getInt(index++);
                char recvProcID = (char)rs.getInt(index++);
                char recvProcHandle = (char)rs.getInt(index++);
                int recvTaskMgrID = rs.getInt(index++);
                int eventState = rs.getInt(index++);
                if ((eventType = rs.getInt(index++)) == 0) {
                    if (!subscibeReliableEventMap.containsKey(eventID)) {
                        subscibeReliableEventMap.put(eventID, new ArrayList());
                    }
                    subscibeReliableEventMap.get(eventID).add(new EventTarget(recvProcID, recvProcHandle, recvTaskMgrID, eventState, eventType));
                    continue;
                }
                if (!subscibeEventMap.containsKey(eventID)) {
                    subscibeEventMap.put(eventID, new ArrayList());
                }
                subscibeEventMap.get(eventID).add(new EventTarget(recvProcID, recvProcHandle, recvTaskMgrID, eventState, eventType));
            }
            this.releaseDBRes(conn, pstmt, rs);
        }
        catch (SQLException e) {
            log.error("Query SubscribEvents Fail!", (Throwable)e);
        }
        finally {
            this.releaseDBRes(conn, pstmt, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<DBEventRecord> getOracleEvents(int taskMgrID, Set<Integer> setBlockTunnelID, Set<Integer> blockEventIDSet) {
        ResultSet result;
        PreparedStatement pstmt;
        CallableStatement cstmt;
        Connection conn;
        ArrayList<DBEventRecord> events;
        block14: {
            events = new ArrayList<DBEventRecord>();
            conn = DBPool.getInstance().getConnection();
            if (null == conn) {
                log.info("Get DB Connection Fail.");
                return events;
            }
            cstmt = null;
            pstmt = null;
            result = null;
            String procname = "{call mcdb.t2ksp_GetEvents(?,?,?,?,?)}";
            try {
                cstmt = conn.prepareCall(procname);
                this.fillGetEventsStmtParam(cstmt, taskMgrID);
                cstmt.registerOutParameter(5, 12);
                cstmt.execute();
                String querySql = cstmt.getString(5);
                pstmt = conn.prepareStatement(querySql);
                result = pstmt.executeQuery();
                BigDecimal serial = BigDecimal.ZERO;
                int tunnelID = -1;
                int index = 1;
                int eventID = -1;
                while (result.next()) {
                    index = 1;
                    tunnelID = result.getInt(index++);
                    serial = result.getBigDecimal(index++);
                    eventID = result.getInt(++index);
                    if (setBlockTunnelID.contains(tunnelID) || blockEventIDSet.contains(eventID)) continue;
                    events.add(this.getEventRecordFromRs(result));
                }
                if (null == cstmt) break block14;
            }
            catch (SQLException e) {
                log.error("Exec t2ksp_GetEvents fail.", (Throwable)e);
                return events;
            }
            try {
                cstmt.close();
            }
            catch (SQLException e) {
                log.info("Close CallableStatement Fail!", (Throwable)e);
            }
        }
        this.releaseDBRes(conn, pstmt, result);
        return events;
        finally {
            if (null != cstmt) {
                try {
                    cstmt.close();
                }
                catch (SQLException e) {
                    log.info("Close CallableStatement Fail!", (Throwable)e);
                }
            }
            this.releaseDBRes(conn, pstmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DBEventRecord> getEvents(int taskMgrID, Set<Integer> setBlockTunnelID, Set<Integer> blockEventIDSet) {
        if (2 == DBConfiguration.getInstance().getDbType()) {
            return this.getOracleEvents(taskMgrID, setBlockTunnelID, blockEventIDSet);
        }
        ArrayList<DBEventRecord> events = new ArrayList<DBEventRecord>();
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return events;
        }
        CallableStatement cstmt = null;
        ResultSet result = null;
        String procname = "{call t2ksp_GetEvents(?,?,?,?)}";
        try {
            cstmt = conn.prepareCall(procname);
            this.fillGetEventsStmtParam(cstmt, taskMgrID);
            result = cstmt.executeQuery();
            BigDecimal serial = BigDecimal.ZERO;
            int tunnelID = -1;
            int index = 1;
            int eventID = -1;
            while (result.next()) {
                index = 1;
                tunnelID = result.getInt(index++);
                serial = result.getBigDecimal(index++);
                eventID = result.getInt(++index);
                if (setBlockTunnelID.contains(tunnelID) || blockEventIDSet.contains(eventID)) continue;
                events.add(this.getEventRecordFromRs(result));
            }
            this.releaseDBRes(conn, cstmt, result);
        }
        catch (SQLException e) {
            try {
                log.error("Exec t2ksp_GetEvents fail.", (Throwable)e);
                this.releaseDBRes(conn, cstmt, result);
            }
            catch (Throwable throwable) {
                this.releaseDBRes(conn, cstmt, result);
                throw throwable;
            }
        }
        return events;
    }

    private void fillGetEventsStmtParam(PreparedStatement cstmt, int taskMgrID) throws SQLException {
        int index = 0;
        cstmt.setInt(++index, this.procInfo.getProcID().charValue());
        cstmt.setInt(++index, this.procInfo.getProcHandle().charValue());
        cstmt.setInt(++index, taskMgrID);
        cstmt.setBigDecimal(++index, new BigDecimal(-1));
    }

    private DBEventRecord getEventRecordFromRs(ResultSet result) throws SQLException {
        DBEventRecord tmpEvent = new DBEventRecord();
        int index = 0;
        tmpEvent.tunnelID = result.getInt(++index);
        tmpEvent.serial = result.getBigDecimal(++index);
        BigDecimal serialContext = result.getBigDecimal(++index);
        tmpEvent.eventContext = this.getEventContextData(serialContext);
        tmpEvent.eventID = result.getInt(++index);
        tmpEvent.procID = result.getInt(++index);
        tmpEvent.procHandle = result.getInt(++index);
        tmpEvent.tryCount = result.getInt(++index);
        tmpEvent.eventState = result.getInt(++index);
        return tmpEvent;
    }

    private String getOracleEventSql() {
        StringBuffer getEventContext = new StringBuffer();
        getEventContext.append("select EventContext from MCDB.tbl_EventBufferContextData where Serial = ?");
        getEventContext.append(" or FirstPacketSN=?");
        getEventContext.append(" order by Serial");
        return getEventContext.toString();
    }

    private String getEventSql() {
        StringBuffer getEventContext = new StringBuffer();
        getEventContext.append("set textsize 1212416");
        getEventContext.append(System.getProperty("line.separator"));
        getEventContext.append("select ImageContext, EventContext from tbl_EventBufferContextData where Serial = ?");
        getEventContext.append(" or FirstPacketSN=?");
        getEventContext.append(" order by Serial");
        getEventContext.append(System.getProperty("line.separator"));
        getEventContext.append("set textsize 0");
        return getEventContext.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEventContextData(BigDecimal serialContext) {
        String getEventContext = 2 == DBConfiguration.getInstance().getDbType() ? this.getOracleEventSql() : this.getEventSql();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet result = null;
        byte[] context = new byte[]{};
        try {
            conn = DBPool.getInstance().getConnection();
            pstmt = conn.prepareStatement(getEventContext);
            pstmt.setBigDecimal(1, serialContext);
            pstmt.setBigDecimal(2, serialContext);
            pstmt.execute();
            result = pstmt.getResultSet();
            while (result.next()) {
                byte[] currBytes = result.getBytes(1);
                if (null == currBytes || 0 == currBytes.length) {
                    currBytes = result.getBytes(2);
                }
                byte[] newContext = new byte[context.length + currBytes.length - 1];
                System.arraycopy(context, 0, newContext, 0, context.length);
                System.arraycopy(currBytes, 0, newContext, context.length, currBytes.length - 1);
                context = newContext;
            }
            this.releaseDBRes(conn, pstmt, result);
        }
        catch (SQLException e) {
            log.error("error in execute tbl_EventBufferContextData", (Throwable)e);
        }
        finally {
            this.releaseDBRes(conn, pstmt, result);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean receiveEvent(DBEventRecord event, int taskMgrID, int result) {
        CallableStatement cstmt = null;
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return false;
        }
        String procname = 2 == DBConfiguration.getInstance().getDbType() ? "{call mcdb.t2ksp_RecvEvent(?,?,?,?,?)}" : "{call t2ksp_RecvEvent(?,?,?,?,?)}";
        try {
            int index = 0;
            cstmt = conn.prepareCall(procname);
            cstmt.setBigDecimal(++index, event.serial);
            cstmt.setInt(++index, event.procID);
            cstmt.setInt(++index, event.procHandle);
            cstmt.setInt(++index, result);
            cstmt.setInt(++index, taskMgrID);
            cstmt.execute();
        }
        catch (SQLException e) {
            log.error("Call t2ksp_RecvEvent fail:" + cstmt.toString(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseDBRes(conn, cstmt, null);
        }
        return true;
    }

    BigDecimal sendEvent(DBEventRecord event) {
        BigDecimal serial = null;
        int sendTimes = 0;
        boolean isPrintLog = false;
        do {
            if (50 == sendTimes) {
                isPrintLog = true;
            }
            if (null != (serial = this.sendEventOnce(event, isPrintLog))) {
                return serial;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.info("Thread sleep fail.", (Throwable)e);
            }
            log.info("ReliableEventDBRW::SendEvent fail, retry " + sendTimes + " times");
        } while (sendTimes++ < 50);
        return serial;
    }

    private BigDecimal sendEventOnce(DBEventRecord event, boolean isPrintLog) {
        BigDecimal serialcontext = null;
        serialcontext = this.writeContextData(event, isPrintLog);
        if (null == serialcontext) {
            return null;
        }
        return this.writeEventBuffer(event, serialcontext, isPrintLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal writeContextData(DBEventRecord event, boolean isPrintLog) {
        byte[] eventByte = event.eventContext;
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return null;
        }
        int length = eventByte.length;
        try {
            conn.setAutoCommit(false);
            for (int pos = 0; pos < length; pos += 1899) {
                this.writeSingleContextData(conn, event, eventByte, pos, isPrintLog);
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            if (isPrintLog) {
                log.error("Set Connection Commit Error.", (Throwable)e);
            }
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
        finally {
            this.releaseDBRes(conn, null, null);
        }
        return event.serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal writeSingleContextData(Connection conn, DBEventRecord event, byte[] eventByte, int pos, boolean isPrintLog) {
        BigDecimal serial = null;
        int length = eventByte.length;
        int packetLen = length - pos;
        if (packetLen > 1899) {
            packetLen = 1899;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        if (2 == DBConfiguration.getInstance().getDbType()) {
            sqlBuilder.append("Insert into MCDB.tbl_EventBufferContextData(");
        } else {
            sqlBuilder.append("Insert into tbl_EventBufferContextData(");
        }
        sqlBuilder.append("EventContext");
        if (pos != 0) {
            sqlBuilder.append(", FirstPacketSN");
        }
        sqlBuilder.append(") ");
        sqlBuilder.append(" VALUES(?");
        if (pos != 0) {
            sqlBuilder.append(",?");
        }
        sqlBuilder.append(") ");
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int index = 1;
        try {
            pstmt = conn.prepareStatement(sqlBuilder.toString());
            byte[] tmpEventByte = new byte[packetLen + 1];
            System.arraycopy(eventByte, pos, tmpEventByte, 0, packetLen);
            tmpEventByte[tmpEventByte.length - 1] = -1;
            pstmt.setBytes(index++, tmpEventByte);
            if (pos != 0) {
                pstmt.setBigDecimal(index++, event.serial);
            }
            pstmt.execute();
            if (pos == 0) {
                pstmt.close();
                pstmt = conn.prepareStatement("select @@IDENTITY AS Serial");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    event.serial = serial = rs.getBigDecimal(1);
                }
            }
        }
        catch (Exception e) {
            block17: {
                if (isPrintLog) {
                    log.error("send Event MultiPacket fail, eventID = !" + event.eventID, (Throwable)e);
                }
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    if (!isPrintLog) break block17;
                    log.info("DataBase Rollback fail, eventID = !" + event.eventID, (Throwable)e);
                }
            }
            event.serial = null;
            BigDecimal bigDecimal = serial;
            return bigDecimal;
        }
        finally {
            this.releaseDBRes(null, pstmt, rs);
        }
        return serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal writeEventBuffer(DBEventRecord event, BigDecimal serialcontext, boolean isPrintLog) {
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return null;
        }
        CallableStatement cstmt = null;
        ResultSet result = null;
        BigDecimal serial = null;
        String procname = "{call t2ksp_WriteEventBuffer(?,?,?,?,?,?)}";
        try {
            cstmt = conn.prepareCall(procname);
            int index = 0;
            cstmt.setInt(++index, event.eventID);
            cstmt.setInt(++index, event.procID);
            cstmt.setInt(++index, event.procHandle);
            cstmt.setInt(++index, event.eventState);
            cstmt.setInt(++index, event.tunnelID);
            cstmt.setBigDecimal(++index, serialcontext);
            result = cstmt.executeQuery();
            while (result.next()) {
                serial = result.getBigDecimal(1);
            }
            this.releaseDBRes(conn, cstmt, result);
        }
        catch (SQLException e) {
            if (isPrintLog) {
                log.info("RELIEVENT_TRACE-->DB Error while Sending Event:", (Object)event.eventID);
            }
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
        finally {
            this.releaseDBRes(conn, cstmt, result);
        }
        return serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Integer> getAllEvent() {
        ArrayList<Integer> eventList = new ArrayList<Integer>();
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return eventList;
        }
        CallableStatement cstmt = null;
        ResultSet result = null;
        String procname = "t2ksp_GetAllEvents";
        try {
            cstmt = conn.prepareCall(procname);
            result = cstmt.executeQuery();
            while (result.next()) {
                eventList.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            log.error("Get All Events Fail From DB.", (Throwable)e);
            List<Integer> list = null;
            return list;
        }
        finally {
            this.releaseDBRes(conn, cstmt, result);
        }
        return eventList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreSubscribeEvent() {
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return;
        }
        CallableStatement cstmt = null;
        String procname = "{call ip_RestoreSubscribeEvent(?,?)}";
        if (2 == DBConfiguration.getInstance().getDbType()) {
            procname = "{call MCDB.ip_RestoreSubscribeEvent(?,?)}";
        }
        try {
            cstmt = conn.prepareCall(procname);
            int index = 0;
            cstmt.setInt(++index, (int)this.procInfo.getProcID().charValue());
            cstmt.setInt(++index, (int)this.procInfo.getProcHandle().charValue());
            cstmt.execute();
        }
        catch (SQLException e) {
            log.error("RestoreSubscribeEvent Fail From DB.", (Throwable)e);
        }
        finally {
            this.releaseDBRes(conn, cstmt, null);
        }
    }

    private void releaseDBRes(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.info("Close DB Connection Fail!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countEvent(DBEventRecord event) {
        if (2 == DBConfiguration.getInstance().getDbType()) {
            return;
        }
        CallableStatement cstmt = null;
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return;
        }
        String procname = "{? = call sp_CountEvent(?,?)}";
        try {
            cstmt = conn.prepareCall(procname);
            int index = 1;
            cstmt.registerOutParameter(index++, 4);
            cstmt.setInt(index++, event.procID);
            cstmt.setInt(index++, event.eventID);
            cstmt.execute();
        }
        catch (SQLException e) {
            log.info("RELIEVENT_TRACE-->DB Error while sp_CountEvent:" + event.eventID, (Throwable)e);
        }
        finally {
            this.releaseDBRes(conn, cstmt, null);
        }
        log.info("RELIEVENT_TRACE-->sp_CountEvent EventID:", (Object)event.eventID);
    }
}

