/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.reliableevent;

import com.huawei.commextend.reliableevent.ReliableEventHandler;
import com.huawei.commextend.reliableevent.ReliableEventParam;
import com.huawei.communicate.util.threadpool.ConcurrentInvoker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventManager {
    private static Logger log = LoggerFactory.getLogger(EventManager.class);
    private static EventManager instance = null;
    private Map<Integer, List<ReliableEventHandler>> eventHandlerTrack = new HashMap<Integer, List<ReliableEventHandler>>();
    private ReentrantReadWriteLock eventHandlerTableLock = new ReentrantReadWriteLock();

    EventManager() {
    }

    static synchronized EventManager getInstance() {
        if (null == instance) {
            instance = new EventManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int subscibeEvent(int eventID, ReliableEventHandler handler) {
        this.eventHandlerTableLock.writeLock().lock();
        try {
            if (null == this.eventHandlerTrack.get(eventID)) {
                this.eventHandlerTrack.put(eventID, new ArrayList());
            }
            this.eventHandlerTrack.get(eventID).add(handler);
        }
        catch (Exception e) {
            log.error("subscibeEvent error,eventID=" + eventID, (Throwable)e);
        }
        finally {
            this.eventHandlerTableLock.writeLock().unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int unsubscibeEvent(int eventID, ReliableEventHandler handler) {
        this.eventHandlerTableLock.readLock().lock();
        List<ReliableEventHandler> eventHandlers = this.eventHandlerTrack.get(eventID);
        if (null == eventHandlers || eventHandlers.isEmpty()) {
            this.eventHandlerTableLock.readLock().unlock();
            return 0;
        }
        this.eventHandlerTableLock.readLock().unlock();
        this.eventHandlerTableLock.writeLock().lock();
        try {
            eventHandlers.remove(handler);
        }
        catch (Exception e) {
            log.error("unsubscibeEvent error,eventID=" + eventID, (Throwable)e);
        }
        finally {
            this.eventHandlerTableLock.writeLock().unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int directEvent(int eventID, ReliableEventParam eventParam) {
        this.eventHandlerTableLock.readLock().lock();
        List<ReliableEventHandler> eventHandlers = this.eventHandlerTrack.get(eventID);
        if (null == eventHandlers) {
            this.eventHandlerTableLock.readLock().unlock();
            return 0;
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        ReliableEventHandler handler = null;
        int len = eventHandlers.size();
        for (int i = 0; i < len; ++i) {
            handler = eventHandlers.get(i);
            invoker.add((Runnable)new HandlerRunnable(eventID, eventParam, handler));
        }
        try {
            invoker.run();
        }
        catch (Exception e) {
            log.error("Reliable Event Handle Fail.", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            this.eventHandlerTableLock.readLock().unlock();
        }
        return 0;
    }

    static class HandlerRunnable
    implements Runnable {
        int eventID;
        ReliableEventParam eventParam;
        ReliableEventHandler handler;

        public HandlerRunnable(int eventID, ReliableEventParam eventParam, ReliableEventHandler handler) {
            this.eventID = eventID;
            this.eventParam = eventParam;
            this.handler = handler;
        }

        public void run() {
            try {
                this.handler.process(this.eventID, this.eventParam);
            }
            catch (Exception e) {
                log.error("handleEvent event error.", (Throwable)e);
            }
        }
    }
}

