/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.necoordinator;

import com.huawei.commextend.necoordinator.SPParameter;
import com.huawei.commextend.necoordinator.SPParameterType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import org.slf4j.LoggerFactory;

final class SPHelper {
    private SPHelper() {
    }

    static void convertParameter(CallableStatement cstmt, int num, SPParameter para) {
        try {
            switch (para.getType()) {
                case 4: {
                    SPHelper.convertToInteger(cstmt, num, para);
                    break;
                }
                case 6: {
                    SPHelper.convertToFloat(cstmt, num, para);
                    break;
                }
                case 12: {
                    SPHelper.convertToVarChar(cstmt, num, para);
                    break;
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SPHelper.class).error("convertParameter error,type:" + para.getType() + ",parameterType:" + (Object)((Object)para.getParameterType()), (Throwable)e);
        }
    }

    static void convertToInteger(CallableStatement cstmt, int num, SPParameter para) throws SQLException {
        if (para.getParameterType() == SPParameterType.IN) {
            cstmt.setInt(num, (int)((Integer)para.getValue()));
        } else if (para.getParameterType() == SPParameterType.IN_OUT) {
            cstmt.registerOutParameter(num, 4);
            cstmt.setInt(num, (int)((Integer)para.getValue()));
        } else {
            cstmt.registerOutParameter(num, 4);
        }
    }

    static void convertToFloat(CallableStatement cstmt, int num, SPParameter para) throws SQLException {
        if (para.getParameterType() == SPParameterType.IN) {
            cstmt.setFloat(num, ((Float)para.getValue()).floatValue());
        } else if (para.getParameterType() == SPParameterType.IN_OUT) {
            cstmt.registerOutParameter(num, 6);
            cstmt.setFloat(num, ((Float)para.getValue()).floatValue());
        } else {
            cstmt.registerOutParameter(num, 6);
        }
    }

    static void convertToVarChar(CallableStatement cstmt, int num, SPParameter para) throws SQLException {
        if (para.getParameterType() == SPParameterType.IN) {
            cstmt.setString(num, (String)para.getValue());
        } else if (para.getParameterType() == SPParameterType.IN_OUT) {
            cstmt.registerOutParameter(num, 12);
            cstmt.setString(num, (String)para.getValue());
        } else {
            cstmt.registerOutParameter(num, 12);
        }
    }

    static void fillOutputParameter(CallableStatement cstmt, int num, SPParameter para) {
        try {
            if (para.getParameterType() == SPParameterType.IN_OUT || para.getParameterType() == SPParameterType.OUT) {
                para.setValue(cstmt.getObject(num));
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SPHelper.class).error("Fill output parameter error.", (Throwable)e);
        }
    }
}

