/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.necoordinator;

import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.dbpool.DBPool;
import com.huawei.commextend.necoordinator.NEPartitionRule;
import com.huawei.commextend.necoordinator.PartitionRecordStat;
import com.huawei.commextend.necoordinator.SPHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PartitionRule {
    private static final int SUCCESS = 0;
    private static final int PARTITION_RULE_TYPE_IP = 0;
    private static final int PARTITION_RULE_TYPE_ID = 1;
    private static final int PARTITION_VALUE_EXIST = 0;
    private static final int PARTITION_VALUE_NOT_EXIST = 1;
    private static Logger log = LoggerFactory.getLogger(SPHelper.class);

    private PartitionRule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NEPartitionRule> getRuleFromDB() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("select ProcType,ProcHandle,RuleType,BeginValue,EndValue from ");
        strBuffer.append(DBConfiguration.getInstance().tableName("MCDB", "tbl_NEPartitionRule"));
        String querySql = strBuffer.toString();
        ArrayList<NEPartitionRule> lstRule = new ArrayList<NEPartitionRule>();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            conn = DBPool.getInstance().getConnection();
            if (null == conn) {
                log.info("[getRuleFromDB] Get DB Connection Fail.");
                ArrayList<NEPartitionRule> arrayList = lstRule;
                return arrayList;
            }
            int index = 1;
            NEPartitionRule rule = new NEPartitionRule();
            pstmt = conn.prepareStatement(querySql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                index = 1;
                rule.setProcType(rs.getInt(index++));
                rule.setProcHandle(rs.getInt(index++));
                rule.setRule(rs.getInt(index++));
                rule.setBeginValue(rs.getInt(index++));
                rule.setEndValue(rs.getInt(index++));
                lstRule.add(rule);
            }
        }
        catch (SQLException e) {
            log.error("[getRuleFromDB] Query SubscribEvents Fail!", (Throwable)e);
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
                if (null != pstmt) {
                    pstmt.close();
                }
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.info("[getRuleFromDB] Close DB Connection Fail!", (Throwable)e);
            }
        }
        return lstRule;
    }

    public static int checkRule(List<PartitionRecordStat> lstRuleStat) {
        List<NEPartitionRule> lstRule = PartitionRule.getRuleFromDB();
        for (PartitionRecordStat recordStat : lstRuleStat) {
            int value = 0;
            if (0 == recordStat.getRuleType()) {
                value = PartitionRule.convertIPToDecimal(recordStat.getStrIP());
            } else if (1 == recordStat.getRuleType()) {
                value = recordStat.getDevID();
            } else {
                log.error("[PartitionRule::checkRule] The rule type is error.");
            }
            boolean isFlag = false;
            for (NEPartitionRule rule : lstRule) {
                int beginValue = rule.getBeginValue();
                int endValue = rule.getEndValue();
                if (rule.getProcType() != recordStat.getProcType() || rule.getProcHandle() != recordStat.getProcHandle() || rule.getRule() != recordStat.getRuleType() || value < beginValue || value > endValue) continue;
                recordStat.setValueStat(0);
                isFlag = true;
                break;
            }
            if (isFlag) continue;
            recordStat.setValueStat(1);
        }
        return 0;
    }

    private static int convertIPToDecimal(String addr) {
        StringTokenizer st = new StringTokenizer(addr, ".");
        int n1 = Integer.parseInt(st.nextToken());
        int n2 = Integer.parseInt(st.nextToken());
        int n3 = Integer.parseInt(st.nextToken());
        int n4 = Integer.parseInt(st.nextToken());
        int ret = 0xFFFFFFFF & (n1 << 24 | n2 << 16 | n3 << 8 | n4);
        return ret;
    }
}

