/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.necoordinator;

import com.huawei.commextend.dbpool.DBPool;
import com.huawei.commextend.necoordinator.NEIP2ServerID;
import com.huawei.commextend.necoordinator.SQLAssistant;
import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NETrapService {
    public static final int FRAMECMDCODE_NOTIFYTRAPDISPNEADD = 4193183;
    public static final int FRAMECMDCODE_NOTIFYTRAPDISPNEDELETE = 4193184;
    public static final char TRAP_DISPATCHER_PID = '\ub185';
    public static final byte TASKMGR_ID_U2K = -56;
    private static Logger log = LoggerFactory.getLogger(NETrapService.class);

    private NETrapService() {
    }

    public static boolean notifyNETransfer(String pNEIP, int iServerID) {
        if (null == pNEIP || pNEIP.length() == 0) {
            log.error("[CTrapServer::notifyNETransfer] pNEIP is NULL, return.");
            return false;
        }
        ArrayList<NEIP2ServerID> lstTrapServer = new ArrayList<NEIP2ServerID>();
        lstTrapServer.add(new NEIP2ServerID(pNEIP, iServerID));
        return NETrapService.notifyNETransfer(lstTrapServer);
    }

    public static boolean notifyNETransfer(List<NEIP2ServerID> lstTrapServer) {
        ArrayList<NEIP2ServerID> delList = new ArrayList<NEIP2ServerID>();
        for (NEIP2ServerID optObject : lstTrapServer) {
            delList.add(new NEIP2ServerID(optObject.strNEIP, 0));
        }
        NETrapService.notifyNEDelete(delList);
        NETrapService.notifyNECreated(lstTrapServer);
        return true;
    }

    public static boolean notifyNEDelete(String pNEIP) {
        if (null == pNEIP || pNEIP.isEmpty()) {
            log.error("[CTrapServer::notifyNEDelete] pNEIP is NULL, return.");
            return false;
        }
        ArrayList<NEIP2ServerID> lstTrapServer = new ArrayList<NEIP2ServerID>();
        lstTrapServer.add(new NEIP2ServerID(pNEIP, 0));
        return NETrapService.notifyNEDelete(lstTrapServer);
    }

    public static boolean notifyNEDelete(List<NEIP2ServerID> lstTrapServer) {
        if (null == lstTrapServer || lstTrapServer.isEmpty()) {
            log.error("lstTrapServer is NULL, return.");
            return false;
        }
        log.info("delete ne list is" + lstTrapServer);
        NETrapService.dbOperation(lstTrapServer, 1);
        StringBuilder strBuild = new StringBuilder();
        for (NEIP2ServerID id : lstTrapServer) {
            strBuild.append(id.strNEIP).append(',');
        }
        strBuild.deleteCharAt(strBuild.length() - 1);
        return NETrapService.sendMsg(4193184, strBuild.toString());
    }

    public static boolean notifyNECreated(String pNEIP, int iServerID) {
        if (null == pNEIP || pNEIP.isEmpty()) {
            log.error("[CTrapServer::NotifyNECreated] pNEIP is NULL, return.");
            return false;
        }
        ArrayList<NEIP2ServerID> lstTrapServer = new ArrayList<NEIP2ServerID>();
        lstTrapServer.add(new NEIP2ServerID(pNEIP, iServerID));
        return NETrapService.notifyNECreated(lstTrapServer);
    }

    public static boolean notifyNECreated(List<NEIP2ServerID> lstTrapServer) {
        if (null == lstTrapServer || lstTrapServer.isEmpty()) {
            log.error("lstTrapServer is NULL, return.");
            return false;
        }
        log.info("create ne is " + lstTrapServer);
        NETrapService.dbOperation(lstTrapServer, 0);
        StringBuilder strBuild = new StringBuilder();
        for (NEIP2ServerID id : lstTrapServer) {
            strBuild.append(id.strNEIP).append(',').append(id.iServerID).append(',');
        }
        strBuild.deleteCharAt(strBuild.length() - 1);
        return NETrapService.sendMsg(4193183, strBuild.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean dbOperation(List<NEIP2ServerID> lstTrapServer, int opType) {
        if (lstTrapServer.size() <= 0) {
            return false;
        }
        Connection conn = DBPool.getInstance().getConnection();
        PreparedStatement stmt = null;
        try {
            String sqlStr = SQLAssistant.getSql(opType);
            stmt = conn.prepareStatement(sqlStr);
            conn.setAutoCommit(false);
            for (NEIP2ServerID optObject : lstTrapServer) {
                SQLAssistant.setStmtPara(stmt, optObject, opType);
                stmt.addBatch();
            }
            stmt.executeBatch();
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            log.error("dbOperation fail, opType = " + opType, (Throwable)e);
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                log.info("DataBase Rollback fail", (Throwable)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error("Close DB Connection Fail!", (Throwable)e);
            }
        }
        return true;
    }

    private static boolean sendMsg(int ulCmdCode, String sendMsgStr) {
        ProcessInfo pTrap = new ProcessInfo();
        pTrap.setProcID('\ub185');
        MSGHead msgHead = MSGHeadBuilder.buildMSGHead((int)ulCmdCode, (ProcessInfo)pTrap);
        msgHead.receiverModule = (byte)-56;
        byte[] pBuf = sendMsgStr.getBytes();
        MSGPacketExt packetExt = new MSGPacketExt(msgHead, pBuf);
        CommHandle commHandle = (CommHandle)MsgProxy.getCommService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
        try {
            commHandle.sendAsyncMessage(packetExt, null);
        }
        catch (Exception e) {
            log.error("sendEventMsg fail " + sendMsgStr, (Throwable)e);
            return false;
        }
        return true;
    }
}

