/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.necoordinator;

import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.dbpool.DBPool;
import com.huawei.commextend.necoordinator.NECoordinatorService;
import com.huawei.commextend.necoordinator.NESP;
import com.huawei.commextend.necoordinator.NESPRegInfo;
import com.huawei.commextend.necoordinator.SPHelper;
import com.huawei.commextend.necoordinator.SPParameter;
import com.huawei.communicate.core.info.ProcessInfo;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NESPTransaction {
    private static final int INVALID_SP_NO = -1;
    public static final int SERIAL = 1;
    public static final int PARALLEL = 2;
    public static final int DEFAULT_TIMEOUT = 60;
    public static final String P_ALLOCDEVID = "p_AllocDevID";
    public static final String P_VERIFYDEVID = "p_VerifyDevID";
    public static final String P_HASNEEXISTED = "p_HasNEExisted";
    public static final String P_GETNUMOFNE = "p_GetNumOfNE";
    public static final String P_GETLICENSENUMOFNE = "p_GetLicenseNumOfNE";
    public static final String P_CHECKGNE = "p_CheckGne";
    public static final String P_ISNENAMEOCCUPIED = "p_IsNENameOccupied";
    public static final String P_VERIFYPHYID = "p_VerifyPhyID";
    public static final String P_GETDEVIDBYPHYID = "p_GetDevIDByPhyID";
    public static final String P_GETPHYIDBYDEVID = "p_GetPhyIDByDevID";
    public static final String P_GETGNEDETAIL = "p_GetGneDetail";
    public static final String P_ALLOCTL1PHYID = "p_AllocTL1PhyID";
    public static final String P_CHECKGNEPROTOCOL = "p_CheckGneProtocol";
    public static final String P_GETNEIDBYADDR = "p_GetNeidByAddr";
    private static final String STR_SQL_SELECT_RESULT_TABLE = "select spName, userSPNo, result from #SumNESPResult";
    private static final String STR_SQL_SELECT_RESULT_TABLE_ORACLE = "select spName, userSPNo, result from MCDB.tmp_SumNESPResult";
    private static final String STR_SQL_CREATE_RESULT_TABLE = "create table #SumNESPResult (spName varchar(128) not null, userSPNo int not null, result int, primary key(spName, userSPNo))\n ";
    private static final String STR_SQL_SELECT_NESP_REG_INFO = "select cNeMgrSvrProcType, cNeMgrSvrProcHandle, cDbName, cNeSPName, cDbServerName from tbl_RegNESP";
    private static final String STR_SQL_SELECT_NESP_REG_INFO_ORACLE = "select cNeMgrSvrProcType, cNeMgrSvrProcHandle, cDbName, cNeSPName, cDbServerName from MCDB.tbl_RegNESP";
    private static final String STR_SQL_DROP_RESULT_TABLE = "if object_id('tempdb..#SumNESPResult') is not null\n drop table #SumNESPResult";
    private static final String STR_SQL_DELETE_RESULT_TABLE = "delete #SumNESPResult ";
    private static Logger log = LoggerFactory.getLogger(NESPTransaction.class);
    private List<NESP> al_NESPs = new ArrayList<NESP>();
    private List<NESPRegInfo> al_NERegInfos = new ArrayList<NESPRegInfo>();
    private List<Map<Integer, Object>> al_LastExecResult = new ArrayList<Map<Integer, Object>>();
    private Connection conn = null;
    private int connIsolationType;
    private int isolationLevel = 1;
    private TRANSTATE state = null;
    private int finishedNESPCount = 0;
    private ProcessInfo info = null;

    public static NESPTransaction getInstance(ProcessInfo info, int ... isolationLevel) {
        if (isolationLevel.length == 0) {
            return new NESPTransaction(1, info);
        }
        return new NESPTransaction(isolationLevel[0], info);
    }

    private NESPTransaction(int isolationLevel, ProcessInfo info) {
        this.info = info;
        this.isolationLevel = isolationLevel;
        this.state = TRANSTATE.INIT;
        this.finishedNESPCount = 0;
        this.getNESPRegInfo();
    }

    public void addNESP(String spName) {
        this.addNESP(spName, -1);
    }

    public void addNESP(String spName, int spNo) {
        NESP tempSp = new NESP(spName, spNo);
        if (this.al_NESPs.contains(tempSp)) {
            log.error("AddNESP receive duplicate paras,spName:" + spName + ",spNo:" + spNo);
            return;
        }
        this.al_NESPs.add(tempSp);
    }

    public void addNESP(String spName, List<SPParameter> paras) {
        this.addNESP(spName, -1, paras);
    }

    public void addNESP(String spName, int spNo, List<SPParameter> paras) {
        NESP tempSp = new NESP(spName, spNo, paras);
        for (NESP sp : this.al_NESPs) {
            if (!sp.equals(tempSp)) continue;
            log.error("AddNESP receive duplicate paras,spName:" + spName + ",spNo:" + spNo);
            return;
        }
        this.al_NESPs.add(tempSp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTransaction() {
        Statement stmt = null;
        try {
            if (null != this.conn && TRANSTATE.INIT != this.state) {
                if (2 != DBConfiguration.getInstance().getDbType()) {
                    stmt = this.conn.createStatement();
                    stmt.execute(STR_SQL_DELETE_RESULT_TABLE);
                }
                this.conn.commit();
                this.conn.setAutoCommit(true);
                this.state = TRANSTATE.PAUSE;
            }
        }
        catch (Exception e) {
            log.error("Pause Transaction Fail!", (Throwable)e);
        }
        finally {
            this.closeRes(null, stmt, null);
        }
        this.finishedNESPCount = 0;
        this.al_NESPs.clear();
    }

    public int continueTransaction() {
        return this.continueTransaction(60);
    }

    public int continueTransaction(int timeout) {
        int errCode = 0;
        try {
            if (TRANSTATE.PAUSE == this.state) {
                this.setBeginTran();
                this.state = TRANSTATE.BEGIN;
            }
        }
        catch (Exception e) {
            log.error("Set Connection AutoCommit Fail.", (Throwable)e);
            return 1090646291;
        }
        if (TRANSTATE.BEGIN == this.state) {
            errCode = this.getLock(timeout);
            if (0 != errCode) {
                return errCode;
            }
            this.state = TRANSTATE.LOCKED;
        }
        if (TRANSTATE.LOCKED != this.state) {
            return 1090646291;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Statement stmt = null;
        if (null != this.conn) {
            if (TRANSTATE.LOCKED == this.state && !this.al_NESPs.isEmpty()) {
                if (2 == DBConfiguration.getInstance().getDbType()) {
                    this.orecleCreateDevMsg();
                } else {
                    this.sendCreateDevMsg();
                }
            }
            try {
                if (TRANSTATE.INIT != this.state) {
                    this.conn.commit();
                    this.conn.setAutoCommit(true);
                    this.state = TRANSTATE.INIT;
                }
                if (1 == DBConfiguration.getInstance().getDbType()) {
                    this.conn.setTransactionIsolation(this.connIsolationType);
                }
                if (2 != DBConfiguration.getInstance().getDbType()) {
                    stmt = this.conn.createStatement();
                    stmt.execute(STR_SQL_DROP_RESULT_TABLE);
                }
                this.closeRes(this.conn, stmt, null);
            }
            catch (Exception e) {
                log.error("destroy fail.", (Throwable)e);
            }
            finally {
                this.closeRes(this.conn, stmt, null);
            }
        }
        this.al_NESPs.clear();
        this.finishedNESPCount = 0;
    }

    public List<Map<Integer, Object>> getLastExecResult() {
        return this.al_LastExecResult;
    }

    public int resultOf(String spName) {
        return this.resultOf(spName, -1);
    }

    public int resultOf(String spName, int spNo) {
        NESP tempSp = new NESP(spName, spNo);
        for (NESP sp : this.al_NESPs) {
            if (!sp.equals(tempSp)) continue;
            return sp.result;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDevIDByPhyId(int phyId) {
        String LINE_SEP = System.getProperty("line.separator");
        String QUERY_RECEIVE_BUFFER = "declare @devType int" + LINE_SEP + "set @devType = %s" + LINE_SEP + "exec @devType=%s..p_GetDevIDByPhyID @devType" + LINE_SEP + "select @devType as result";
        for (NESPRegInfo nespRegInfo : this.al_NERegInfos) {
            if (!P_GETDEVIDBYPHYID.equalsIgnoreCase(nespRegInfo.spName)) continue;
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = DBPool.getInstance().getConnection();
                if (null == conn) {
                    log.info("Get DB Connection Fail.");
                }
                pstmt = conn.prepareStatement(String.format(QUERY_RECEIVE_BUFFER, phyId, nespRegInfo.dbName));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int exeRe = rs.getInt(1);
                    if (exeRe <= 0) continue;
                    int n = exeRe;
                    this.releaseDBRes(conn, pstmt, rs);
                    return n;
                }
                this.releaseDBRes(conn, pstmt, rs);
            }
            catch (SQLException e) {
                log.error("Query SubscribEvents Fail!", (Throwable)e);
            }
            finally {
                this.releaseDBRes(conn, pstmt, rs);
            }
        }
        return 0;
    }

    protected void releaseDBRes(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.info("Close DB Connection Fail!", (Throwable)e);
        }
    }

    public int exec() {
        return this.exec(60);
    }

    public int exec(int timeout) {
        int ret = 0;
        try {
            if ((null == this.conn || this.conn.isClosed()) && 0 != (ret = this.prepareConnection())) {
                log.info("Get Connection Fail.");
                return ret;
            }
            ret = this.setTranstate(timeout);
            if (0 != ret) {
                return ret;
            }
            this.al_LastExecResult.clear();
            int nsize = this.al_NESPs.size();
            for (int n = this.finishedNESPCount; n < nsize; ++n) {
                ret = DBConfiguration.getInstance().getDbType() == 2 ? this.execOneOracleNESP(this.al_NESPs.get(n)) : this.execOneNESP(this.al_NESPs.get(n));
                if (0 == ret) continue;
                return ret;
            }
            this.finishedNESPCount = this.al_NESPs.size();
        }
        catch (Exception e) {
            log.error("Exec Fail!", (Throwable)e);
            return 1090646291;
        }
        return this.getResultFromDB();
    }

    private int setTranstate(int timeout) throws SQLException {
        int ret = 0;
        if (this.state == TRANSTATE.INIT) {
            this.setBeginTran();
            this.state = TRANSTATE.BEGIN;
        }
        if (TRANSTATE.BEGIN == this.state) {
            ret = this.getLock(timeout);
            if (0 != ret) {
                return ret;
            }
            this.state = TRANSTATE.LOCKED;
        }
        if (TRANSTATE.LOCKED != this.state) {
            return 1090646291;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBeginTran() throws SQLException {
        if (0 == DBConfiguration.getInstance().getDbType()) {
            Statement stmt = null;
            try {
                stmt = this.conn.createStatement();
                stmt.execute("begin tran");
            }
            finally {
                if (null != stmt) {
                    stmt.close();
                }
            }
        } else {
            this.conn.setAutoCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execOneOracleNESP(NESP sp) {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            for (NESPRegInfo nespRegInfo : this.al_NERegInfos) {
                if (!sp.spName.equalsIgnoreCase(nespRegInfo.spName)) continue;
                StringBuffer sqlStrBuffer = new StringBuffer(32);
                sqlStrBuffer.append("declare ret integer;");
                sqlStrBuffer.append("begin ");
                sqlStrBuffer.append("mcdb.sp_execsp(");
                this.appentStr(sqlStrBuffer, nespRegInfo.dbName);
                this.appentStr(sqlStrBuffer, sp.spName);
                if (sp.paras.size() == 0) {
                    this.appentStr(sqlStrBuffer, "");
                }
                int len = sp.paras.size();
                for (int i = 0; i < len; ++i) {
                    SPParameter para = sp.paras.get(i);
                    Object value = para.getValue();
                    if (value instanceof Number) {
                        sqlStrBuffer.append(value).append(',');
                        continue;
                    }
                    this.appentStr(sqlStrBuffer, value.toString());
                }
                sqlStrBuffer.append(sp.userSPNo).append(");");
                sqlStrBuffer.append(" end;");
                String sqlStr = sqlStrBuffer.toString();
                log.info("execOneOracleNESP is" + sqlStr);
                stmt.execute(sqlStr);
            }
        }
        catch (Exception e) {
            log.error("Exec Fail!", (Throwable)e);
            int n = 1090646291;
            return n;
        }
        finally {
            this.closeRes(null, stmt, null);
        }
        return 0;
    }

    private void appentStr(StringBuffer strBuf, String str) {
        strBuf.append("'" + str + "',");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execOneNESP(NESP sp) {
        CallableStatement cstmt = null;
        PreparedStatement stmt = null;
        StringBuilder osSQL = new StringBuilder();
        osSQL.append(" insert into #SumNESPResult values ('");
        osSQL.append(sp.spName);
        osSQL.append("', ");
        osSQL.append(sp.userSPNo);
        osSQL.append(", 0)");
        String sqlStr = osSQL.toString();
        try {
            stmt = this.conn.prepareStatement(sqlStr);
            stmt.executeUpdate();
            for (NESPRegInfo nespRegInfo : this.al_NERegInfos) {
                if (!sp.spName.equalsIgnoreCase(nespRegInfo.spName)) continue;
                cstmt = this.conn.prepareCall(this.getExecSQL(sp, nespRegInfo.dbName));
                cstmt.registerOutParameter(1, 4);
                this.fillStmtParam(cstmt, sp);
                cstmt.execute();
                try {
                    this.saveExecResult(cstmt);
                    this.fillNESPOutResult(cstmt, sp);
                    this.updateNESPResult(sp, cstmt.getInt(1));
                }
                catch (Exception e) {
                    log.error("execOneNESP Exec Result null!");
                }
            }
        }
        catch (Exception e) {
            log.error("Exec Fail!", (Throwable)e);
            int n = 1090646291;
            return n;
        }
        finally {
            this.closeRes(null, cstmt, null);
            this.closeRes(null, stmt, null);
        }
        return 0;
    }

    private String getExecSQL(NESP sp, String dbName) {
        StringBuilder osSQL = new StringBuilder();
        osSQL.append("{? = call ");
        osSQL.append(dbName);
        osSQL.append(".dbo.");
        osSQL.append(sp.spName);
        int size = sp.paras.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                osSQL.append("(");
            }
            osSQL.append("?");
            if (i != size - 1) {
                osSQL.append(",");
                continue;
            }
            osSQL.append(")");
        }
        osSQL.append("}");
        log.debug(osSQL.toString());
        return osSQL.toString();
    }

    private void saveExecResult(CallableStatement cstmt) throws SQLException {
        ResultSet rs = null;
        int updateCount = -1;
        do {
            if ((updateCount = cstmt.getUpdateCount()) != -1) {
                cstmt.getMoreResults();
                continue;
            }
            rs = cstmt.getResultSet();
            if (rs == null) continue;
            int colCount = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                HashMap<Integer, Object> execResult = new HashMap<Integer, Object>();
                for (int i = 1; i <= colCount; ++i) {
                    execResult.put(i, rs.getObject(i));
                }
                this.al_LastExecResult.add(execResult);
            }
            cstmt.getMoreResults();
        } while (updateCount != -1 || rs != null);
        this.closeRes(null, null, rs);
    }

    private void fillStmtParam(CallableStatement cstmt, NESP sp) {
        int size = sp.paras.size();
        for (int i = 0; i < size; ++i) {
            SPHelper.convertParameter(cstmt, i + 2, sp.paras.get(i));
        }
    }

    private void fillNESPOutResult(CallableStatement cstmt, NESP sp) {
        int size = sp.paras.size();
        for (int i = 0; i < size; ++i) {
            SPHelper.fillOutputParameter(cstmt, i + 2, sp.paras.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNESPResult(NESP sp, int result) {
        StringBuilder osSQL = new StringBuilder();
        osSQL.append(" update #SumNESPResult set result = ");
        osSQL.append(result);
        osSQL.append(" where spName='");
        osSQL.append(sp.spName);
        osSQL.append("' and userSPNo=");
        osSQL.append(sp.userSPNo);
        if (log.isDebugEnabled()) {
            log.debug("updateNESPResult SQL:" + osSQL.toString());
        }
        Statement stmt = null;
        String sqlStr = osSQL.toString();
        try {
            stmt = this.conn.createStatement();
            stmt.executeUpdate(sqlStr);
        }
        catch (SQLException e) {
            log.error("updateNESPResult Fail,SQL is:" + sqlStr, (Throwable)e);
        }
        finally {
            this.closeRes(null, stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getResultFromDB() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = 2 == DBConfiguration.getInstance().getDbType() ? this.conn.prepareStatement(STR_SQL_SELECT_RESULT_TABLE_ORACLE) : this.conn.prepareStatement(STR_SQL_SELECT_RESULT_TABLE);
            rs = ps.executeQuery();
            while (rs.next()) {
                String db_spName = rs.getString("spName");
                int db_userSPNo = rs.getInt("userSPNo");
                for (NESP sp : this.al_NESPs) {
                    if (!sp.spName.equalsIgnoreCase(db_spName) || sp.userSPNo != db_userSPNo) continue;
                    sp.result = rs.getInt("result");
                }
            }
            this.closeRes(null, ps, rs);
        }
        catch (Exception e) {
            try {
                log.error("Get Result From DB Fail:select spName, userSPNo, result from #SumNESPResult", (Throwable)e);
                int n = 1090646291;
                this.closeRes(null, ps, rs);
                return n;
            }
            catch (Throwable throwable) {
                this.closeRes(null, ps, rs);
                throw throwable;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareConnection() {
        this.conn = DBPool.getInstance().getConnection();
        if (null == this.conn) {
            return 1090646291;
        }
        if (0 != this.getNESPRegInfo()) {
            return 1090646291;
        }
        Statement stmt = null;
        try {
            if (2 != DBConfiguration.getInstance().getDbType()) {
                stmt = this.conn.createStatement();
                stmt.execute(STR_SQL_CREATE_RESULT_TABLE);
                stmt.close();
            }
            if (1 == DBConfiguration.getInstance().getDbType()) {
                this.connIsolationType = this.conn.getTransactionIsolation();
                if (this.connIsolationType != 2) {
                    this.conn.setTransactionIsolation(2);
                }
            }
            this.closeRes(null, stmt, null);
        }
        catch (Exception e) {
            try {
                log.error("Exec SQL Fail:create table #SumNESPResult (spName varchar(128) not null, userSPNo int not null, result int, primary key(spName, userSPNo))\n ", (Throwable)e);
                int n = 1090646291;
                this.closeRes(null, stmt, null);
                return n;
            }
            catch (Throwable throwable) {
                this.closeRes(null, stmt, null);
                throw throwable;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNESPRegInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        Connection connt = null;
        try {
            connt = DBPool.getInstance().getConnection();
            stmt = connt.createStatement();
            rs = DBConfiguration.getInstance().getDbType() == 2 ? stmt.executeQuery(STR_SQL_SELECT_NESP_REG_INFO_ORACLE) : stmt.executeQuery(STR_SQL_SELECT_NESP_REG_INFO);
            this.al_NERegInfos.clear();
            while (rs.next()) {
                NESPRegInfo tempSp = new NESPRegInfo();
                tempSp.procID = rs.getInt("cNeMgrSvrProcType");
                tempSp.procHandle = rs.getInt("cNeMgrSvrProcHandle");
                tempSp.dbName = rs.getString("cDbName");
                tempSp.spName = rs.getString("cNeSPName");
                tempSp.serverName = rs.getString("cDbServerName");
                this.al_NERegInfos.add(tempSp);
            }
            this.closeRes(connt, stmt, rs);
        }
        catch (Exception e) {
            try {
                log.error("Get NESP Register Info Fail:select cNeMgrSvrProcType, cNeMgrSvrProcHandle, cDbName, cNeSPName, cDbServerName from tbl_RegNESP", (Throwable)e);
                int n = 1090646291;
                this.closeRes(connt, stmt, rs);
                return n;
            }
            catch (Throwable throwable) {
                this.closeRes(connt, stmt, rs);
                throw throwable;
            }
        }
        return 0;
    }

    public List<NESPRegInfo> getAllRegInfo() {
        return this.al_NERegInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orecleCreateDevMsg() {
        ArrayList<BigInteger> newDevIDs = new ArrayList<BigInteger>();
        CallableStatement cstmt = null;
        StringBuilder osSQL = new StringBuilder();
        osSQL.append("{? = call MCDB.");
        osSQL.append(P_HASNEEXISTED);
        osSQL.append("(?)");
        osSQL.append("}");
        log.debug(osSQL.toString());
        try {
            cstmt = this.conn.prepareCall(osSQL.toString());
            for (NESP it : this.al_NESPs) {
                if ((!it.spName.trim().equalsIgnoreCase(P_ALLOCDEVID) || it.result == 0) && (!it.spName.trim().equalsIgnoreCase(P_VERIFYDEVID) || it.result != 0)) continue;
                cstmt.registerOutParameter(1, 4);
                cstmt.setInt(2, it.result);
                cstmt.execute();
                int result = cstmt.getInt(1);
                if (result > 0) {
                    newDevIDs.add(BigInteger.valueOf(result));
                }
                cstmt.clearParameters();
            }
        }
        catch (Exception e) {
            log.error("Call p_HasNEExisted error.", (Throwable)e);
        }
        finally {
            this.closeRes(null, cstmt, null);
        }
        if (newDevIDs.isEmpty()) {
            return;
        }
        NECoordinatorService service = NECoordinatorService.getInstance(this.info);
        service.notifyNECreate(newDevIDs, this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCreateDevMsg() {
        ArrayList<BigInteger> newDevIDs = new ArrayList<BigInteger>();
        CallableStatement cstmt = null;
        StringBuilder osSQL = new StringBuilder();
        osSQL.append("{? = call MCDB.dbo.");
        osSQL.append(P_HASNEEXISTED);
        osSQL.append("(?)");
        osSQL.append("}");
        log.debug(osSQL.toString());
        try {
            cstmt = this.conn.prepareCall(osSQL.toString());
            for (NESP it : this.al_NESPs) {
                if ((!it.spName.trim().equalsIgnoreCase(P_ALLOCDEVID) || it.result == 0) && (!it.spName.trim().equalsIgnoreCase(P_VERIFYDEVID) || it.result != 0)) continue;
                cstmt.registerOutParameter(1, 4);
                cstmt.setInt(2, it.result);
                if (cstmt.execute()) {
                    newDevIDs.add(BigInteger.valueOf(it.result));
                }
                cstmt.clearParameters();
            }
        }
        catch (Exception e) {
            log.error("Call p_HasNEExisted error.", (Throwable)e);
        }
        finally {
            this.closeRes(null, cstmt, null);
        }
        if (newDevIDs.isEmpty()) {
            return;
        }
        NECoordinatorService service = NECoordinatorService.getInstance(this.info);
        service.notifyNECreate(newDevIDs, this.info);
    }

    private int getLock(int timeout) {
        switch (DBConfiguration.getInstance().getDbType()) {
            case 1: {
                return this.getMSSQLLock(timeout);
            }
            case 0: {
                return this.getSYBASELock(timeout);
            }
            case 2: {
                return this.getOracleLock();
            }
        }
        return 1090646291;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMSSQLLock(int timeout) {
        int connTimeout = 0;
        StringBuilder osSQL = new StringBuilder();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            osSQL.append("select @@LOCK_TIMEOUT\n");
            log.debug(osSQL.toString());
            rs = stmt.executeQuery(osSQL.toString());
            if (rs.next()) {
                connTimeout = rs.getInt(1);
            }
            osSQL = new StringBuilder();
            osSQL.append("SET LOCK_TIMEOUT ");
            osSQL.append(timeout * 1000);
            log.debug(osSQL.toString());
            stmt.execute(osSQL.toString());
            osSQL = new StringBuilder();
            if (this.isolationLevel == 1) {
                osSQL.append("update tbl_NESPLock set value = value + 1 ");
            } else {
                osSQL.append("declare @lock_result int \n select @lock_result=value from tbl_NESPLock with (REPEATABLEREAD) ");
            }
            log.debug(osSQL.toString());
            stmt.execute(osSQL.toString());
            osSQL = new StringBuilder();
            osSQL.append("SET LOCK_TIMEOUT ");
            osSQL.append(connTimeout);
            log.debug(osSQL.toString());
            stmt.execute(osSQL.toString());
            this.closeRes(null, stmt, rs);
        }
        catch (Exception e) {
            try {
                log.error("Lock DB Fail:" + osSQL.toString(), (Throwable)e);
                int n = 1090646293;
                this.closeRes(null, stmt, rs);
                return n;
            }
            catch (Throwable throwable) {
                this.closeRes(null, stmt, rs);
                throw throwable;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOracleLock() {
        StringBuilder osSQL = new StringBuilder();
        osSQL.append("lock table MCDB.tbl_NESPLock in ");
        if (1 == this.isolationLevel) {
            osSQL.append("exclusive mode ");
        } else {
            osSQL.append("share mode ");
        }
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.execute(osSQL.toString());
        }
        catch (Exception e) {
            log.error("Lock DB Fail:" + osSQL.toString(), (Throwable)e);
            int n = 1090646293;
            return n;
        }
        finally {
            this.closeRes(null, stmt, null);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSYBASELock(int timeout) {
        StringBuilder osSQL = new StringBuilder();
        osSQL.append("lock table tbl_NESPLock in ");
        if (1 == this.isolationLevel) {
            osSQL.append("exclusive mode ");
        } else {
            osSQL.append("share mode ");
        }
        if (timeout >= 0) {
            osSQL.append("wait ");
            osSQL.append(timeout);
        }
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.execute(osSQL.toString());
        }
        catch (Exception e) {
            log.error("Lock DB Fail:" + osSQL.toString(), (Throwable)e);
            int n = 1090646293;
            return n;
        }
        finally {
            this.closeRes(null, stmt, null);
        }
        return 0;
    }

    private void closeRes(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.error("Close Connection Fail.", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TRANSTATE {
        INIT,
        BEGIN,
        LOCKED,
        PAUSE;

    }
}

