/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.necoordinator;

import com.huawei.commextend.necoordinator.asn.AsnProcID;
import com.huawei.communicate.asn1.AsnDevIDListOfNEMgr;
import com.huawei.communicate.asn1.AsnFrameProcID;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NECoordinatorService {
    private ProcessInfo procInfo = null;
    private static Map<ProcessInfo, NECoordinatorService> serviceCache = new HashMap<ProcessInfo, NECoordinatorService>();

    public static synchronized NECoordinatorService getInstance(ProcessInfo procInfo) {
        NECoordinatorService service = serviceCache.get(procInfo);
        if (null != service) {
            return service;
        }
        service = new NECoordinatorService(procInfo);
        serviceCache.put(procInfo, service);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(ProcessInfo info) {
        Map<ProcessInfo, NECoordinatorService> map = serviceCache;
        synchronized (map) {
            serviceCache.remove(info);
        }
    }

    private NECoordinatorService(ProcessInfo info) {
        this.procInfo = info;
    }

    public int notifyNEMgrSvrStartup() {
        AsnProcID asnProcId = new AsnProcID();
        asnProcId.procType = this.procInfo.getProcID().charValue();
        asnProcId.procHandle = this.procInfo.getProcHandle().charValue();
        return MsgProxy.getProxyService((ProcessInfo)this.procInfo).sendAsyncMessage(NECoordinatorService.buildMSGHead(2256900), (FStruct)asnProcId, null);
    }

    public int notifyNETransfer(int devID, ProcessInfo procInfo) {
        ArrayList<BigInteger> devIDList = new ArrayList<BigInteger>();
        devIDList.add(BigInteger.valueOf(devID));
        return this.notifyNEListTransfer(devIDList, procInfo);
    }

    public int notifyNEListTransfer(List<BigInteger> devIDList, ProcessInfo procInfo) {
        if (null == devIDList || devIDList.isEmpty()) {
            return 0;
        }
        return MsgProxy.getProxyService((ProcessInfo)procInfo).sendAsyncMessage(NECoordinatorService.buildMSGHead(1134594), (FStruct)this.getAsnDevIDList(devIDList, this.procInfo, procInfo), null);
    }

    public int notifyNETransfer(int devID, ProcessInfo srcProcInfo, ProcessInfo snkProcInfo) {
        ArrayList<BigInteger> devIDList = new ArrayList<BigInteger>();
        devIDList.add(BigInteger.valueOf(devID));
        return this.notifyNETransfer(devIDList, srcProcInfo, snkProcInfo);
    }

    public int notifyNETransfer(List<BigInteger> devIDList, ProcessInfo srcProcInfo, ProcessInfo snkProcInfo) {
        if (null == devIDList || devIDList.isEmpty()) {
            return 0;
        }
        return MsgProxy.getProxyService((ProcessInfo)this.procInfo).sendAsyncMessage(NECoordinatorService.buildMSGHead(1134594), (FStruct)this.getAsnDevIDList(devIDList, srcProcInfo, snkProcInfo), null);
    }

    public int notifyNEDelete(int devID) {
        ArrayList<BigInteger> devIDList = new ArrayList<BigInteger>();
        devIDList.add(BigInteger.valueOf(devID));
        return MsgProxy.getProxyService((ProcessInfo)this.procInfo).sendAsyncMessage(NECoordinatorService.buildMSGHead(2256904), (FStruct)this.getAsnDevIDList(devIDList, this.procInfo, this.procInfo), null);
    }

    public int notifyNECreate(int devID) {
        return this.notifyNECreate(devID, this.procInfo);
    }

    public int notifyNECreate(int devID, ProcessInfo ownerEMProcID) {
        ArrayList<BigInteger> devIDList = new ArrayList<BigInteger>();
        devIDList.add(BigInteger.valueOf(devID));
        return this.notifyNECreate(devIDList, ownerEMProcID);
    }

    public int notifyNECreate(List<BigInteger> devIDList, ProcessInfo ownerEMProcID) {
        if (null == devIDList || devIDList.isEmpty()) {
            return 0;
        }
        return MsgProxy.getProxyService((ProcessInfo)this.procInfo).sendAsyncMessage(NECoordinatorService.buildMSGHead(0x227007), (FStruct)this.getAsnDevIDList(devIDList, ownerEMProcID, ownerEMProcID), null);
    }

    private AsnDevIDListOfNEMgr getAsnDevIDList(List<BigInteger> devIDList, ProcessInfo srcProcessInfo, ProcessInfo snkProcessInfo) {
        AsnDevIDListOfNEMgr asnDevIdList = new AsnDevIDListOfNEMgr();
        asnDevIdList.srcProcID.procType = srcProcessInfo.getProcID().charValue();
        asnDevIdList.srcProcID.procHandle = srcProcessInfo.getProcHandle().charValue();
        asnDevIdList.snkProcID = new AsnFrameProcID();
        asnDevIdList.snkProcID.procType = snkProcessInfo.getProcID().charValue();
        asnDevIdList.snkProcID.procHandle = snkProcessInfo.getProcHandle().charValue();
        asnDevIdList.devIDList.addAll(devIDList);
        return asnDevIdList;
    }

    static MSGHead buildMSGHead(int cmdCode) {
        return NECoordinatorService.buildMSGHead(cmdCode, (byte)0);
    }

    static MSGHead buildMSGHead(int cmdCode, byte moduleID) {
        MSGHead head = MSGHeadBuilder.createMSGHead((int)cmdCode);
        head.receiverProcID = (char)3001;
        head.receiverModule = moduleID;
        return head;
    }
}

