/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.necoordinator;

import com.huawei.commextend.necoordinator.FTPSvcInfo;
import com.huawei.communicate.asn1.AsnNameList;
import com.huawei.communicate.asn1.AsnNameValue;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FTPAgent {
    private static final char FRAME_PROCID_DAM = '\u0bb8';
    private static final int CMDCODE_GETFTPINFOBYNEIP = 4193197;
    private static final String FTPTYPE_FTP = "1";
    private static final String FTPTYPE_SFTP = "2";
    private static final int FTPERR_SUCCESS = 0;
    private static final int FTPERR_PARAISNULL = -1;
    private static final int RESULT_POS = 0;
    private static final int USER_POS = 1;
    private static IProxyService proxyService = MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
    private static final Logger log = LoggerFactory.getLogger(FTPAgent.class);

    private FTPAgent() {
    }

    public static int getFTPSvcByNEIP(FTPSvcInfo info, String neIP) {
        return FTPAgent.getFtpInfoFromMC(info, neIP, FTPTYPE_FTP);
    }

    public static int getSFTPSvcByNEIP(FTPSvcInfo info, String neIP) {
        return FTPAgent.getFtpInfoFromMC(info, neIP, FTPTYPE_SFTP);
    }

    private static int getFtpInfoFromMC(FTPSvcInfo info, String neIP, String ftpType) {
        if (null == neIP || neIP.isEmpty()) {
            log.error("neIP is null");
            return -1;
        }
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)4193197);
        msgHead.receiverProcID = (char)3000;
        msgHead.receiverProcHandle = '\u0000';
        msgHead.receiverModule = 0;
        AsnNameList req = new AsnNameList();
        req.add((Object)FTPAgent.getAsnNameValue("ftptype", ftpType));
        req.add((Object)FTPAgent.getAsnNameValue("neip", neIP));
        AsnNameList rsp = new AsnNameList();
        int retcode = proxyService.sendMessage(msgHead, (FStruct)req, (FStruct)rsp);
        if (retcode != 0) {
            return retcode;
        }
        int resultCode = Integer.parseInt(new String(FTPAgent.getAsnValue(rsp, 0)));
        if (resultCode != 0) {
            return resultCode;
        }
        info.user = new String(FTPAgent.getAsnValue(rsp, 1));
        info.password = FTPAgent.getAsnValue(rsp, 2);
        info.path = new String(FTPAgent.getAsnValue(rsp, 3));
        info.ipAddress = new String(FTPAgent.getAsnValue(rsp, 4));
        info.location = Integer.parseInt(new String(FTPAgent.getAsnValue(rsp, 5)));
        info.port = Integer.parseInt(new String(FTPAgent.getAsnValue(rsp, 6)));
        info.state = Integer.parseInt(new String(FTPAgent.getAsnValue(rsp, 7)));
        return 0;
    }

    static AsnNameValue getAsnNameValue(String name, String value) {
        AsnNameValue asn = new AsnNameValue();
        asn.name = name.getBytes();
        asn.value = value.getBytes();
        return asn;
    }

    private static byte[] getAsnValue(AsnNameList rsp, int pos) {
        AsnNameValue item = (AsnNameValue)rsp.get(pos);
        return item.value;
    }
}

