/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil.uid;

import java.util.List;

public final class StrUIDTool {
    public static final char DEFAULT_SEP_IN = '=';
    public static final char DEFAULT_SEP_OUT = ',';
    public static final char U2K_FDN_VALUE_SEPARATOR = '|';
    public static final char U2K_FDN_ESCAPE_CHAR = '\\';
    private static final int CHAR_32 = 32;
    private static final int CHAR_126 = 126;

    private StrUIDTool() {
    }

    private static boolean isValid(char target) {
        return ' ' <= target && '~' >= target;
    }

    public static boolean isValid(String target) {
        int iSize = target.length();
        for (int i = 0; i < iSize; ++i) {
            if (StrUIDTool.isValid(target.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigital(String target) {
        int len = target.length();
        for (int i = 0; i < len; ++i) {
            if ('0' <= target.charAt(i) && '9' >= target.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String transfer(String value, char sep_in, char sep_out) {
        StringBuffer buf = new StringBuffer();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (sep_in == ch) {
                buf.append("\\e");
                continue;
            }
            if (sep_out == ch) {
                buf.append("\\c");
                continue;
            }
            if ('\\' == ch) {
                buf.append("\\\\");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String untransfer(String value, char sep_in, char sep_out) {
        StringBuffer buf = new StringBuffer();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if ('\\' != ch) {
                buf.append(ch);
                continue;
            }
            if (i + 1 > len) {
                buf.append(ch);
                continue;
            }
            if ('c' == value.charAt(i + 1)) {
                buf.append(sep_out);
                ++i;
                continue;
            }
            if ('e' == value.charAt(i + 1)) {
                buf.append(sep_in);
                ++i;
                continue;
            }
            if ('\\' == value.charAt(i + 1)) {
                buf.append('\\');
                ++i;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String escape(String value, char sep) {
        StringBuffer buf = new StringBuffer();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (sep == ch) {
                buf.append('\\');
                buf.append(sep);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String unescape(String value, char sep) {
        return value.replaceAll("\\\\|", String.valueOf(sep));
    }

    public static int strSplit(List vct, String target) {
        vct.clear();
        StringBuffer str = new StringBuffer();
        int len = target.length();
        for (int i = 0; i < len; ++i) {
            char ch = target.charAt(i);
            if ('|' == ch) {
                vct.add(str.toString());
                str.delete(0, str.length());
                continue;
            }
            if ('\\' != ch) {
                str.append(ch);
                continue;
            }
            if (++i < len) {
                char ch1 = target.charAt(i);
                if ('|' == ch1) {
                    str.append(ch1);
                    continue;
                }
                str.append(ch);
                str.append(ch1);
                continue;
            }
            str.append(ch);
        }
        vct.add(str.toString());
        return vct.size();
    }
}

