/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil.uid;

import com.huawei.commextend.frameutil.uid.StrUIDTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrUIDParserImpl {
    private char seperator = (char)44;
    private Map mapUID = new HashMap();
    private List lstType = new ArrayList();
    private int index = -1;
    private int count = 0;

    public StrUIDParserImpl(char sepe) {
        this.seperator = sepe;
    }

    public boolean parse(String uid) {
        this.mapUID.clear();
        this.lstType.clear();
        String[] UID = uid.split(String.valueOf(this.seperator));
        int len = UID.length;
        for (int i = 0; i < len; ++i) {
            String[] str = UID[i].split(String.valueOf('='));
            if (str.length < 2) continue;
            this.mapUID.put(str[0], StrUIDTool.untransfer(str[1], '=', this.seperator));
            this.lstType.add(str[0]);
        }
        this.count = this.lstType.size();
        return true;
    }

    public boolean next() {
        ++this.index;
        return this.index < this.count;
    }

    public void setCurToFirst() {
        this.index = -1;
        this.count = this.lstType.size();
    }

    public String type() {
        return (String)this.lstType.get(this.index);
    }

    public String strValue() {
        String type = (String)this.lstType.get(this.index);
        return (String)this.mapUID.get(type);
    }

    public String strValue(String type) {
        return (String)this.mapUID.get(type);
    }

    public long intValue() {
        String type = (String)this.lstType.get(this.index);
        String value = (String)this.mapUID.get(type);
        if (null == value) {
            return 0L;
        }
        if (!StrUIDTool.isDigital(value)) {
            return 0L;
        }
        return Long.valueOf(value);
    }

    public long intValue(String type) {
        String value = (String)this.mapUID.get(type);
        if (null == value) {
            return 0L;
        }
        if (!StrUIDTool.isDigital(value)) {
            return 0L;
        }
        return Long.valueOf(value);
    }

    public String getMOC() {
        if (this.count > 0) {
            return (String)this.lstType.get(this.count - 1);
        }
        return "";
    }

    public String getParentFDN(String fdn) {
        int pos = fdn.lastIndexOf(44);
        if (pos < fdn.length()) {
            return fdn.substring(0, pos);
        }
        return "";
    }
}

