/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil.impl;

import com.huawei.commextend.frameutil.asn.AsnDetailDevProperty;
import com.huawei.commextend.frameutil.asn.AsnMapIfGetDevPropertyAck;
import com.huawei.commextend.frameutil.asn.AsnMapIfGetDevPropertyAckSeqOf;
import com.huawei.commextend.frameutil.asn.AsnMapIfGetDevPropertyReq;
import com.huawei.commextend.frameutil.asn.AsnMapIfGetDevPropertyReqSeqOf;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevCharsetCode {
    static final int TOPO_CMD_QUERY_DEVPROPERTY = 249;
    private static final int PROC_ID_TOPO = 51;
    static final String UTF_CHARSET = "UTF-8";
    static final String ISO_CHARSET = "ISO-8859-1";
    static final String GBK_CHARSET = "GBK";
    private static final BigInteger iUser = new BigInteger(Integer.toString(0));
    private static Map mapCharset = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(DevCharsetCode.class);

    private DevCharsetCode() {
    }

    public static int codeSetConvertUseDecode(String sourceConvert, String destionConvert, String fromCode, String toCode) {
        int convertRet = 0;
        Charset[] csets = new Charset[]{Charset.forName(UTF_CHARSET), Charset.forName(ISO_CHARSET), Charset.forName(GBK_CHARSET)};
        char[] fromArray = fromCode.toCharArray();
        CharBuffer bufFromCode = CharBuffer.wrap(fromArray);
        if (sourceConvert.equalsIgnoreCase(UTF_CHARSET)) {
            if (destionConvert.equalsIgnoreCase(ISO_CHARSET)) {
                ByteBuffer tempToBuffer = csets[1].encode(bufFromCode);
                toCode = tempToBuffer.toString();
            } else if (destionConvert.equalsIgnoreCase(GBK_CHARSET)) {
                ByteBuffer tempToBuffer = csets[2].encode(bufFromCode);
                toCode = tempToBuffer.toString();
            } else {
                toCode = fromCode;
            }
        } else if (destionConvert.equalsIgnoreCase(UTF_CHARSET)) {
            if (sourceConvert.equalsIgnoreCase(ISO_CHARSET)) {
                ByteBuffer tempToBuffer = csets[1].encode(bufFromCode);
                toCode = tempToBuffer.toString();
            } else if (sourceConvert.equalsIgnoreCase(GBK_CHARSET)) {
                ByteBuffer tempToBuffer = csets[2].encode(bufFromCode);
                toCode = tempToBuffer.toString();
            } else {
                toCode = fromCode;
            }
        }
        return convertRet;
    }

    public static int codeSetConvert(String sourceConvert, String destionConvert, String fromCode, String toCode) {
        int convertRet = 0;
        try {
            toCode = new String(fromCode.getBytes(sourceConvert), destionConvert);
            logger.info("CodeSetConvert processes error:");
            convertRet = 0;
        }
        catch (UnsupportedEncodingException e) {
            convertRet = 1;
            logger.error("CodeSetConvert processes error:" + e);
        }
        return convertRet;
    }

    public static String getCharset(int iDevID) {
        String strCodeset = "utf-8";
        String strFromMap = mapCharset.get(iDevID).toString();
        if (null == strFromMap || strFromMap.equals("")) {
            AsnMapIfGetDevPropertyReq asnReq = new AsnMapIfGetDevPropertyReq();
            AsnMapIfGetDevPropertyReqSeqOf asnReqOf = new AsnMapIfGetDevPropertyReqSeqOf();
            asnReq.iUserID = iUser;
            asnReqOf.add(iDevID);
            asnReq.lstDevID = asnReqOf;
            AsnMapIfGetDevPropertyAck asnAck = new AsnMapIfGetDevPropertyAck();
            ProcessInfo info = ConnectManager.getDefaultProcessInfo();
            MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)249);
            msgHead.receiverProcID = (char)51;
            msgHead.receiverProcHandle = '\u0000';
            msgHead.receiverModule = 0;
            int result = MsgProxy.getProxyService((ProcessInfo)info).sendMessage(msgHead, (FStruct)asnReq, (FStruct)asnAck);
            if (0 != result) {
                logger.error("GetCharset fail, the errorCode=" + result);
                return null;
            }
            AsnMapIfGetDevPropertyAckSeqOf asnAckOf = asnAck.oDevPropertySet;
            for (int i = 0; i < asnAckOf.size(); ++i) {
                AsnDetailDevProperty asnDevProperty = (AsnDetailDevProperty)asnAckOf.get(i);
                if (asnDevProperty.iDevID.intValue() != iDevID) continue;
                strCodeset = new String(asnDevProperty.strCodeSet);
            }
            mapCharset.put(iDevID, strCodeset);
        } else {
            strCodeset = strFromMap;
        }
        return strCodeset;
    }

    public static void updateCharset(int iDevID, String strCharset) {
        for (Object key : mapCharset.keySet()) {
            if (Integer.parseInt((String)key) == iDevID) {
                mapCharset.remove(key);
                mapCharset.put(iDevID, strCharset);
                continue;
            }
            mapCharset.put(iDevID, strCharset);
        }
    }
}

