/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import com.huawei.commextend.frameutil.asn.AsniMapRightCheckReq;
import com.huawei.commextend.frameutil.asn.AsniMapRightCheckRsp;
import com.huawei.commextend.security.RSACipherMgr;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenUtil {
    private static final long MAX_VALID_PERIOD = 3600000L;
    private static final long DETECT_INTERVAL = 1800000L;
    private static final int CMDCODE_IS_TOKEN_VALID = 1163;
    private static final int SECURITY_PROCID = 52;
    private static Map<Object, Long> tokens = new ConcurrentHashMap<Object, Long>();
    private static Logger logger = LoggerFactory.getLogger((String)TokenUtil.class.getName());
    private static Timer timer;
    private static final int TOKEN_ITEM_COUNT = 7;

    private TokenUtil() {
    }

    private static byte[] dencrypt(String decryByteStr) {
        return RSACipherMgr.getInstance().getCipherOper().decrypt(decryByteStr);
    }

    public static boolean isValid(Object token, String clientIP) {
        if (token != null) {
            return TokenUtil.isValid(token.toString(), null, clientIP, new boolean[0]);
        }
        return TokenUtil.isValid(null, null, clientIP, new boolean[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(String token, IProxyService proxyService, String clientIP, boolean ... isFromClient) {
        boolean isFromClientFlag = false;
        if (isFromClient.length > 0) {
            isFromClientFlag = isFromClient[0];
        }
        if (token == null) {
            logger.error("token is null, return false");
            return false;
        }
        Class<TokenUtil> clazz = TokenUtil.class;
        synchronized (TokenUtil.class) {
            if (timer == null) {
                timer = new Timer("token expired detection: " + System.currentTimeMillis(), true);
                timer.schedule((TimerTask)new TimeoutScan(), 1800000L, 1800000L);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            String tokenStr = null;
            if (isFromClientFlag) {
                tokenStr = token;
            } else {
                byte[] tokenByte = TokenUtil.dencrypt(token);
                String string = tokenStr = null == tokenByte ? null : new String(tokenByte);
                if (null == tokenStr) {
                    tokenStr = token;
                    logger.error("token dencrypt failed! reason: token is noe encrypt");
                }
            }
            if (!tokens.containsKey(tokenStr + clientIP)) {
                if (!TokenUtil.verifyTokenACL(tokenStr.getBytes(), clientIP)) {
                    return false;
                }
                if (TokenUtil.isExist(tokenStr, proxyService)) {
                    tokens.put(tokenStr + clientIP, System.currentTimeMillis());
                    return true;
                }
                return false;
            }
            tokens.put(tokenStr + clientIP, System.currentTimeMillis());
            return true;
        }
    }

    public static boolean verifyTokenACL(byte[] token, String terminalIP) {
        if (terminalIP == null) {
            return false;
        }
        String tokenStr = new String(token);
        String split = ";";
        String globalStr = Normalizer.normalize(tokenStr, Normalizer.Form.NFC);
        String[] items = globalStr.split(split = Normalizer.normalize(split, Normalizer.Form.NFC));
        if (items == null || items.length != 7) {
            return false;
        }
        boolean matchResult = terminalIP.equals(items[2]);
        if (!matchResult) {
            logger.error("token ACL verify fail, clientIp and tokenIp is different, tokenIP = " + items[2] + ", clientIp = " + terminalIP);
        }
        return matchResult;
    }

    public static boolean isTokenInCache(String token, String clientIP) {
        return tokens.containsKey(token + clientIP);
    }

    private static boolean isExist(Object token, IProxyService proxyService) {
        AsniMapRightCheckRsp rsp;
        int nRetCode;
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)1163);
        msgHead.receiverProcID = (char)52;
        msgHead.receiverModule = 0;
        AsniMapRightCheckReq req = new AsniMapRightCheckReq();
        req.token = token.toString().getBytes();
        if (proxyService == null) {
            proxyService = MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
        }
        if ((nRetCode = proxyService.sendMessage(msgHead, (FStruct)req, (FStruct)(rsp = new AsniMapRightCheckRsp()))) != 0) {
            logger.error("communicate failed: cmdCode = 1163, errorcode = " + nRetCode);
            return false;
        }
        if (rsp.result.intValue() != 0) {
            logger.warn("invalid token");
        }
        return rsp.result.intValue() == 0;
    }

    private static class TimeoutScan
    extends TimerTask {
        private TimeoutScan() {
        }

        public void run() {
            HashSet set = new HashSet(tokens.entrySet());
            for (Object e : set) {
                Map.Entry e2 = (Map.Entry)e;
                if (System.currentTimeMillis() - (Long)e2.getValue() <= 3600000L) continue;
                tokens.remove(e2.getKey());
            }
            logger.info(set.size() - tokens.size() + " tokens expired and are removed");
        }
    }
}

