/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import com.huawei.commextend.frameutil.asn.AsnPortTrunkReq;
import com.huawei.commextend.frameutil.asn.AsnPortTrunkRsp;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortTrunkUtil {
    private static final char FRAME_PROCID_DAM = '\u0bb8';
    private static int FRAME_CMD_PORTTRUNK_ADD_ACL = 0x3FFBB3;
    private static int FRAMECMD_PORTTRUNK_DEL_ACL = 4193204;
    private static final Logger log = LoggerFactory.getLogger(PortTrunkUtil.class);

    private PortTrunkUtil() {
    }

    public static int addACLNeRule(String addr, String portlist) {
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)FRAME_CMD_PORTTRUNK_ADD_ACL);
        msgHead.receiverProcID = (char)3000;
        msgHead.receiverProcHandle = '\u0000';
        AsnPortTrunkReq req = new AsnPortTrunkReq();
        req.ip = addr.getBytes();
        if (portlist != null) {
            req.portList = portlist.getBytes();
        }
        AsnPortTrunkRsp rsp = new AsnPortTrunkRsp();
        IProxyService proxyService = MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
        int retcode = proxyService.sendMessage(msgHead, (FStruct)req, (FStruct)rsp);
        if (retcode != 0) {
            log.error("addACLNeRule send message fail, msg code is " + retcode);
            return -1;
        }
        return rsp.result.intValue();
    }

    public static int delACLNeRule(String addr, String portlist) {
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)FRAMECMD_PORTTRUNK_DEL_ACL);
        msgHead.receiverProcID = (char)3000;
        msgHead.receiverProcHandle = '\u0000';
        AsnPortTrunkReq req = new AsnPortTrunkReq();
        req.ip = addr.getBytes();
        if (portlist != null) {
            req.portList = portlist.getBytes();
        }
        AsnPortTrunkRsp rsp = new AsnPortTrunkRsp();
        IProxyService proxyService = MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
        int retcode = proxyService.sendMessage(msgHead, (FStruct)req, (FStruct)rsp);
        if (retcode != 0) {
            log.error("delACLNeRule send message fail, msg code is " + retcode);
            return -1;
        }
        return rsp.result.intValue();
    }
}

