/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import com.huawei.communicate.asn1.AsnProcMoudleNode;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingUtil {
    private static final char FRAME_PROCID_MC = '\u0bb9';
    private static final int FRAMECMDCODE_DO_PING = 4193201;
    private static final Logger log = LoggerFactory.getLogger(PingUtil.class);

    public static List<String> ping(String[] ipAdress, int timeOut) {
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)4193201);
        msgHead.receiverProcID = (char)3001;
        msgHead.receiverProcHandle = '\u0000';
        msgHead.receiverModule = 0;
        AsnProcMoudleNode req = new AsnProcMoudleNode();
        req.procType = timeOut;
        for (int i = 0; i < ipAdress.length; ++i) {
            req.cMoudlelist.add((Object)ipAdress[i].getBytes());
        }
        AsnProcMoudleNode rsp = new AsnProcMoudleNode();
        IProxyService proxyService = MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
        int retcode = proxyService.sendMessage(msgHead, (FStruct)req, (FStruct)rsp);
        ArrayList<String> reachAbles = new ArrayList<String>();
        if (retcode != 0) {
            log.error("pingFromMC send message fail, msg code is " + retcode);
            return reachAbles;
        }
        if (rsp.procType != 0) {
            log.error("pingFromMC exe fail, fail code is " + rsp.procType);
            return reachAbles;
        }
        for (int i = 0; i < rsp.cMoudlelist.size(); ++i) {
            reachAbles.add(new String((byte[])rsp.cMoudlelist.get(i)));
        }
        return reachAbles;
    }
}

