/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMSFDNUtil {
    private static final String EMS_FILE_PATH = System.getenv("IMAP_ROOT") + "/etc/unitedmgr/emsflag/emsflag.cfg";
    private static String myEmsFlag = "";
    private static Logger log = LoggerFactory.getLogger(EMSFDNUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEMSFlag() {
        if (null != myEmsFlag && !myEmsFlag.isEmpty()) {
            return myEmsFlag;
        }
        String emsFlag = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(EMS_FILE_PATH)));
            String currentString = bufferedReader.readLine();
            while (currentString != null) {
                if (null != currentString && !currentString.isEmpty()) {
                    emsFlag = currentString.trim();
                }
                currentString = bufferedReader.readLine();
            }
        }
        catch (Exception e) {
            log.error("fail to read file", (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception e) {
                    log.error("fail to close file", (Throwable)e);
                }
            }
        }
        if (null != emsFlag) {
            myEmsFlag = emsFlag;
        }
        return myEmsFlag;
    }

    public static String appendEMSFlag(String inputFDN, String ... emsFlag) {
        String currentEmsFlag = "";
        currentEmsFlag = emsFlag.length > 0 ? emsFlag[0] : EMSFDNUtil.getEMSFlag();
        return "EM=" + currentEmsFlag + "," + inputFDN;
    }

    public static String removeEMSFlag(String inputFDN, String ... emsFlag) {
        String currentEmsFlag = "";
        currentEmsFlag = emsFlag.length > 0 ? emsFlag[0] : EMSFDNUtil.getEMSFlag();
        int headIndex = inputFDN.indexOf("EM=" + currentEmsFlag);
        if (headIndex < 0) {
            return inputFDN;
        }
        int splitIndex = inputFDN.indexOf(",");
        String outputString = inputFDN.substring(splitIndex + 1, inputFDN.length());
        return outputString;
    }

    public static void main(String[] args) {
        System.out.println(EMSFDNUtil.removeEMSFlag("EM=12212weqrq,yangsong", new String[0]));
        System.out.println(EMSFDNUtil.appendEMSFlag("yangsong", EMSFDNUtil.getEMSFlag()));
    }
}

