/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.dbpool.DBPool;
import com.huawei.commextend.frameutil.DevCompatibleInfo;
import com.huawei.commextend.necoordinator.FTPAgent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevCompatibleInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(FTPAgent.class);

    private DevCompatibleInfoUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addList(List<DevCompatibleInfo> devList) {
        boolean result = false;
        Connection conn = null;
        Statement ps = null;
        conn = DBPool.getInstance().getConnection();
        String dbName = DBConfiguration.getInstance().tableName("MCDB", "tbl_devcompatibleinfo");
        String sql = "insert into " + dbName + "(hwSysOid,hwVersion,hwCompatibleSysOid,hwCompatibleVersion,hwCompatibleVRCB,hwProductName) values (?,?,?,?,?,?)";
        try {
            conn.setAutoCommit(false);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < devList.size(); ++i) {
                DevCompatibleInfo info = devList.get(i);
                ps.setString(1, info.getHwSysOid());
                ps.setString(2, info.getHwVersion());
                ps.setString(3, info.getHwCompatibleSysOid());
                ps.setString(4, info.getHwCompatibleVersion());
                ps.setString(5, info.getHwCompatibleVRCB());
                ps.setString(6, info.getHwProductName());
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
            conn.setAutoCommit(true);
            result = true;
        }
        catch (Exception e) {
            result = false;
            log.error("add DevCompatibleInfo List fail", (Throwable)e);
        }
        finally {
            try {
                ps.close();
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException sqle) {
                log.error("add DevCompatibleInfo List SQLException", (Throwable)sqle);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getList(List<DevCompatibleInfo> devList) {
        boolean result = false;
        Connection conn = null;
        PreparedStatement ps = null;
        conn = DBPool.getInstance().getConnection();
        String dbName = DBConfiguration.getInstance().tableName("MCDB", "tbl_devcompatibleinfo");
        String sql = "select * from " + dbName + " where hwSysOid = ?";
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < devList.size(); ++i) {
                DevCompatibleInfo info = devList.get(i);
                ps.setString(1, info.getHwSysOid());
                ResultSet rs = null;
                try {
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        info.setHwVersion(rs.getString(2));
                        info.setHwCompatibleSysOid(rs.getString(3));
                        info.setHwCompatibleVersion(rs.getString(4));
                        info.setHwCompatibleVRCB(rs.getString(5));
                        info.setHwProductName(rs.getString(6));
                    }
                    continue;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            log.error("get DevCompatibleInfo List fail", (Throwable)e);
        }
        finally {
            try {
                ps.close();
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException sqle) {
                log.error("get DevCompatibleInfo List SQLException", (Throwable)sqle);
            }
        }
        return result;
    }
}

