/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import com.huawei.commextend.frameutil.asn.AsnEmsIfUpdateDevReq;
import com.huawei.commextend.frameutil.asn.AsnTopoRespMsg;
import com.huawei.commextend.frameutil.impl.DevCharsetCode;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevCharset {
    static final String DEFAULT_NM_CHARSET = "utf-8";
    static final int CHARSET_CMD_UPDATE = 19;
    private static final Logger logger = LoggerFactory.getLogger(DevCharset.class);
    private static final BigInteger RSP_RETURN = BigInteger.valueOf(0L);

    private DevCharset() {
    }

    public static int nmsToNE(int iDevID, String src, String dst) {
        int iRet = 0;
        String devCharset = DevCharsetCode.getCharset(iDevID);
        if (DEFAULT_NM_CHARSET.equals(devCharset)) {
            logger.info("[NMSToNE] nm is as same as dev, devCharset= " + devCharset + ", iDevID=" + iDevID);
            dst = src;
            return iRet;
        }
        iRet = DevCharsetCode.codeSetConvert(DEFAULT_NM_CHARSET, devCharset, src, dst);
        if (0 != iRet) {
            logger.info("[NMSToNE] iMAPCodeSetConvert failure, iDevID=" + iDevID + ",devCharset=" + devCharset + ",iRet=" + iRet);
        }
        return iRet;
    }

    public static int neToNMS(int iDevID, String src, String dst) {
        int iRet = 0;
        String devCharset = DevCharsetCode.getCharset(iDevID);
        if (DEFAULT_NM_CHARSET.equals(devCharset)) {
            logger.info("[NEToNMS] dev is as same as nms, devCharset= " + devCharset + ", iDevID=" + iDevID);
            dst = src;
            return iRet;
        }
        iRet = DevCharsetCode.codeSetConvert(devCharset, DEFAULT_NM_CHARSET, src, dst);
        if (0 != iRet) {
            logger.info("[NEToNMS] iMAPCodeSetConvert failure, iDevID=" + iDevID + ",devCharset=" + devCharset + ",iRet=" + iRet);
        }
        return iRet;
    }

    public static int updateDevCharset(int iDevID, String strCharset) {
        HashMap<Integer, String> mapCharset = new HashMap<Integer, String>();
        mapCharset.put(iDevID, strCharset);
        return DevCharset.updateDevCharset(mapCharset);
    }

    public static int updateDevCharset(Map mapDevCharset) {
        int TE_SUCCEED = 0;
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)19);
        msgHead.receiverProcID = (char)51;
        msgHead.receiverProcHandle = '\u0000';
        msgHead.receiverModule = 1;
        AsnEmsIfUpdateDevReq oReq = new AsnEmsIfUpdateDevReq();
        AsnTopoRespMsg oRsp = new AsnTopoRespMsg();
        Iterator iter = mapDevCharset.entrySet().iterator();
        int codeInt = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            oReq.iDevID = (BigInteger)key;
            oReq.strCodeSet = (byte[])entry.getValue();
            ProcessInfo info = ConnectManager.getDefaultProcessInfo();
            int iRet = MsgProxy.getProxyService((ProcessInfo)info).sendMessage(msgHead, (FStruct)oReq, (FStruct)oRsp);
            if (0 != iRet || RSP_RETURN != oRsp.iReturnCode) {
                logger.error("[UpdateDevCharset] SynSendMsg failure, iRet = " + iRet + "returnCode = " + oRsp.iReturnCode);
            }
            codeInt = Integer.parseInt((String)key);
            DevCharsetCode.updateCharset(codeInt, mapDevCharset.get(key).toString());
        }
        return TE_SUCCEED;
    }
}

