/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import com.huawei.commextend.frameutil.DBInfo;
import com.huawei.communicate.asn1.AsnNameList;
import com.huawei.communicate.asn1.AsnNameValue;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBInfoQuery {
    private static final String DB_PASSWORD = "password";
    private static final String DB_USER = "user";
    private static final String TYPE = "type";
    private static final String SERVER_NAME = "serverName";
    private static final String SERVER_PORT = "serverPort";
    private static final String SERVICE_NAME = "serviceName";
    private static final char FRAME_PROCID_MC = '\u0bb9';
    private static final int FRAMECMDCODE_GET_NMS_DBINFO = 4193200;
    public static final int SYBASE_DB = 0;
    public static final int SQLSERVER_DB = 1;
    public static final int ORACLE_DB = 2;
    private static final Logger log = LoggerFactory.getLogger(DBInfoQuery.class);

    private DBInfoQuery() {
    }

    private static Map<String, String> getDBinfoFromMC(String dbName) {
        MSGHead msgHead = MSGHeadBuilder.createMSGHead((int)4193200);
        msgHead.receiverProcID = (char)3001;
        msgHead.receiverProcHandle = '\u0000';
        msgHead.receiverModule = 0;
        AsnNameValue req = new AsnNameValue();
        req.name = dbName.getBytes();
        req.value = dbName.getBytes();
        AsnNameList rsp = new AsnNameList();
        IProxyService proxyService = MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo());
        int retcode = proxyService.sendMessage(msgHead, (FStruct)req, (FStruct)rsp, 60);
        if (retcode != 0) {
            log.error("getDBinfoFromMC send message fail, msg code is " + retcode);
            return null;
        }
        AsnNameValue result = (AsnNameValue)rsp.get(0);
        int resultCode = Integer.parseInt(new String(result.value));
        if (resultCode != 0) {
            log.error("getDBinfoFromMC mc query fail, resultCode is =" + resultCode);
            return null;
        }
        HashMap<String, String> dbMap = new HashMap<String, String>();
        for (int i = 1; i < rsp.size(); ++i) {
            AsnNameValue dbItem = (AsnNameValue)rsp.get(i);
            dbMap.put(new String(dbItem.name), new String(dbItem.value));
        }
        return dbMap;
    }

    public static Properties getDBProperties(String dbName) {
        Properties dbProperties = new Properties();
        try {
            DBInfo dbInfo = DBInfoQuery.getDBConfInfo(dbName);
            dbProperties.put("DatabaseType", "" + dbInfo.getDbType());
            dbProperties.put("DatabaseIP", dbInfo.getDbIPAdd());
            dbProperties.put("DatabasePort", dbInfo.getDbPort());
            dbProperties.put("UserName", dbInfo.getDbUserName());
            dbProperties.put("Password", dbInfo.getDbPasswd());
            dbProperties.put("ServiceName", dbInfo.getDbServiceName());
        }
        catch (Exception e) {
            log.error("getDBProperties error. ", (Throwable)e);
        }
        return dbProperties;
    }

    public static DBInfo getDBConfInfo(String dbName) {
        DBInfo dbInfo = new DBInfo();
        Map<String, String> dbInfoMap = DBInfoQuery.getDBinfoFromMC(dbName);
        if (null == dbInfoMap || dbInfoMap.isEmpty()) {
            log.error("getDBConfInfo is null, dbName is " + dbName);
            return dbInfo;
        }
        dbInfo.setDbIPAdd(dbInfoMap.get(SERVER_NAME));
        dbInfo.setDbPort(dbInfoMap.get(SERVER_PORT));
        dbInfo.setDbServiceName(dbInfoMap.get(SERVICE_NAME));
        dbInfo.setDbType(DBInfoQuery.converDBType(dbInfoMap.get(TYPE)));
        dbInfo.setDbName(dbName);
        dbInfo.setDbUserName(dbInfoMap.get(DB_USER));
        dbInfo.setDbPasswd(dbInfoMap.get(DB_PASSWORD));
        return dbInfo;
    }

    private static int converDBType(String typeStr) {
        String dbTypeStr = typeStr.toLowerCase(Locale.getDefault());
        if (dbTypeStr.startsWith("sqlserver")) {
            return 1;
        }
        if (dbTypeStr.startsWith("sybase")) {
            return 0;
        }
        return 2;
    }

    public static String getDBDriver(int dbType) {
        switch (dbType) {
            case 0: {
                return "com.sybase.jdbc3.jdbc.SybDriver";
            }
            case 1: {
                return "net.sourceforge.jtds.jdbc.Driver";
            }
            case 2: {
                return "oracle.jdbc.driver.OracleDriver";
            }
        }
        return "org.hsqldb.jdbcDriver";
    }

    public static String getDBConnURL(DBInfo dbInfo) {
        switch (dbInfo.getDbType()) {
            case 0: {
                return "jdbc:sybase:Tds:" + dbInfo.getDbIPAdd() + ":" + dbInfo.getDbPort() + "/" + dbInfo.getDbName();
            }
            case 1: {
                return "jdbc:jtds:sqlserver://" + dbInfo.getDbIPAdd() + ":" + dbInfo.getDbPort() + "/" + dbInfo.getDbName();
            }
            case 2: {
                return "jdbc:oracle:thin:@//" + dbInfo.getDbIPAdd() + ":" + dbInfo.getDbPort() + "/" + dbInfo.getDbServiceName();
            }
        }
        return "jdbc:hsqldb:.";
    }
}

