/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.frameutil;

import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.dbpool.DBPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonDBInfoUtil {
    private static final String USERCFG_PARAM_TBL = "tbl_usercfg_param";
    private static DBConfiguration dbConfiguration = DBConfiguration.getInstance();
    private static Logger logger = LoggerFactory.getLogger(CommonDBInfoUtil.class);
    private static final String STR_ITEM_NAME = "strItemName";
    private static final String STR_ITEM_VALUE = "strItemValue";

    private CommonDBInfoUtil() {
    }

    public static String getUserCfgInfo(String subSystemName, String itemName) {
        ArrayList<String> itemList = new ArrayList<String>();
        itemList.add(itemName);
        Map<String, String> itemNameAndValueList = CommonDBInfoUtil.getUserCfgInfoList(subSystemName, itemList);
        if (itemNameAndValueList == null) {
            return null;
        }
        return itemNameAndValueList.get(itemName);
    }

    public static Map<String, String> getUserCfgInfoList(String subSystemName, List<String> itemNameList) {
        String cfgInfoSql = CommonDBInfoUtil.composeCfgInfoSql(subSystemName, itemNameList);
        if (cfgInfoSql == null) {
            return null;
        }
        return CommonDBInfoUtil.getCfgInfoSqlResult(cfgInfoSql);
    }

    private static String composeCfgInfoSql(String subSystemName, List<String> itemNameList) {
        if (null == subSystemName || subSystemName.isEmpty()) {
            logger.error("CommonDBInfoUtil.composeCfgInfoSql: param=subSystemName is null or empty,return null. ");
            return null;
        }
        if (null == itemNameList || itemNameList.isEmpty()) {
            logger.error("CommonDBInfoUtil.composeCfgInfoSql: param=itemNameList is null or empty,return null. ");
            return null;
        }
        String subSql = " select strItemName,strItemValue   from " + dbConfiguration.tableName("MCDB", USERCFG_PARAM_TBL) + "  where strSubSystemName ='" + subSystemName + "'" + "        and " + STR_ITEM_NAME + " in(";
        StringBuilder sqlBuilder = new StringBuilder();
        for (String itemName : itemNameList) {
            if (null == itemName || itemName.isEmpty()) continue;
            sqlBuilder.append("'").append(itemName).append("',");
        }
        if (sqlBuilder.length() == 0) {
            logger.error("CommonDBInfoUtil.composeCfgInfoSql:all item in itemNameList is null or empty,return empty list ");
            return null;
        }
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        sqlBuilder.insert(0, subSql).append(")");
        return sqlBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getCfgInfoSqlResult(String cfgInfoSql) {
        HashMap<String, String> itemNameAndValueMap = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DBPool.getInstance().getConnection();
            if (null == conn) {
                logger.error("CommonDBInfoUtil.getCfgInfoSqlResult: get database connection error. ");
                Map<String, String> map = null;
                return map;
            }
            ps = conn.prepareStatement(cfgInfoSql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemNameAndValueMap.put(rs.getString(STR_ITEM_NAME), rs.getString(STR_ITEM_VALUE));
            }
        }
        catch (SQLException e) {
            logger.error("CommonDBInfoUtil.getCfgInfoSqlResult: get info from database error: ", (Throwable)e);
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("CommonDBInfoUtil.getCfgInfoSqlResult: close DBconnection ResultSet error:", (Throwable)e);
                }
            }
            if (null != ps) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error("CommonDBInfoUtil.getCfgInfoSqlResult: close DBconnection Statement error:", (Throwable)e);
                }
            }
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error("CommonDBInfoUtil.getCfgInfoSqlResult: close database connection error:", (Throwable)e);
                }
            }
        }
        return itemNameAndValueMap;
    }
}

