/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.eventmgr;

import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.dbpool.DBPool;
import com.huawei.commextend.deployment.notifymgr.NotifyHandler;
import com.huawei.commextend.deployment.notifymgr.NotifyMgr;
import com.huawei.commextend.deployment.notifymgr.asn.QAsnDeploymentNotify;
import com.huawei.commextend.eventmgr.EventDescription;
import com.huawei.commextend.eventmgr.EventKey;
import com.huawei.commextend.eventmgr.EventMessgeUtil;
import com.huawei.commextend.eventmgr.EventReceive;
import com.huawei.commextend.eventmgr.EventSubscibe;
import com.huawei.commextend.eventmgr.EventTask;
import com.huawei.communicate.core.CommHandle;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.receive.ILiteReceiver;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventUtil
implements NotifyHandler {
    static final int EMGR_OK = 0;
    static final int EMGR_FAIL = -1;
    static final int NUM_NEG_ONE = -1;
    static final int NUM_ZER0 = 0;
    static final int NUM_ONE = 1;
    static final int NUM_UC_MAX = 255;
    static final int NUM_US_MAX = 65535;
    static final int EVENT_TIMEOUT = 30;
    static final int MSG_REQUEST_NBC = 6;
    static final int LOW_PRIORITY_EVENT_PROCESS_TASK_ID = 30;
    private Map<EventKey, EventDescription> cmdTaskDesMap = new Hashtable<EventKey, EventDescription>();
    private static final int PARAM_NUM = 1;
    static final int WAIT_HANDLE_RESULT = 1;
    static final int NOWAIT_HANDLE_RESULT = 0;
    private Object m_SubscibeRwMutex = new Object();
    private static Map<ProcessInfo, EventUtil> cache = new HashMap<ProcessInfo, EventUtil>();
    private static final Logger logger = LoggerFactory.getLogger(EventUtil.class);
    private List<EventSubscibe> subscibeInfoList = new ArrayList<EventSubscibe>();
    private ProcessInfo processInfo;
    private EventReceive msgReceive = null;

    private EventUtil(ProcessInfo info) {
        this.processInfo = info;
        this.msgReceive = new EventReceive(info);
        IProxyService proxyServiece = MsgProxy.getProxyService((ProcessInfo)info);
        if (proxyServiece != null) {
            proxyServiece.addMessageListener(49154, (ILiteReceiver)this.msgReceive);
            NotifyMgr.registerNotifyListener(this);
            this.initSubscribEvents();
        }
    }

    public static synchronized EventUtil getEventUtil(ProcessInfo info) {
        if (cache.keySet().contains(info)) {
            return cache.get(info);
        }
        EventUtil instance = new EventUtil(info);
        cache.put(info, instance);
        return instance;
    }

    public static void removeEventProxy(ProcessInfo info) {
        EventUtil proxy = cache.remove(info);
        if (null != proxy) {
            NotifyMgr.unRegisterNotifyListener(proxy);
            proxy.cmdTaskDesMap.clear();
            proxy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSubscribEvents() {
        block19: {
            String strSql = 2 == DBConfiguration.getInstance().getDbType() ? "select iEventID, iProcID, iProcHandle, iHandlerID, iModule, iPriority from MCDB.tbl_EventSubscibe" : "select iEventID, iProcID, iProcHandle, iHandlerID, iModule, iPriority from MCDB..tbl_EventSubscibe";
            Connection conn = null;
            Statement pstm = null;
            ResultSet rs = null;
            try {
                conn = DBPool.getInstance().getConnection();
                pstm = conn.createStatement();
                rs = pstm.executeQuery(strSql);
                if (!rs.next()) break block19;
                Object object = this.m_SubscibeRwMutex;
                synchronized (object) {
                    this.subscibeInfoList.clear();
                    while (rs.next()) {
                        EventSubscibe oOneRecord = new EventSubscibe();
                        oOneRecord.mEventID = rs.getInt("iEventID");
                        oOneRecord.mProcID = rs.getInt("iProcID");
                        oOneRecord.mProcHandle = rs.getInt("iProcHandle");
                        oOneRecord.mHandlerID = rs.getInt("iHandlerID");
                        oOneRecord.mModule = rs.getInt("iModule");
                        oOneRecord.mPriority = rs.getInt("iPriority");
                        if (oOneRecord.mEventID > 0 && oOneRecord.mHandlerID > 0 && oOneRecord.mProcID >= 1 && oOneRecord.mProcHandle >= -1 && oOneRecord.mProcHandle <= 65535 && oOneRecord.mPriority <= 1) {
                            this.subscibeInfoList.add(oOneRecord);
                            logger.info("insert record success. " + oOneRecord);
                            continue;
                        }
                        logger.error("discard record. " + oOneRecord);
                    }
                }
                logger.info("TEEventMgrEx.getDBData get subsrcibe information success from db.");
            }
            catch (SQLException e) {
                logger.error("EventUtil getDBData is error: " + e);
            }
            finally {
                try {
                    if (null != pstm) {
                        pstm.close();
                    }
                    if (null != rs) {
                        rs.close();
                    }
                    if (null != conn) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    logger.error("Close connection is error:" + e);
                }
            }
        }
    }

    public int postEvent(int eventId, FStruct pParam) {
        if (null == pParam) {
            logger.error("TEEventMgrEx.postEvent event is null.");
            return -1;
        }
        int iResult = this.sendEventMsg(eventId, pParam);
        logger.info("TEEventMgrEx.postEvent send success. eventId=" + eventId + ",sendmsgCount=" + iResult);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendEventMsg(int eventId, FStruct pParam) {
        int iSendCount = 0;
        Object object = this.m_SubscibeRwMutex;
        synchronized (object) {
            EventSubscibe eventSubscibe = null;
            int m = this.subscibeInfoList.size();
            for (int i = 0; i < m; ++i) {
                byte[] pBuf;
                eventSubscibe = this.subscibeInfoList.get(i);
                if (eventSubscibe.mEventID != eventId || null == (pBuf = EventMessgeUtil.toByte(eventSubscibe.mEventID, eventSubscibe.mHandlerID, pParam))) continue;
                MSGHead head = MSGHeadBuilder.buildMSGHead((int)49154, (ProcessInfo)new ProcessInfo(Character.valueOf((char)eventSubscibe.mProcID), Character.valueOf((char)eventSubscibe.mProcHandle)));
                head.receiverModule = (byte)eventSubscibe.mModule;
                MSGPacketExt packetExt = new MSGPacketExt(head, pBuf);
                CommHandle commHandle = (CommHandle)MsgProxy.getCommService((ProcessInfo)this.processInfo);
                try {
                    commHandle.sendAsyncMessage(packetExt, null);
                    ++iSendCount;
                    continue;
                }
                catch (IOException e) {
                    logger.error("sendEventMsg fail" + eventSubscibe, (Throwable)e);
                }
            }
        }
        return iSendCount;
    }

    public int registerEvent(Class taskClass) {
        boolean isDoTaskMethod = false;
        Method[] method = taskClass.getMethods();
        Class<?> reqClass = null;
        for (int i = 0; i < method.length; ++i) {
            isDoTaskMethod = method[i].isAnnotationPresent(EventTask.class);
            if (!isDoTaskMethod) continue;
            EventTask eventTask = method[i].getAnnotation(EventTask.class);
            int eventID = eventTask.eventID();
            int handleID = eventTask.handlerID();
            try {
                if (!this.isValidateMethod(method[i])) continue;
                Class<?>[] paramTypes = method[i].getParameterTypes();
                reqClass = paramTypes[0];
                EventDescription eventDesObj = new EventDescription(taskClass, eventID, handleID, reqClass, method[i]);
                this.cmdTaskDesMap.put(new EventKey(eventID, handleID), eventDesObj);
                continue;
            }
            catch (Exception e) {
                logger.error("Register task (" + eventTask.toString() + ") fail!", (Throwable)e);
            }
        }
        return 0;
    }

    private boolean isValidateMethod(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 1 && FStruct.class.isAssignableFrom(paramTypes[0])) {
            return true;
        }
        logger.info("Task Method Paramter Types Error, method:" + method.toString());
        return false;
    }

    public void receiveEvent(MSGPacketExt eventMsg) {
        int handleID;
        if (!EventMessgeUtil.validData(eventMsg.getData())) {
            logger.debug("EventMessge is invalid! " + eventMsg);
            return;
        }
        int eventID = EventMessgeUtil.parseEventID(eventMsg.getData());
        EventDescription eventDes = this.cmdTaskDesMap.get(new EventKey(eventID, handleID = EventMessgeUtil.parseHandlerID(eventMsg.getData())));
        if (null != eventDes) {
            try {
                FStruct eventASN = (FStruct)eventDes.getReq().newInstance();
                AsnCoder.deserialize((byte[])EventMessgeUtil.parseAsnData(eventMsg.getData()), (FStruct)eventASN);
                Object handleClass = eventDes.getEventClass().newInstance();
                Method handleMethod = eventDes.geteventMethod();
                handleMethod.invoke(handleClass, eventASN);
            }
            catch (Exception e) {
                logger.error("Task Method Paramter Types Error, method:", (Throwable)e);
            }
        } else {
            logger.debug("Event not register! eventID = " + eventID + ", handleID = " + handleID);
        }
        this.sendEventReciveResponse(eventMsg);
    }

    private void sendEventReciveResponse(MSGPacketExt eventMsg) {
        try {
            CommHandle commHandle = (CommHandle)MsgProxy.getCommService((ProcessInfo)this.processInfo);
            MSGHead rspHead = MSGHeadBuilder.convertToResoponseMSGHead((MSGHead)eventMsg.mheader);
            MSGPacketExt rspmsg = new MSGPacketExt(rspHead, eventMsg.getData());
            commHandle.sendAsyncMessage(rspmsg, null);
        }
        catch (Exception e) {
            logger.error("sendEventReciveResponse,eventMsg=" + eventMsg, (Throwable)e);
        }
    }

    public void handleNotify(QAsnDeploymentNotify notify) {
        String actionStr = new String(notify.action);
        if (actionStr.equalsIgnoreCase("FINISH_ADD_INSTANCE") || actionStr.equalsIgnoreCase("FINISH_DEL_INSTANCE")) {
            logger.info("Receiver deploment action:" + actionStr);
            this.initSubscribEvents();
        }
    }
}

