/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.eventmgr;

import com.huawei.communicate.core.CommUtil;
import com.huawei.communicate.util.asn.AsnCoder;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventMessgeUtil {
    private static final int EVENTID_LENGTH = 4;
    private static final int EVENTID_BEGINPOS = 0;
    private static final int HANDLERID_BEGINPOS = 4;
    private static final int ASNDATA_BEGINPOS = 18;
    private static final Logger logger = LoggerFactory.getLogger(EventMessgeUtil.class);

    private EventMessgeUtil() {
    }

    public static byte[] toByte(int eventID, int handlerID, FStruct eventASN) {
        byte[] dataBuf = null;
        try {
            byte[] ansBuf = AsnCoder.serialize((FStruct)eventASN);
            dataBuf = new byte[18 + ansBuf.length];
            byte[] eventIDBytes = CommUtil.intToBytes((int)eventID);
            System.arraycopy(eventIDBytes, 0, dataBuf, 0, 4);
            byte[] handlerIDBytes = CommUtil.intToBytes((int)handlerID);
            System.arraycopy(handlerIDBytes, 0, dataBuf, 4, 4);
            System.arraycopy(ansBuf, 0, dataBuf, 18, ansBuf.length);
        }
        catch (Exception e) {
            logger.error("EventMessgeUtil toByte is error, eventID :" + eventID + e);
        }
        return dataBuf;
    }

    public static boolean validData(byte[] originData) {
        return originData.length >= 18;
    }

    public static int parseEventID(byte[] originData) {
        byte[] bytes = new byte[4];
        System.arraycopy(originData, 0, bytes, 0, 4);
        return CommUtil.bytesToInt((byte[])bytes);
    }

    public static int parseHandlerID(byte[] originData) {
        byte[] bytes = new byte[4];
        System.arraycopy(originData, 4, bytes, 0, 4);
        return CommUtil.bytesToInt((byte[])bytes);
    }

    public static byte[] parseAsnData(byte[] originData) {
        int dataLength = originData.length;
        int pBufferLength = dataLength - 18;
        byte[] asnBuffer = new byte[pBufferLength];
        System.arraycopy(originData, 18, asnBuffer, 0, pBufferLength);
        return asnBuffer;
    }
}

