/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.dbpool;

import com.huawei.commextend.dbpool.DBConfiguration;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBPool {
    public static final String MCDB_NAME = "MCDB";
    private static final int MIN_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = 20;
    private static final int MAX_STATEMENTS = 50;
    private static final int MAX_IDLE_TIMES = 60;
    private static Logger log = LoggerFactory.getLogger(DBPool.class);
    private static DBPool instance = null;
    private static ComboPooledDataSource dataSource;

    private DBPool() {
        try {
            DBConfiguration dbConf = DBConfiguration.getInstance();
            String jdbcDriverClass = "";
            String jdbcUrl = "";
            switch (dbConf.getDbType()) {
                case 1: {
                    jdbcDriverClass = "net.sourceforge.jtds.jdbc.Driver";
                    jdbcUrl = "jdbc:jtds:sqlserver://" + dbConf.getDbIPAdd() + ":" + dbConf.getDbPort() + "/" + MCDB_NAME;
                    break;
                }
                case 0: {
                    jdbcDriverClass = "com.sybase.jdbc3.jdbc.SybDriver";
                    jdbcUrl = "jdbc:sybase:Tds:" + dbConf.getDbIPAdd() + ":" + dbConf.getDbPort() + "/" + MCDB_NAME;
                    break;
                }
                case 2: {
                    jdbcDriverClass = "oracle.jdbc.driver.OracleDriver";
                    jdbcUrl = "jdbc:oracle:thin:@//" + dbConf.getDbIPAdd() + ":" + dbConf.getDbPort() + "/" + dbConf.getServiceName();
                    break;
                }
                default: {
                    log.error("DateBase Type error(Sybase:0,SQLServer:1,Oracle:2),Current Type is " + dbConf.getDbType());
                }
            }
            dataSource = new ComboPooledDataSource();
            dataSource.setUser(dbConf.getUserName());
            dataSource.setPassword(dbConf.getPassword());
            dataSource.setJdbcUrl(jdbcUrl);
            dataSource.setDriverClass(jdbcDriverClass);
            dataSource.setMinPoolSize(1);
            dataSource.setMaxPoolSize(20);
            dataSource.setMaxStatements(50);
            dataSource.setMaxIdleTime(60);
            log.info("C3P0 using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl);
        }
        catch (Exception e) {
            log.error("Create DBPool Fail!", (Throwable)e);
        }
    }

    public static synchronized DBPool getInstance() {
        if (null == instance) {
            instance = new DBPool();
        }
        return instance;
    }

    public Connection getConnection() {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            log.error("Get Connection Fail. ", (Throwable)e);
            return null;
        }
    }

    public void closeDataSource() {
        if (null != dataSource) {
            dataSource.close();
        }
    }
}

