/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.dbpool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBConfiguration {
    private static DBConfiguration instance = null;
    private static Logger logger = LoggerFactory.getLogger(DBConfiguration.class);
    public static final String DB_TYPE = "DatabaseType";
    public static final String DB_IP = "DatabaseIP";
    public static final String DB_PORT = "DatabasePort";
    public static final String USER_NAME = "UserName";
    public static final String PASSWORD = "Password";
    public static final String SERVICE_NAME = "ServiceName";
    public static final int SYBASE_DB = 0;
    public static final int SQLSERVER_DB = 1;
    public static final int ORACLE_DB = 2;
    private String dbIPAdd;
    private int dbPort;
    private int dbType;
    private String userName;
    private String password;
    private String serviceName;

    private DBConfiguration() {
    }

    public static synchronized DBConfiguration getInstance() {
        if (null == instance) {
            instance = new DBConfiguration();
        }
        return instance;
    }

    public void initDBConf(String configFilename) {
        this.initDBConf(this.getURL(configFilename));
    }

    public void initDBConf(URL configURL) {
        Properties properties = this.load(configURL);
        this.initDBConf(properties);
    }

    public void initDBConf(Properties properties) {
        this.dbType = Integer.parseInt(properties.getProperty(DB_TYPE));
        this.dbIPAdd = properties.getProperty(DB_IP);
        this.userName = properties.getProperty(USER_NAME);
        this.password = properties.getProperty(PASSWORD);
        this.dbPort = Integer.parseInt(properties.getProperty(DB_PORT));
        this.serviceName = properties.getProperty(SERVICE_NAME);
    }

    private URL getURL(String configFilename) {
        File file = new File(configFilename);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            logger.error("config failed, configFilename = " + configFilename, (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private Properties load(URL configURL) {
        if (null == configURL) {
            throw new IllegalArgumentException();
        }
        InputStream in = null;
        Properties properties = new Properties();
        try {
            in = configURL.openStream();
            properties.load(in);
        }
        catch (IOException ex) {
            logger.error("config failed, configURL = " + configURL, (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.error("close stream failed", (Throwable)ex);
                }
            }
        }
        return properties;
    }

    public String getDbIPAdd() {
        return this.dbIPAdd;
    }

    public int getDbType() {
        return this.dbType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDbPort() {
        return this.dbPort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String tableName(String dbName, String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(dbName);
        if (2 == this.dbType) {
            buffer.append('.');
        } else {
            buffer.append("..");
        }
        buffer.append(tableName);
        return buffer.toString();
    }
}

