/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.commextend.dbbackupblockapp;

import com.huawei.commextend.dbbackupblockapp.DBBackupReceiver;
import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.dbpool.DBPool;
import com.huawei.commextend.reliableevent.ReliableEventProxy;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.util.receive.ILiteReceiver;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBBackupFrame {
    static final int UF_CMD_DBBACKUP_START = 4193195;
    static final int UF_CMD_DBBACKUP_FINISH = 4193196;
    private static final int LEAVE_TIMEOUT = 600000;
    private static final int DBBACKUP_TIMEOUT = 2400;
    private static final int REFRESH_TIME = 300000;
    private static Logger log = LoggerFactory.getLogger(DBBackupFrame.class);
    private static Map<ProcessInfo, DBBackupFrame> instanceCache = new HashMap<ProcessInfo, DBBackupFrame>();
    private static boolean bDBBackupFlg = false;
    private static ILiteReceiver dbBackupReceiver;
    private static Timer refreshTimer;
    private static long startCleanTime;
    private ProcessInfo processInfo;
    private Set<Integer> suspendRelEvtIDLst = null;
    private Map<String, Status> statusCache = new Hashtable<String, Status>();

    private DBBackupFrame(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBBackupFrame getInstance(ProcessInfo processInfo) {
        Map<ProcessInfo, DBBackupFrame> map = instanceCache;
        synchronized (map) {
            DBBackupFrame instance = instanceCache.get(processInfo);
            if (null == instance) {
                instance = new DBBackupFrame(processInfo);
                instanceCache.put(processInfo, instance);
            }
            return instance;
        }
    }

    public String enter(String strAppName) {
        String handle = null;
        if (!bDBBackupFlg) {
            handle = strAppName + "_" + Thread.currentThread().getId() + "_" + Thread.currentThread().getName();
            if (this.statusCache.containsKey(handle)) {
                log.error("The handle had been enter, Please leave first.handle=" + handle);
                return null;
            }
            this.statusCache.put(handle, Status.running);
            log.info("enter success, the handle=" + handle);
        }
        return handle;
    }

    public void leave(String handle) {
        if (null == handle || !this.statusCache.containsKey(handle)) {
            log.warn("The handle is not exist, handle = " + handle);
            return;
        }
        if (this.statusCache.get(handle) == Status.suspend) {
            log.error("leave fail, the handle is suspend. handle=" + handle);
        } else {
            this.statusCache.remove(handle);
            log.info("leave success, the handle=" + handle);
        }
    }

    public boolean isBlock() {
        return bDBBackupFlg;
    }

    public long timeToStart() {
        long timeToStart = -1L;
        if (bDBBackupFlg) {
            timeToStart = 600000L - (System.currentTimeMillis() - startCleanTime);
            timeToStart = timeToStart < 0L ? 0L : (timeToStart /= 1000L);
        }
        return timeToStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(String handle) {
        if (!bDBBackupFlg) {
            log.error("The dbBackupFlg is false, the status not suspend!!");
            return;
        }
        if (null == handle || !this.statusCache.containsKey(handle)) {
            log.error("suspend fail,The handle is not exist, handle = " + handle);
            return;
        }
        log.info("suspend success, the handle=" + handle);
        this.statusCache.put(handle, Status.suspend);
        try {
            String string = handle;
            synchronized (string) {
                handle.wait();
            }
        }
        catch (InterruptedException e) {
            log.error("suspend fail, the nHandle=" + handle, (Throwable)e);
        }
    }

    public void suspendRelEvtOnBackup(Set<Integer> eventIDs) {
        this.suspendRelEvtIDLst = eventIDs;
        if (bDBBackupFlg) {
            this.suspendRelEvt();
        }
        log.info("suspend RelEvtonBackup, the processInfo=" + this.processInfo + ",eventIDs=" + eventIDs);
    }

    public void suspendAllRelEvtOnBackup() {
        this.suspendRelEvtIDLst = new HashSet<Integer>();
        if (bDBBackupFlg) {
            this.suspendRelEvt();
        }
        log.info("suspend All RelEvtonBackup, the processInfo=" + this.processInfo);
    }

    static void clean() {
        log.info("Start clean..................");
        startCleanTime = System.currentTimeMillis();
        bDBBackupFlg = true;
        Collection<DBBackupFrame> allInstance = instanceCache.values();
        for (DBBackupFrame dbBackupFrame : allInstance) {
            while (dbBackupFrame.statusCache.containsValue((Object)Status.running) && dbBackupFrame.timeToStart() > 0L) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    log.error("Wait for app leave/suspend fail.", (Throwable)e);
                }
            }
            for (Map.Entry<String, Status> entry : dbBackupFrame.statusCache.entrySet()) {
                Status status = entry.getValue();
                if (status != Status.running) continue;
                log.warn("Force clean, the App is Running ,handle=" + entry.getKey());
            }
            dbBackupFrame.suspendRelEvt();
        }
        log.info("End clean..................");
    }

    private void suspendRelEvt() {
        if (null != this.suspendRelEvtIDLst) {
            if (this.suspendRelEvtIDLst.isEmpty()) {
                ReliableEventProxy.getInstance(this.processInfo).interruptEventRcv();
            } else {
                ReliableEventProxy.getInstance(this.processInfo).interruptEventRcvByEvtID(this.suspendRelEvtIDLst);
            }
        }
    }

    static void cancelClean() {
        if (!bDBBackupFlg) {
            log.warn("The DBBackupFrame head been cancel clean!!!!");
        }
        log.info("Start Cancel Clean..................");
        bDBBackupFlg = false;
        Collection<DBBackupFrame> allInstance = instanceCache.values();
        for (DBBackupFrame dbBackupFrame : allInstance) {
            if (null != dbBackupFrame.suspendRelEvtIDLst) {
                if (dbBackupFrame.suspendRelEvtIDLst.isEmpty()) {
                    ReliableEventProxy.getInstance(dbBackupFrame.processInfo).resumeEventRcv();
                } else {
                    ReliableEventProxy.getInstance(dbBackupFrame.processInfo).resumeEventRcvByEvtID(dbBackupFrame.suspendRelEvtIDLst);
                }
            }
            dbBackupFrame.notifyAllApp();
        }
        log.info("End Cancel Clean..................");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllApp() {
        for (Map.Entry<String, Status> entry : this.statusCache.entrySet()) {
            String handle = entry.getKey();
            Status status = entry.getValue();
            if (status != Status.suspend) continue;
            entry.setValue(Status.running);
            String string = handle;
            synchronized (string) {
                handle.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean queryDBBackupFlg() {
        boolean dbBackupFlg = false;
        Connection conn = DBPool.getInstance().getConnection();
        if (null == conn) {
            log.info("Get DB Connection Fail.");
            return dbBackupFlg;
        }
        CallableStatement cstmt = null;
        String procname = "{? = call ip_GetTimeDiffForDbBackup}";
        if (2 == DBConfiguration.getInstance().getDbType()) {
            procname = "{call MCDB.ip_GetTimeDiffForDbBackup(?)}";
        }
        try {
            cstmt = conn.prepareCall(procname);
            cstmt.registerOutParameter(1, 4);
            cstmt.execute();
            long timeout = cstmt.getLong(1);
            log.info("ip_GetTimeDiffForDbBackup return:" + timeout);
            if (timeout <= 2400L && timeout >= 0L) {
                dbBackupFlg = true;
            } else {
                log.warn("The dbBackup Flag is invalidate.");
            }
        }
        catch (SQLException e) {
            log.error("Exec ip_GetTimeDiffForDbBackup fail.", (Throwable)e);
        }
        finally {
            if (null != cstmt) {
                try {
                    cstmt.close();
                }
                catch (SQLException e) {
                    log.error("Close Statement Fail.", (Throwable)e);
                }
            }
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error("Close Connection Fail.", (Throwable)e);
                }
            }
        }
        log.info("The DBBackupFlg is :" + dbBackupFlg);
        return dbBackupFlg;
    }

    private void release() {
        this.statusCache.clear();
        this.suspendRelEvtIDLst.clear();
    }

    public static void removeDBBackupFrame(ProcessInfo processInfo) {
        DBBackupFrame dbBackupFrame = instanceCache.remove(processInfo);
        if (null != dbBackupFrame) {
            dbBackupFrame.release();
        }
    }

    public static void removeAllDBBackupFrame() {
        refreshTimer.cancel();
        Collection<DBBackupFrame> allInstance = instanceCache.values();
        for (DBBackupFrame dbBackupFrame : allInstance) {
            dbBackupFrame.release();
        }
        instanceCache.clear();
        dbBackupReceiver = null;
    }

    static {
        refreshTimer = new Timer("DBBackupFrame.refreshTimer");
        dbBackupReceiver = new DBBackupReceiver();
        bDBBackupFlg = DBBackupFrame.queryDBBackupFlg();
        MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo()).addMessageListener(4193195, dbBackupReceiver);
        MsgProxy.getProxyService((ProcessInfo)Configuration.getInstance().getDefaultProcessInfo()).addMessageListener(4193196, dbBackupReceiver);
        refreshTimer.schedule((TimerTask)new RefrashDBBackupFlgTask(), 300000L, 300000L);
    }

    static class RefrashDBBackupFlgTask
    extends TimerTask {
        RefrashDBBackupFlgTask() {
        }

        public void run() {
            boolean newFlg = DBBackupFrame.queryDBBackupFlg();
            if (bDBBackupFlg && !newFlg) {
                DBBackupFrame.cancelClean();
            }
            bDBBackupFlg = newFlg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        running,
        suspend;

    }
}

