/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.uflight.trapconnector.ITrapMsgListener;
import com.huawei.uflight.trapconnector.TrapCommManager;
import com.huawei.uflight.trapconnector.core.CommTimeoutChecker;
import com.huawei.uflight.trapconnector.core.DataAccepter;
import com.huawei.uflight.trapconnector.core.MSGListener;
import com.huawei.uflight.trapconnector.core.TrapCommHandle;
import com.huawei.uflight.trapconnector.core.TrapMSGPacket;
import com.huawei.uflight.trapconnector.core.UnknownCommandReceiver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TrapMsgDispatcher
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(TrapMsgDispatcher.class);
    private volatile boolean running = true;
    private TrapCommHandle m_Handle = null;
    private DataAccepter accepter = null;
    private CommTimeoutChecker checker = null;
    private Hashtable<Integer, MSGListener> receivers = new Hashtable();
    private static final AtomicInteger threadNum = new AtomicInteger(0);

    TrapMsgDispatcher(TrapCommHandle handle, DataAccepter accepter) {
        logger.info("Init MsgDispatcher.");
        this.m_Handle = handle;
        this.accepter = accepter;
        this.setName(this.getClass().getName() + threadNum.getAndIncrement());
        this.checker = new CommTimeoutChecker(this);
        this.checker.start();
    }

    public void addMessageReceiver(int msgID, MSGListener listener, int cmdCode, int times) {
        this.receivers.put(msgID, listener);
        if (times >= 1000) {
            this.checker.addItem(msgID, cmdCode, times);
        } else {
            this.checker.addItem(msgID, cmdCode, this.m_Handle.getTimeout());
        }
    }

    public void removeReceiver(int msgID) {
        this.receivers.remove(msgID);
    }

    void removeReceiver(MSGListener listener) {
        if (listener == null) {
            logger.info("MSGListener is null");
            return;
        }
        Enumeration<Integer> msgID = this.receivers.keys();
        while (msgID.hasMoreElements()) {
            int cmdHandle = msgID.nextElement();
            if (!this.receivers.get(cmdHandle).equals(listener)) continue;
            this.removeReceiver(cmdHandle);
            this.removeTimeoutItem(cmdHandle);
        }
    }

    public void cancelReceivers() {
        logger.info("invoke cancel receivers!");
        if (null != this.m_Handle && this.m_Handle.isClosed()) {
            this.receivers.clear();
        }
    }

    void removeTimeoutItem(int msgID) {
        this.checker.removeItem(msgID);
    }

    void refreshTimeoutValue(int newValue, int msgID) {
        this.checker.refreshTimeoutValue(newValue, msgID);
    }

    boolean checkTimeout(int msgID) {
        return true;
    }

    @Override
    public void run() {
        while (this.running) {
            TrapMSGPacket msg = this.accepter.getMessage();
            if (msg == null) {
                logger.info("MsgDispatcher(): MSGPacketExt is NULL");
                continue;
            }
            this.m_Handle.refresh();
            switch (msg.getMheader().getMsgType()) {
                case 3: {
                    if (3 == msg.getCmdCode()) break;
                    this.dispatchReceiver(msg);
                    break;
                }
                case 1: 
                case 2: {
                    this.dispatchListener(msg);
                    break;
                }
            }
        }
        this.m_Handle = null;
        this.accepter = null;
        this.checker = null;
        logger.info("MsgDispatcher exited.");
    }

    private void dispatchListener(TrapMSGPacket msg) {
        int code = msg.getCmdCode();
        List<ITrapMsgListener> listeners = TrapCommManager.getInstance(new ProcessInfo(Character.valueOf(this.m_Handle.getProcID()), Character.valueOf(this.m_Handle.getProcHandle()))).getListener(code);
        if (listeners != null) {
            try {
                Object[] tempArray = listeners.toArray();
                for (int i = 0; i < tempArray.length; ++i) {
                    ITrapMsgListener listener = (ITrapMsgListener)tempArray[i];
                    listener.processMessage(msg);
                }
            }
            catch (Exception ex) {
                logger.error("error", (Throwable)ex);
            }
        } else {
            UnknownCommandReceiver.INSTANCE.receiveMessage(msg);
        }
    }

    private void dispatchReceiver(TrapMSGPacket packet) {
        int msgID = packet.getMheader().getMsgID();
        MSGListener recv = this.receivers.get(msgID);
        if (recv != null) {
            int timeout = this.checker.removeItem(msgID);
            logger.info("invoke MSGListener's receiveMessage() method.", (Object)packet);
            if (recv.receiveMessage(packet)) {
                this.receivers.remove(msgID);
            } else if (timeout > 0) {
                this.checker.addItem(msgID, packet.getCmdCode(), timeout);
            }
        } else {
            logger.info("The receiver had been removed, msgID=" + msgID);
        }
    }

    void timeout(int cmdCode, int msgID) {
        MSGListener receiver = null;
        receiver = this.receivers.remove(msgID);
        if (receiver != null) {
            TrapCommHandle.logTrace("MsgDispatcher timeout in: ", cmdCode, msgID);
            receiver.timeout(cmdCode, msgID);
            TrapCommHandle.logTrace("MsgDispatcher timeout out: ", cmdCode, msgID);
        }
    }

    public void close() {
        logger.info("Close MsgDispatcher.");
        this.running = false;
        if (this.checker != null) {
            this.checker.close();
        }
        this.cancelReceivers();
    }
}

